/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.examples.databinding.snippets;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.sideeffect.ISideEffect;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.jface.databinding.viewers.IViewerObservableList;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SnippetComputedValueViewerSelection {
    public static void main(String[] args) {
        Display display = new Display();
        Realm.runWithDefault((Realm)DisplayRealm.getRealm((Display)display), () -> {
            Shell shell = new View().createShell();
            while (!shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        });
    }

    static class View {
        private Button deleteSelectionButton;
        private TableViewer tableViewer;

        View() {
        }

        public Shell createShell() {
            Display display = Display.getDefault();
            Shell shell = new Shell(display);
            GridLayoutFactory.swtDefaults().numColumns(2).applyTo((Composite)shell);
            this.tableViewer = new TableViewer((Composite)shell);
            GridDataFactory.fillDefaults().grab(true, true).applyTo(this.tableViewer.getControl());
            this.tableViewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
            WritableList input = new WritableList();
            input.add((Object)"Stefan Xenos");
            input.add((Object)"Lars Vogel");
            input.add((Object)"Dirk Fauth");
            input.add((Object)"Elena Laskavaia");
            input.add((Object)"Simon Scholz");
            this.tableViewer.setInput((Object)input);
            this.deleteSelectionButton = new Button((Composite)shell, 8);
            this.deleteSelectionButton.setLayoutData((Object)new GridData(1, 128, false, false));
            this.deleteSelectionButton.setText("X");
            this.deleteSelectionButton.addSelectionListener((SelectionListener)new SelectionAdapter((IObservableList)input){
                private final /* synthetic */ IObservableList val$input;
                {
                    this.val$input = iObservableList;
                }

                public void widgetSelected(SelectionEvent e) {
                    List list = tableViewer.getStructuredSelection().toList();
                    this.val$input.removeAll((Collection)list);
                }
            });
            this.bindData();
            shell.pack();
            shell.open();
            return shell;
        }

        private void bindData() {
            IViewerObservableList viewerSelectionObservable = ViewerProperties.multipleSelection().observe((Viewer)this.tableViewer);
            IObservableValue hasSelectionObservable = ComputedValue.create(() -> !viewerSelectionObservable.isEmpty());
            ISideEffect deleteButtonEnablementSideEffect = ISideEffect.create(() -> ((IObservableValue)hasSelectionObservable).getValue(), arg_0 -> ((Button)this.deleteSelectionButton).setEnabled(arg_0));
            this.deleteSelectionButton.addDisposeListener(e -> deleteButtonEnablementSideEffect.dispose());
        }
    }
}

