/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.examples.databinding.snippets;

import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.sideeffect.ISideEffectFactory;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.swt.WidgetSideEffects;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class SnippetSideEffectTwoWayBinding {
    public static void main(String[] args) {
        Display display = new Display();
        Realm.runWithDefault((Realm)DisplayRealm.getRealm((Display)display), () -> {
            Task task = new Task();
            Shell shell = new View(task).createShell();
            Display display1 = Display.getCurrent();
            while (!shell.isDisposed()) {
                if (display1.readAndDispatch()) continue;
                display1.sleep();
            }
        });
    }

    static class Task {
        private WritableValue<String> summary = new WritableValue((Object)"Learn Databinding", String.class);

        Task() {
        }

        public String getSummary() {
            return (String)this.summary.getValue();
        }

        public void setSummary(String summary) {
            this.summary.setValue((Object)summary);
        }
    }

    static class View {
        private Task task;
        private Text summaryText;

        public View(Task task) {
            this.task = task;
        }

        public Shell createShell() {
            Display display = Display.getDefault();
            Shell shell = new Shell(display);
            GridLayoutFactory.fillDefaults().applyTo((Composite)shell);
            GridDataFactory gridDataFactory = GridDataFactory.fillDefaults().grab(true, false);
            this.summaryText = new Text((Composite)shell, 2048);
            gridDataFactory.applyTo((Control)this.summaryText);
            Button setSummaryBtn = new Button((Composite)shell, 8);
            gridDataFactory.applyTo((Control)setSummaryBtn);
            setSummaryBtn.setText("Set Task summary to \"done learning\"");
            setSummaryBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    task.setSummary("done learning");
                }
            });
            Button printButton = new Button((Composite)shell, 8);
            gridDataFactory.applyTo((Control)printButton);
            printButton.setText("Print Task summary");
            printButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    System.out.println(task.getSummary());
                }
            });
            this.bindData();
            shell.pack();
            shell.open();
            return shell;
        }

        private void bindData() {
            ISideEffectFactory sideEffectFactory = WidgetSideEffects.createFactory((Widget)this.summaryText);
            ISWTObservableValue textModifyObservable = WidgetProperties.text((int)24).observe((Widget)this.summaryText);
            sideEffectFactory.create(this.task::getSummary, arg_0 -> ((Text)this.summaryText).setText(arg_0));
            sideEffectFactory.create(() -> ((IObservableValue)textModifyObservable).getValue(), this.task::setSummary);
        }
    }
}

