/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding.conformance;

import junit.framework.Test;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.jface.databinding.conformance.ObservableDelegateTest;
import org.eclipse.jface.databinding.conformance.delegate.IObservableContractDelegate;
import org.eclipse.jface.databinding.conformance.util.CurrentRealm;
import org.eclipse.jface.databinding.conformance.util.DisposeEventTracker;
import org.eclipse.jface.databinding.conformance.util.RealmTester;
import org.eclipse.jface.databinding.conformance.util.SuiteBuilder;

public class ObservableContractTest
extends ObservableDelegateTest {
    private IObservable observable;
    private IObservableContractDelegate delegate;

    public ObservableContractTest(IObservableContractDelegate delegate) {
        this(null, delegate);
    }

    public ObservableContractTest(String testName, IObservableContractDelegate delegate) {
        super(testName, delegate);
        this.delegate = delegate;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.observable = this.getObservable();
    }

    public void testConstruction_CallsObservableCreated() {
        IObservable[] created = new IObservable[1];
        IObservable[] collected = ObservableTracker.runAndCollect(() -> {
            IObservable iObservable = this.delegate.createObservable(new CurrentRealm(true));
        });
        ObservableContractTest.assertTrue((collected.length > 0 ? 1 : 0) != 0);
        boolean wasCollected = false;
        int i = 0;
        while (i < collected.length) {
            if (collected[i] == created[0]) {
                wasCollected = true;
            }
            ++i;
        }
        ObservableContractTest.assertTrue((boolean)wasCollected);
    }

    public void testGetRealm_NotNull() throws Exception {
        ObservableContractTest.assertNotNull((String)this.formatFail("The observable's realm should not be null."), (Object)this.observable.getRealm());
    }

    public void testChange_ChangeEvent() throws Exception {
        ChangeListener listener = new ChangeListener();
        this.observable.addChangeListener((IChangeListener)listener);
        this.delegate.change(this.observable);
        ObservableContractTest.assertEquals((String)this.formatFail("A change in the observable should notify change listeners."), (int)1, (int)listener.count);
    }

    public void testChange_EventObservable() throws Exception {
        ChangeListener listener = new ChangeListener();
        this.observable.addChangeListener((IChangeListener)listener);
        this.delegate.change(this.observable);
        ChangeEvent event = listener.event;
        ObservableContractTest.assertNotNull((String)this.formatFail("change event was null"), (Object)event);
        ObservableContractTest.assertSame((String)this.formatFail("In the change event the source of the change should be the observable."), (Object)this.observable, (Object)event.getObservable());
    }

    public void testChange_RealmCheck() throws Exception {
        RealmTester.exerciseCurrent(() -> this.delegate.change(this.observable), (CurrentRealm)this.observable.getRealm());
    }

    public void testChange_ObservableRealmIsTheCurrentRealm() throws Exception {
        ChangeListener listener = new ChangeListener();
        this.observable.addChangeListener((IChangeListener)listener);
        this.delegate.change(this.observable);
        ObservableContractTest.assertTrue((String)this.formatFail("On change the current realm should be the realm of the observable."), (boolean)listener.isCurrentRealm);
    }

    public void testRemoveChangeListener_RemovesListener() throws Exception {
        ChangeListener listener = new ChangeListener();
        this.observable.addChangeListener((IChangeListener)listener);
        this.delegate.change(this.observable);
        ObservableContractTest.assertEquals((String)this.formatFail("change did not notify listeners"), (int)1, (int)listener.count);
        this.observable.removeChangeListener((IChangeListener)listener);
        this.delegate.change(this.observable);
        ObservableContractTest.assertEquals((String)this.formatFail("When a change listener is removed it should not still receive change events."), (int)1, (int)listener.count);
    }

    public void testIsStale_NotStale() throws Exception {
        this.delegate.setStale(this.observable, false);
        ObservableContractTest.assertFalse((String)this.formatFail("When an observable is not stale isStale() should return false."), (boolean)this.observable.isStale());
    }

    public void testIsStale_RealmChecks() throws Exception {
        RealmTester.exerciseCurrent(() -> {
            boolean bl = this.observable.isStale();
        }, (CurrentRealm)this.observable.getRealm());
    }

    public void testIsStale_GetterCalled() throws Exception {
        this.assertGetterCalled(() -> {
            boolean bl = this.observable.isStale();
        }, "isStale", this.observable);
    }

    public void testIsDisposed() throws Exception {
        ObservableContractTest.assertFalse((boolean)this.observable.isDisposed());
        this.observable.dispose();
        ObservableContractTest.assertTrue((boolean)this.observable.isDisposed());
    }

    public void testAddDisposeListener_HandleDisposeInvoked() {
        DisposeEventTracker tracker = DisposeEventTracker.observe(this.observable);
        ObservableContractTest.assertEquals((int)0, (int)tracker.count);
        this.observable.dispose();
        ObservableContractTest.assertEquals((int)1, (int)tracker.count);
        ObservableContractTest.assertSame((Object)this.observable, (Object)tracker.event.getSource());
    }

    public void testHandleDispose_IsDisposedTrue() {
        this.observable.addDisposeListener(staleEvent -> ObservableContractTest.assertTrue((boolean)this.observable.isDisposed()));
        this.observable.dispose();
    }

    public void testDispose_RemovesListeners() throws Exception {
        ChangeListener disposedObservableListener = new ChangeListener();
        Realm realm = this.observable.getRealm();
        this.observable.addChangeListener((IChangeListener)disposedObservableListener);
        this.observable.dispose();
        this.observable = this.delegate.createObservable(realm);
        this.delegate.change(this.observable);
        ObservableContractTest.assertEquals((String)this.formatFail("After being disposed listeners should not receive change events."), (int)0, (int)disposedObservableListener.count);
    }

    public void testDispose_PreservesRealm() throws Exception {
        Realm realm = this.observable.getRealm();
        this.observable.dispose();
        ObservableContractTest.assertSame((Object)realm, (Object)this.observable.getRealm());
    }

    public static Test suite(IObservableContractDelegate delegate) {
        return new SuiteBuilder().addObservableContractTest(ObservableContractTest.class, delegate).build();
    }

    static class ChangeListener
    implements IChangeListener {
        int count;
        ChangeEvent event;
        boolean isCurrentRealm;

        ChangeListener() {
        }

        public void handleChange(ChangeEvent event) {
            ++this.count;
            this.event = event;
            this.isCurrentRealm = event.getObservable().getRealm().isCurrent();
        }
    }
}

