/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding;

import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BindingTest
extends AbstractDefaultRealmTestCase {
    private IObservableValue<String> target;
    private IObservableValue<String> model;
    private DataBindingContext dbc;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.target = WritableValue.withValueType(String.class);
        this.model = WritableValue.withValueType(String.class);
        this.dbc = new DataBindingContext();
    }

    @Test
    public void testDisposeTargetDisposesBinding() {
        Binding binding = this.createBinding();
        Assert.assertFalse((boolean)binding.isDisposed());
        this.target.dispose();
        Assert.assertTrue((boolean)binding.isDisposed());
    }

    @Test
    public void testDisposeModelDisposesBinding() {
        Binding binding = this.createBinding();
        Assert.assertFalse((boolean)binding.isDisposed());
        this.model.dispose();
        Assert.assertTrue((boolean)binding.isDisposed());
    }

    @Test
    public void testPreDisposedTarget_FiresIllegalArgumentException() {
        try {
            this.target.dispose();
            this.createBinding();
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void testPreDisposedModel_FiresIllegalArgumentException() {
        try {
            this.model.dispose();
            this.createBinding();
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void testDisposeModelThenBinding() {
        Binding binding = this.createBinding();
        this.model.dispose();
        binding.dispose();
    }

    @Test
    public void testDisposeTargetThenBinding() {
        Binding binding = this.createBinding();
        this.target.dispose();
        binding.dispose();
    }

    @Test
    public void testDisposeObservablesThenBinding() {
        Binding binding = this.createBinding();
        this.model.dispose();
        this.target.dispose();
        binding.dispose();
    }

    @Test
    public void testDisposeBindingThenModel() {
        Binding binding = this.createBinding();
        binding.dispose();
        this.model.dispose();
    }

    @Test
    public void testDisposeBindingThenTarget() {
        Binding binding = this.createBinding();
        binding.dispose();
        this.target.dispose();
    }

    @Test
    public void testDisposeBindingThenObservables() {
        Binding binding = this.createBinding();
        binding.dispose();
        this.model.dispose();
        this.target.dispose();
    }

    private Binding createBinding() {
        BindingStub binding = new BindingStub(this.target, this.model);
        binding.init(this.dbc);
        return binding;
    }

    private static class BindingStub
    extends Binding {
        BindingStub(IObservableValue<String> target, IObservableValue<String> model) {
            super(target, model);
        }

        public IObservableValue<IStatus> getValidationStatus() {
            return null;
        }

        protected void postInit() {
        }

        protected void preInit() {
        }

        public void updateModelToTarget() {
        }

        public void updateTargetToModel() {
        }

        public void validateModelToTarget() {
        }

        public void validateTargetToModel() {
        }
    }
}

