/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ListBinding;
import org.eclipse.core.databinding.UpdateListStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.util.Policy;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.internal.databinding.BindingStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ListBindingTest
extends AbstractDefaultRealmTestCase {
    private IObservableList<String> target;
    private IObservableList<String> model;
    private DataBindingContext dbc;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.target = new WritableList(new ArrayList(), String.class);
        this.model = new WritableList(new ArrayList(), String.class);
        this.dbc = new DataBindingContext();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.dbc.dispose();
        this.model.dispose();
        this.target.dispose();
    }

    @Test
    public void testUpdateModelFromTarget() throws Exception {
        Binding binding = this.dbc.bindList(this.target, this.model, new UpdateListStrategy(UpdateListStrategy.POLICY_ON_REQUEST), new UpdateListStrategy(UpdateListStrategy.POLICY_ON_REQUEST));
        this.target.add((Object)"1");
        ArrayList<String> targetCopy = new ArrayList<String>(this.target.size());
        targetCopy.addAll((Collection<String>)this.target);
        this.model.add((Object)"2");
        Assert.assertFalse((String)"target should not equal model", (boolean)this.target.equals(this.model));
        binding.updateTargetToModel();
        Assert.assertEquals((String)"target should not have changed", targetCopy, this.target);
        Assert.assertEquals((String)"target != model", this.target, this.model);
    }

    @Test
    public void testUpdateTargetFromModel() throws Exception {
        Binding binding = this.dbc.bindList(this.target, this.model, new UpdateListStrategy(UpdateListStrategy.POLICY_ON_REQUEST), new UpdateListStrategy(UpdateListStrategy.POLICY_ON_REQUEST));
        this.target.add((Object)"1");
        this.model.add((Object)"2");
        ArrayList<String> modelCopy = new ArrayList<String>(this.model.size());
        modelCopy.addAll((Collection<String>)this.model);
        Assert.assertFalse((String)"model should not equal target", (boolean)this.model.equals(this.target));
        binding.updateModelToTarget();
        Assert.assertEquals((String)"model should not have changed", modelCopy, this.model);
        Assert.assertEquals((String)"model != target", this.model, this.target);
    }

    @Test
    public void testGetTarget() throws Exception {
        Binding binding = this.dbc.bindList(this.target, this.model);
        IObservable targetList = binding.getTarget();
        Assert.assertEquals(this.target, (Object)targetList);
    }

    @Test
    public void testGetModel() throws Exception {
        Binding binding = this.dbc.bindList(this.target, this.model);
        IObservable modelList = binding.getModel();
        Assert.assertEquals(this.model, (Object)modelList);
    }

    @Test
    public void testStatusIsInstanceOfBindingStatus() throws Exception {
        Binding binding = this.dbc.bindList(this.target, this.model);
        Assert.assertTrue((boolean)(binding.getValidationStatus().getValue() instanceof BindingStatus));
    }

    @Test
    public void testAddValidationStatusContainsMultipleStatuses() throws Exception {
        UpdateListStrategy<String, String> strategy = new UpdateListStrategy<String, String>(){

            protected IStatus doAdd(IObservableList<? super String> observableList, String element, int index) {
                super.doAdd(observableList, (Object)element, index);
                switch (index) {
                    case 0: {
                        return ValidationStatus.error((String)"");
                    }
                    case 1: {
                        return ValidationStatus.info((String)"");
                    }
                }
                return null;
            }
        };
        Binding binding = this.dbc.bindList(this.target, this.model, (UpdateListStrategy)strategy, null);
        this.target.addAll(Arrays.asList("1", "2"));
        IStatus status = (IStatus)binding.getValidationStatus().getValue();
        Assert.assertEquals((String)"maximum status", (long)4L, (long)status.getSeverity());
        Assert.assertTrue((String)"multi status", (boolean)status.isMultiStatus());
        IStatus[] children = status.getChildren();
        Assert.assertEquals((String)"multi status children", (long)2L, (long)children.length);
        Assert.assertEquals((String)"first status severity", (long)4L, (long)children[0].getSeverity());
        Assert.assertEquals((String)"second status severity", (long)1L, (long)children[1].getSeverity());
    }

    @Test
    public void testRemoveValidationStatusContainsMultipleStatuses() throws Exception {
        List<String> items = Arrays.asList("1", "2");
        this.model.addAll(items);
        UpdateListStrategy<String, String> strategy = new UpdateListStrategy<String, String>(){
            int count;

            protected IStatus doRemove(IObservableList<? super String> observableList, int index) {
                super.doRemove(observableList, index);
                switch (this.count++) {
                    case 0: {
                        return ValidationStatus.error((String)"");
                    }
                    case 1: {
                        return ValidationStatus.info((String)"");
                    }
                }
                return null;
            }
        };
        Binding binding = this.dbc.bindList(this.target, this.model, (UpdateListStrategy)strategy, null);
        this.target.removeAll(items);
        IStatus status = (IStatus)binding.getValidationStatus().getValue();
        Assert.assertEquals((String)"maximum status", (long)4L, (long)status.getSeverity());
        Assert.assertTrue((String)"multi status", (boolean)status.isMultiStatus());
        IStatus[] children = status.getChildren();
        Assert.assertEquals((String)"multi status children", (long)2L, (long)children.length);
        Assert.assertEquals((String)"first status severity", (long)4L, (long)children[0].getSeverity());
        Assert.assertEquals((String)"second status severity", (long)1L, (long)children[1].getSeverity());
    }

    @Test
    public void testAddOKValidationStatus() throws Exception {
        Binding binding = this.dbc.bindList(this.target, this.model);
        this.target.add((Object)"1");
        IStatus status = (IStatus)binding.getValidationStatus().getValue();
        Assert.assertTrue((boolean)status.isOK());
        Assert.assertEquals((long)0L, (long)status.getChildren().length);
    }

    @Test
    public void testRemoveOKValidationStatus() throws Exception {
        this.model.add((Object)"1");
        Binding binding = this.dbc.bindList(this.target, this.model);
        this.target.remove((Object)"1");
        IStatus status = (IStatus)binding.getValidationStatus().getValue();
        Assert.assertTrue((boolean)status.isOK());
        Assert.assertEquals((long)0L, (long)status.getChildren().length);
    }

    @Test
    public void testErrorDuringConversionIsLogged() {
        UpdateListStrategy modelToTarget = new UpdateListStrategy();
        modelToTarget.setConverter((IConverter)new IConverter<String, String>(){

            public Object getFromType() {
                return String.class;
            }

            public Object getToType() {
                return String.class;
            }

            public String convert(String fromObject) {
                throw new IllegalArgumentException();
            }
        });
        this.dbc.bindList(this.target, this.model, new UpdateListStrategy(), modelToTarget);
        CountDownLatch latch = new CountDownLatch(1);
        Policy.setLog(status -> {
            latch.countDown();
            Assert.assertEquals((long)4L, (long)status.getSeverity());
            Assert.assertTrue((boolean)(status.getException() instanceof IllegalArgumentException));
        });
        this.model.add((Object)"first");
        Assert.assertEquals((long)0L, (long)latch.getCount());
        Policy.setLog(null);
    }

    @Test
    public void testErrorDuringRemoveIsLogged() {
        WritableList<String> target = new WritableList<String>(){

            public String remove(int index) {
                throw new IllegalArgumentException();
            }
        };
        this.dbc.bindList((IObservableList)target, this.model, new UpdateListStrategy(), new UpdateListStrategy());
        CountDownLatch latch = new CountDownLatch(1);
        Policy.setLog(status -> {
            latch.countDown();
            Assert.assertEquals((long)4L, (long)status.getSeverity());
            Assert.assertTrue((boolean)(status.getException() instanceof IllegalArgumentException));
        });
        this.model.add((Object)"first");
        this.model.remove((Object)"first");
        Assert.assertEquals((long)0L, (long)latch.getCount());
    }

    @Test
    public void testErrorDuringMoveIsLogged() {
        WritableList<String> target = new WritableList<String>(){

            public String move(int index, int index2) {
                throw new IllegalArgumentException();
            }
        };
        this.dbc.bindList((IObservableList)target, this.model, new UpdateListStrategy(), new UpdateListStrategy());
        CountDownLatch latch = new CountDownLatch(1);
        Policy.setLog(status -> {
            latch.countDown();
            Assert.assertEquals((long)4L, (long)status.getSeverity());
            Assert.assertTrue((boolean)(status.getException() instanceof IllegalArgumentException));
        });
        this.model.add((Object)"first");
        this.model.add((Object)"second");
        this.model.move(0, 1);
        Assert.assertEquals((long)0L, (long)latch.getCount());
    }

    @Test
    public void testErrorDuringReplaceIsLogged() {
        WritableList<String> target = new WritableList<String>(){

            public String set(int index, String element) {
                throw new IllegalArgumentException();
            }
        };
        this.dbc.bindList((IObservableList)target, this.model, new UpdateListStrategy(), new UpdateListStrategy());
        CountDownLatch latch = new CountDownLatch(1);
        Policy.setLog(status -> {
            latch.countDown();
            Assert.assertEquals((long)4L, (long)status.getSeverity());
            Assert.assertTrue((boolean)(status.getException() instanceof IllegalArgumentException));
        });
        this.model.add((Object)"first");
        this.model.set(0, (Object)"second");
        Assert.assertEquals((long)0L, (long)latch.getCount());
    }

    @Test
    public void testAddListenerAndInitialSyncAreUninterruptable() {
        Policy.setLog(status -> {
            if (!status.isOK()) {
                Assert.fail((String)("The databinding logger has the not-ok status " + status));
            }
        });
        this.model.add((Object)"first");
        new ListBinding(this.target, this.model, new UpdateListStrategy(), new UpdateListStrategy());
        this.model.remove(0);
    }

    @Test
    public void testTargetValueIsSyncedToModelIfModelWasNotSyncedToTarget() {
        this.target.add((Object)"first");
        this.dbc.bindList(this.target, this.model, new UpdateListStrategy(UpdateListStrategy.POLICY_UPDATE), new UpdateListStrategy(UpdateListStrategy.POLICY_NEVER));
        Assert.assertEquals((long)this.model.size(), (long)this.target.size());
    }

    @Test
    public void testConversion() {
        UpdateListStrategy modelToTarget = new UpdateListStrategy();
        modelToTarget.setConverter((IConverter)new IConverter<String, String>(){

            public Object getFromType() {
                return String.class;
            }

            public Object getToType() {
                return String.class;
            }

            public String convert(String fromObject) {
                return String.valueOf(fromObject) + "converted";
            }
        });
        this.dbc.bindList(this.target, this.model, new UpdateListStrategy(), modelToTarget);
        this.model.add((Object)"1");
        Assert.assertEquals((Object)"1converted", (Object)this.target.get(0));
        this.model.set(0, (Object)"2");
        Assert.assertEquals((Object)"2converted", (Object)this.target.get(0));
    }
}

