/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ObservablesManager;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ObservablesManagerTest
extends AbstractDefaultRealmTestCase {
    private DataBindingContext dbc;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.dbc = new DataBindingContext();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        if (this.dbc != null) {
            this.dbc.dispose();
        }
        super.tearDown();
    }

    @Test
    public void testOnlyModelIsDisposed() throws Exception {
        WritableValue targetOv = new WritableValue();
        WritableValue modelOv = new WritableValue();
        this.dbc.bindValue((IObservableValue)targetOv, (IObservableValue)modelOv);
        ObservablesManager observablesManager = new ObservablesManager();
        observablesManager.addObservablesFromContext(this.dbc, false, true);
        observablesManager.dispose();
        Assert.assertFalse((boolean)targetOv.isDisposed());
        Assert.assertTrue((boolean)modelOv.isDisposed());
    }

    @Test
    public void testOnlyTargetIsDisposed() throws Exception {
        WritableValue targetOv = new WritableValue();
        WritableValue modelOv = new WritableValue();
        this.dbc.bindValue((IObservableValue)targetOv, (IObservableValue)modelOv);
        ObservablesManager observablesManager = new ObservablesManager();
        observablesManager.addObservablesFromContext(this.dbc, true, false);
        observablesManager.dispose();
        Assert.assertTrue((boolean)targetOv.isDisposed());
        Assert.assertFalse((boolean)modelOv.isDisposed());
    }

    @Test
    public void testTargetAndModelIsDisposed() throws Exception {
        WritableValue targetOv = new WritableValue();
        WritableValue modelOv = new WritableValue();
        this.dbc.bindValue((IObservableValue)targetOv, (IObservableValue)modelOv);
        ObservablesManager observablesManager = new ObservablesManager();
        observablesManager.addObservablesFromContext(this.dbc, true, true);
        observablesManager.dispose();
        Assert.assertTrue((boolean)targetOv.isDisposed());
        Assert.assertTrue((boolean)modelOv.isDisposed());
    }

    @Test
    public void testDispose_Bug277966_NPEWhenManagedObservableAlreadyDisposed() {
        ObservablesManager manager = new ObservablesManager();
        WritableList observable = new WritableList();
        manager.addObservable((IObservable)observable);
        observable.dispose();
        manager.dispose();
    }
}

