/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.SetBinding;
import org.eclipse.core.databinding.UpdateSetStrategy;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.core.databinding.util.Policy;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SetBindingTest
extends AbstractDefaultRealmTestCase {
    private IObservableSet<String> target;
    private IObservableSet<String> model;
    private DataBindingContext dbc;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.target = new WritableSet();
        this.model = new WritableSet();
        this.dbc = new DataBindingContext();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.dbc.dispose();
        this.model.dispose();
        this.target.dispose();
    }

    @Test
    public void testUpdateModelFromTarget() throws Exception {
        this.target.add((Object)"1");
        this.dbc.bindSet(this.target, this.model, new UpdateSetStrategy(UpdateSetStrategy.POLICY_NEVER), new UpdateSetStrategy());
        Assert.assertEquals((String)"target != model", this.target, this.model);
    }

    @Test
    public void testUpdateTargetFromModel() throws Exception {
        this.model.add((Object)"1");
        this.dbc.bindSet(this.target, this.model, new UpdateSetStrategy(), new UpdateSetStrategy(UpdateSetStrategy.POLICY_NEVER));
        Assert.assertEquals((String)("model != target" + this.model + this.target), this.model, this.target);
    }

    @Test
    public void testAddListenerAndInitialSyncAreUninterruptable() {
        Policy.setLog(status -> {
            if (!status.isOK()) {
                Assert.fail((String)("The databinding logger has the not-ok status " + status));
            }
        });
        this.model.add((Object)"first");
        new SetBinding(this.target, this.model, new UpdateSetStrategy(), new UpdateSetStrategy());
        this.model.remove((Object)"first");
    }

    @Test
    public void testTargetValueIsSyncedToModelIfModelWasNotSyncedToTarget() {
        this.target.add((Object)"first");
        this.dbc.bindSet(this.target, this.model, new UpdateSetStrategy(UpdateSetStrategy.POLICY_UPDATE), new UpdateSetStrategy(UpdateSetStrategy.POLICY_NEVER));
        Assert.assertEquals((long)this.model.size(), (long)this.target.size());
    }
}

