/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding;

import org.eclipse.core.databinding.BindingException;
import org.eclipse.core.databinding.UpdateSetStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.core.internal.databinding.conversion.IdentityConverter;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.junit.Assert;
import org.junit.Test;

public class UpdateSetStrategyTest
extends AbstractDefaultRealmTestCase {
    @Test
    public void testFillDefaults_AssertSourceTypeExtendsConverterFromType() {
        UpdateSetStrategyStub strategy = new UpdateSetStrategyStub();
        strategy.setConverter((IConverter)new IdentityConverter(Object.class, Object.class));
        strategy.fillDefaults(WritableSet.withElementType(String.class), WritableSet.withElementType(Object.class));
        strategy = new UpdateSetStrategyStub();
        strategy.setConverter((IConverter)new IdentityConverter(String.class, Object.class));
        try {
            strategy.fillDefaults(WritableSet.withElementType(Object.class), WritableSet.withElementType(Object.class));
            Assert.fail((String)"Expected BindingException since Object does not extend String");
        }
        catch (BindingException bindingException) {}
    }

    @Test
    public void testFillDefaults_AssertConverterToTypeExtendsDestinationType() {
        UpdateSetStrategyStub strategy = new UpdateSetStrategyStub();
        strategy.setConverter((IConverter)new IdentityConverter(Object.class, String.class));
        strategy.fillDefaults(WritableSet.withElementType(Object.class), WritableSet.withElementType(Object.class));
        strategy = new UpdateSetStrategyStub();
        strategy.setConverter((IConverter)new IdentityConverter(Object.class, Object.class));
        try {
            strategy.fillDefaults(WritableSet.withElementType(Object.class), WritableSet.withElementType(String.class));
            Assert.fail((String)"Expected BindingException since Object does not extend String");
        }
        catch (BindingException bindingException) {}
    }

    class UpdateSetStrategyStub<S, D>
    extends UpdateSetStrategy<S, D> {
        UpdateSetStrategyStub() {
        }

        protected void fillDefaults(IObservableSet<? extends S> source, IObservableSet<? super D> destination) {
            super.fillDefaults(source, destination);
        }
    }
}

