/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.beans;

import org.eclipse.core.databinding.beans.IBeanObservable;
import org.eclipse.core.databinding.beans.IBeanValueProperty;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.tests.internal.databinding.beans.Bean;
import org.eclipse.jface.databinding.conformance.util.ChangeEventTracker;
import org.eclipse.jface.databinding.conformance.util.CurrentRealm;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PojoObservablesTest
extends AbstractDefaultRealmTestCase {
    private Bean pojo;
    private String propertyName;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.pojo = new Bean();
        this.propertyName = "value";
    }

    @Test
    public void testObserveValue_ReturnsIBeanObservable() throws Exception {
        IObservableValue value = PojoObservables.observeValue((Object)this.pojo, (String)this.propertyName);
        Assert.assertNotNull((Object)value);
        Assert.assertTrue((boolean)(value instanceof IBeanObservable));
    }

    @Test
    public void testObserveValue_DoesNotAttachListeners() throws Exception {
        IObservableValue value = PojoObservables.observeValue((Object)this.pojo, (String)this.propertyName);
        ChangeEventTracker.observe((IObservable)value);
        Assert.assertFalse((boolean)this.pojo.hasListeners(this.propertyName));
    }

    @Test
    public void testObservableValueWithRealm_ReturnsIBeanObservable() throws Exception {
        CurrentRealm realm = new CurrentRealm(true);
        IObservableValue value = PojoObservables.observeValue((Realm)realm, (Object)this.pojo, (String)this.propertyName);
        Assert.assertNotNull((Object)value);
        Assert.assertTrue((boolean)(value instanceof IBeanObservable));
    }

    @Test
    public void testObservableMap_ReturnsIBeanObservable() throws Exception {
        WritableSet set = new WritableSet();
        set.add((Object)new Bean());
        IObservableMap map = PojoObservables.observeMap((IObservableSet)set, Bean.class, (String)this.propertyName);
        Assert.assertNotNull((Object)map);
        Assert.assertTrue((boolean)(map instanceof IBeanObservable));
    }

    @Test
    public void testObservableMap_DoesNotAttachListeners() throws Exception {
        WritableSet set = new WritableSet();
        set.add((Object)this.pojo);
        IObservableMap map = PojoObservables.observeMap((IObservableSet)set, Bean.class, (String)this.propertyName);
        Assert.assertFalse((boolean)this.pojo.hasListeners(this.propertyName));
        ChangeEventTracker.observe((IObservable)map);
        Assert.assertFalse((boolean)this.pojo.hasListeners(this.propertyName));
    }

    @Test
    public void testObserveMaps_ReturnsMaps() throws Exception {
        WritableSet set = new WritableSet();
        set.add((Object)this.pojo);
        IObservableMap[] maps = PojoObservables.observeMaps((IObservableSet)set, Bean.class, (String[])new String[]{"value", "class"});
        Assert.assertEquals((long)2L, (long)maps.length);
    }

    @Test
    public void testObserveListWithElementType_ReturnsIBeanObservable() throws Exception {
        IObservableList list = PojoObservables.observeList((Realm)Realm.getDefault(), (Object)this.pojo, (String)"list", String.class);
        Assert.assertTrue((boolean)(list instanceof IBeanObservable));
    }

    @Test
    public void testObserveListWithElementType_DoesNotAttachListeners() throws Exception {
        IObservableList observable = PojoObservables.observeList((Realm)Realm.getDefault(), (Object)this.pojo, (String)"list", String.class);
        Assert.assertFalse((boolean)this.pojo.hasListeners("list"));
        ChangeEventTracker.observe((IObservable)observable);
        Assert.assertFalse((boolean)this.pojo.hasListeners("list"));
    }

    @Test
    public void testObserveList_ReturnsIBeanObservable() throws Exception {
        IObservableList observable = PojoObservables.observeList((Realm)Realm.getDefault(), (Object)this.pojo, (String)"list");
        Assert.assertTrue((boolean)(observable instanceof IBeanObservable));
    }

    @Test
    public void testObserveList_DoesNotAttachListeners() throws Exception {
        IObservableList observable = PojoObservables.observeList((Realm)Realm.getDefault(), (Object)this.pojo, (String)"list");
        Assert.assertFalse((boolean)this.pojo.hasListeners("list"));
        ChangeEventTracker.observe((IObservable)observable);
        Assert.assertFalse((boolean)this.pojo.hasListeners("list"));
    }

    @Test
    public void testObserveSetWithElementType_ReturnsIBeanObservable() throws Exception {
        IObservableSet list = PojoObservables.observeSet((Realm)Realm.getDefault(), (Object)this.pojo, (String)"set", String.class);
        Assert.assertTrue((boolean)(list instanceof IBeanObservable));
    }

    @Test
    public void testObserveSetWithElementType_DoesNotAttachListeners() throws Exception {
        IObservableSet observable = PojoObservables.observeSet((Realm)Realm.getDefault(), (Object)this.pojo, (String)"set", String.class);
        Assert.assertFalse((boolean)this.pojo.hasListeners("set"));
        ChangeEventTracker.observe((IObservable)observable);
        Assert.assertFalse((boolean)this.pojo.hasListeners("set"));
    }

    @Test
    public void testObserveSet_ReturnsIBeanObservable() throws Exception {
        IObservableSet list = PojoObservables.observeSet((Realm)Realm.getDefault(), (Object)this.pojo, (String)"set");
        Assert.assertTrue((boolean)(list instanceof IBeanObservable));
    }

    @Test
    public void testObserveSet_DoesNotAttachListeners() throws Exception {
        IObservableSet observable = PojoObservables.observeSet((Realm)Realm.getDefault(), (Object)this.pojo, (String)"set");
        Assert.assertFalse((boolean)this.pojo.hasListeners("set"));
        ChangeEventTracker.observe((IObservable)observable);
        Assert.assertFalse((boolean)this.pojo.hasListeners("set"));
    }

    @Test
    public void testValueFactory_DoesNotAttachListeners() throws Exception {
        IObservableFactory factory = PojoObservables.valueFactory((Realm)Realm.getDefault(), (String)"value");
        IObservableValue observable = (IObservableValue)factory.createObservable((Object)this.pojo);
        Assert.assertFalse((boolean)this.pojo.hasListeners("value"));
        ChangeEventTracker.observe((IObservable)observable);
        Assert.assertFalse((boolean)this.pojo.hasListeners("value"));
    }

    @Test
    public void testListFactory_DoesNotAttachListeners() throws Exception {
        IObservableFactory factory = PojoObservables.listFactory((Realm)Realm.getDefault(), (String)"list", String.class);
        IObservableList observable = (IObservableList)factory.createObservable((Object)this.pojo);
        Assert.assertFalse((boolean)this.pojo.hasListeners("value"));
        ChangeEventTracker.observe((IObservable)observable);
        Assert.assertFalse((boolean)this.pojo.hasListeners("value"));
    }

    @Test
    public void testSetFactory_DoesNotAttachListeners() throws Exception {
        IObservableFactory factory = PojoObservables.setFactory((Realm)Realm.getDefault(), (String)this.propertyName);
        IObservableSet observable = (IObservableSet)factory.createObservable((Object)this.pojo);
        Assert.assertFalse((boolean)this.pojo.hasListeners("set"));
        ChangeEventTracker.observe((IObservable)observable);
        Assert.assertFalse((boolean)this.pojo.hasListeners("set"));
    }

    @Test
    public void testSetFactoryWithElementType_DoesNotAttachListeners() throws Exception {
        IObservableFactory factory = PojoObservables.setFactory((Realm)Realm.getDefault(), (String)this.propertyName, String.class);
        IObservableSet observable = (IObservableSet)factory.createObservable((Object)this.pojo);
        Assert.assertFalse((boolean)this.pojo.hasListeners("set"));
        ChangeEventTracker.observe((IObservable)observable);
        Assert.assertFalse((boolean)this.pojo.hasListeners("set"));
    }

    @Test
    public void testObserveDetailValue_ValueType() {
        Bean inner = new Bean("string");
        Bean outer = new Bean(inner);
        IBeanValueProperty beanProperty = PojoProperties.value((String)"bean");
        IObservableValue beanObservable = beanProperty.observe((Object)outer);
        Assert.assertEquals(Bean.class, (Object)beanObservable.getValueType());
        IBeanValueProperty valueProperty = PojoProperties.value((String)"value");
        IObservableValue valueObservable = valueProperty.observeDetail(beanObservable);
        Assert.assertEquals(String.class, (Object)valueObservable.getValueType());
    }
}

