/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.conversion;

import com.ibm.icu.text.NumberFormat;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.core.databinding.conversion.StringToNumberConverter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StringToNumberConverterTest {
    private NumberFormat numberFormat;
    private NumberFormat numberIntegerFormat;
    Class<?> icuBigDecimal = null;
    Constructor<?> icuBigDecimalCtr = null;

    public StringToNumberConverterTest() {
        try {
            this.icuBigDecimal = Class.forName("com.ibm.icu.math.BigDecimal");
            this.icuBigDecimalCtr = this.icuBigDecimal.getConstructor(BigInteger.class, Integer.TYPE);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {}
    }

    @Before
    public void setUp() throws Exception {
        this.numberFormat = NumberFormat.getNumberInstance();
        this.numberFormat.setMaximumFractionDigits(305);
        this.numberFormat.setGroupingUsed(false);
        this.numberIntegerFormat = NumberFormat.getIntegerInstance();
    }

    @Test
    public void testToTypes() throws Exception {
        Assert.assertEquals((String)"Integer.class", Integer.class, (Object)StringToNumberConverter.toInteger((boolean)false).getToType());
        Assert.assertEquals((String)"Integer.TYPE", Integer.TYPE, (Object)StringToNumberConverter.toInteger((boolean)true).getToType());
        Assert.assertEquals((String)"Double.class", Double.class, (Object)StringToNumberConverter.toDouble((boolean)false).getToType());
        Assert.assertEquals((String)"Double.TYPE", Double.TYPE, (Object)StringToNumberConverter.toDouble((boolean)true).getToType());
        Assert.assertEquals((String)"Long.class", Long.class, (Object)StringToNumberConverter.toLong((boolean)false).getToType());
        Assert.assertEquals((String)"Long.TYPE", Long.TYPE, (Object)StringToNumberConverter.toLong((boolean)true).getToType());
        Assert.assertEquals((String)"Float.class", Float.class, (Object)StringToNumberConverter.toFloat((boolean)false).getToType());
        Assert.assertEquals((String)"Float.TYPE", Float.TYPE, (Object)StringToNumberConverter.toFloat((boolean)true).getToType());
        Assert.assertEquals((String)"BigInteger.TYPE", BigInteger.class, (Object)StringToNumberConverter.toBigInteger().getToType());
        Assert.assertEquals((String)"BigDecimal.TYPE", BigDecimal.class, (Object)StringToNumberConverter.toBigDecimal().getToType());
        Assert.assertEquals((String)"Short.class", Short.class, (Object)StringToNumberConverter.toShort((boolean)false).getToType());
        Assert.assertEquals((String)"Short.TYPE", Short.TYPE, (Object)StringToNumberConverter.toShort((boolean)true).getToType());
        Assert.assertEquals((String)"Byte.class", Byte.class, (Object)StringToNumberConverter.toByte((boolean)false).getToType());
        Assert.assertEquals((String)"Byte.TYPE", Byte.TYPE, (Object)StringToNumberConverter.toByte((boolean)true).getToType());
    }

    @Test
    public void testFromTypeIsString() throws Exception {
        Assert.assertEquals(String.class, (Object)StringToNumberConverter.toInteger((boolean)false).getFromType());
    }

    @Test
    public void testConvertsToBigInteger() throws Exception {
        BigInteger input = BigInteger.valueOf(1000L);
        StringToNumberConverter converter = StringToNumberConverter.toBigInteger();
        BigInteger result = (BigInteger)converter.convert((Object)this.numberFormat.format(input));
        Assert.assertEquals((Object)input, (Object)result);
    }

    private String formatBigDecimal(BigDecimal javabd) throws Exception {
        if (this.icuBigDecimal != null && this.icuBigDecimalCtr != null) {
            Number icubd = (Number)this.icuBigDecimalCtr.newInstance(javabd.unscaledValue(), javabd.scale());
            return this.numberFormat.format((Object)icubd);
        }
        throw new IllegalArgumentException("ICU not present. Cannot reliably format large BigDecimal values; needed for testing. Java platforms prior to 1.5 fail to format/parse these decimals correctly.");
    }

    @Test
    public void testConvertsToBigDecimal() throws Exception {
        StringToNumberConverter converter = StringToNumberConverter.toBigDecimal();
        BigDecimal input = new BigDecimal("100.23");
        BigDecimal result = (BigDecimal)converter.convert((Object)this.formatBigDecimal(input));
        Assert.assertEquals((String)"Non-integer BigDecimal", (Object)input, (Object)result);
        input = new BigDecimal(2147483747L);
        result = (BigDecimal)converter.convert((Object)this.formatBigDecimal(input));
        Assert.assertEquals((String)"Integral BigDecimal in long range", (Object)input, (Object)result);
        input = new BigDecimal("92233720368547990480");
        result = (BigDecimal)converter.convert((Object)this.formatBigDecimal(input));
        Assert.assertEquals((String)"Integral BigDecimal in long range", (Object)input, (Object)result);
        input = new BigDecimal("100404101.23345678345678893456789345678923198200134567823456789");
        result = (BigDecimal)converter.convert((Object)this.formatBigDecimal(input));
        Assert.assertEquals((String)"Non-integer BigDecimal", (Object)input, (Object)result);
    }

    @Test
    public void testConvertsToInteger() throws Exception {
        Integer input = 1000;
        StringToNumberConverter converter = StringToNumberConverter.toInteger((boolean)false);
        Integer result = (Integer)converter.convert((Object)this.numberIntegerFormat.format(input.longValue()));
        Assert.assertEquals((Object)input, (Object)result);
    }

    @Test
    public void testConvertsToDouble() throws Exception {
        Double input = new Double(1000.0);
        StringToNumberConverter converter = StringToNumberConverter.toDouble((boolean)false);
        Double result = (Double)converter.convert((Object)this.numberFormat.format(input.doubleValue()));
        Assert.assertEquals((Object)input, (Object)result);
    }

    @Test
    public void testConvertsToLong() throws Exception {
        Long input = new Long(1000L);
        StringToNumberConverter converter = StringToNumberConverter.toLong((boolean)false);
        Long result = (Long)converter.convert((Object)this.numberIntegerFormat.format(input.longValue()));
        Assert.assertEquals((Object)input, (Object)result);
    }

    @Test
    public void testConvertsToFloat() throws Exception {
        Float input = new Float(1000.0f);
        StringToNumberConverter converter = StringToNumberConverter.toFloat((boolean)false);
        Float result = (Float)converter.convert((Object)this.numberFormat.format((double)input.floatValue()));
        Assert.assertEquals((Object)input, (Object)result);
    }

    @Test
    public void testConvertedToIntegerPrimitive() throws Exception {
        Integer input = 1000;
        StringToNumberConverter converter = StringToNumberConverter.toInteger((boolean)true);
        Integer result = (Integer)converter.convert((Object)this.numberIntegerFormat.format(input.longValue()));
        Assert.assertEquals((Object)input, (Object)result);
    }

    @Test
    public void testConvertsToDoublePrimitive() throws Exception {
        Double input = new Double(1000.0);
        StringToNumberConverter converter = StringToNumberConverter.toDouble((boolean)true);
        Double result = (Double)converter.convert((Object)this.numberFormat.format(input.doubleValue()));
        Assert.assertEquals((Object)input, (Object)result);
    }

    @Test
    public void testConvertsToLongPrimitive() throws Exception {
        Long input = new Long(1000L);
        StringToNumberConverter converter = StringToNumberConverter.toLong((boolean)true);
        Long result = (Long)converter.convert((Object)this.numberIntegerFormat.format(input.longValue()));
        Assert.assertEquals((Object)input, (Object)result);
    }

    @Test
    public void testConvertsToFloatPrimitive() throws Exception {
        Float input = new Float(1000.0f);
        StringToNumberConverter converter = StringToNumberConverter.toFloat((boolean)true);
        Float result = (Float)converter.convert((Object)this.numberFormat.format((double)input.floatValue()));
        Assert.assertEquals((Object)input, (Object)result);
    }

    @Test
    public void testReturnsNullBoxedTypeForEmptyString() throws Exception {
        StringToNumberConverter converter = StringToNumberConverter.toInteger((boolean)false);
        try {
            Assert.assertNull((Object)converter.convert((Object)""));
        }
        catch (Exception exception) {
            Assert.fail((String)"exception should not have been thrown");
        }
    }

    @Test
    public void testThrowsIllegalArgumentExceptionIfAskedToConvertNonString() throws Exception {
        StringToNumberConverter converter = StringToNumberConverter.toInteger((boolean)false);
        try {
            converter.convert((Object)1);
            Assert.fail((String)"exception should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void testInvalidInteger() throws Exception {
        StringToNumberConverter converter = StringToNumberConverter.toInteger((boolean)false);
        try {
            Number result = converter.convert((Object)"1 1 -1");
            Assert.fail((String)("exception should have been thrown, but result was " + result));
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void testThrowsIllegalArgumentExceptionIfNumberIsOutOfRange() throws Exception {
        StringToNumberConverter converter = StringToNumberConverter.toInteger((boolean)false);
        try {
            converter.convert((Object)this.numberFormat.format(Long.MAX_VALUE));
            Assert.fail((String)"exception should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }
}

