/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.observable;

import junit.framework.TestSuite;
import org.eclipse.core.databinding.observable.AbstractObservable;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IDisposeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.jface.databinding.conformance.ObservableContractTest;
import org.eclipse.jface.databinding.conformance.ObservableStaleContractTest;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableContractDelegate;
import org.eclipse.jface.databinding.conformance.delegate.IObservableContractDelegate;
import org.eclipse.jface.databinding.conformance.util.ChangeEventTracker;
import org.eclipse.jface.databinding.conformance.util.CurrentRealm;
import org.eclipse.jface.databinding.conformance.util.RealmTester;
import org.eclipse.jface.databinding.conformance.util.StaleEventTracker;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AbstractObservableTest
extends AbstractDefaultRealmTestCase {
    private ObservableStub observable;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.observable = new ObservableStub(Realm.getDefault());
    }

    @Test
    public void testStaleListener() throws Exception {
        Assert.assertFalse((boolean)this.observable.hasListeners());
        StaleEventTracker listener1 = new StaleEventTracker();
        Assert.assertFalse((boolean)this.observable.firstListenerAdded);
        this.observable.addStaleListener((IStaleListener)listener1);
        Assert.assertTrue((boolean)this.observable.firstListenerAdded);
        this.observable.firstListenerAdded = false;
        Assert.assertTrue((boolean)this.observable.hasListeners());
        Assert.assertEquals((long)0L, (long)listener1.count);
        this.observable.fireStale();
        Assert.assertEquals((long)1L, (long)listener1.count);
        Assert.assertSame((Object)((Object)this.observable), (Object)listener1.event.getObservable());
        StaleEventTracker listener2 = new StaleEventTracker();
        Assert.assertEquals((long)0L, (long)listener2.count);
        this.observable.addStaleListener((IStaleListener)listener2);
        this.observable.fireStale();
        Assert.assertEquals((long)2L, (long)listener1.count);
        Assert.assertEquals((long)1L, (long)listener2.count);
        StaleEventTracker listener3 = new StaleEventTracker();
        this.observable.addStaleListener((IStaleListener)listener3);
        Assert.assertEquals((long)0L, (long)listener3.count);
        this.observable.fireStale();
        Assert.assertEquals((long)3L, (long)listener1.count);
        Assert.assertEquals((long)2L, (long)listener2.count);
        Assert.assertEquals((long)1L, (long)listener3.count);
        Assert.assertFalse((boolean)this.observable.lastListenerRemoved);
        this.observable.removeStaleListener((IStaleListener)listener1);
        this.observable.removeStaleListener((IStaleListener)listener2);
        this.observable.removeStaleListener((IStaleListener)listener3);
        Assert.assertTrue((boolean)this.observable.lastListenerRemoved);
        Assert.assertFalse((boolean)this.observable.hasListeners());
    }

    @Test
    public void testChangeListener() throws Exception {
        Assert.assertFalse((boolean)this.observable.hasListeners());
        ChangeEventTracker listener1 = new ChangeEventTracker();
        Assert.assertFalse((boolean)this.observable.firstListenerAdded);
        this.observable.addChangeListener((IChangeListener)listener1);
        Assert.assertTrue((boolean)this.observable.firstListenerAdded);
        this.observable.firstListenerAdded = false;
        Assert.assertTrue((boolean)this.observable.hasListeners());
        Assert.assertEquals((long)0L, (long)listener1.count);
        this.observable.fireChange();
        Assert.assertEquals((long)1L, (long)listener1.count);
        Assert.assertSame((Object)((Object)this.observable), (Object)listener1.event.getSource());
        ChangeEventTracker listener2 = new ChangeEventTracker();
        this.observable.addChangeListener((IChangeListener)listener2);
        Assert.assertEquals((long)0L, (long)listener2.count);
        this.observable.fireChange();
        Assert.assertEquals((long)2L, (long)listener1.count);
        Assert.assertEquals((long)1L, (long)listener2.count);
        ChangeEventTracker listener3 = new ChangeEventTracker();
        this.observable.addChangeListener((IChangeListener)listener3);
        Assert.assertEquals((long)0L, (long)listener3.count);
        this.observable.fireChange();
        Assert.assertEquals((long)3L, (long)listener1.count);
        Assert.assertEquals((long)2L, (long)listener2.count);
        Assert.assertEquals((long)1L, (long)listener3.count);
        Assert.assertFalse((boolean)this.observable.lastListenerRemoved);
        this.observable.removeChangeListener((IChangeListener)listener1);
        this.observable.removeChangeListener((IChangeListener)listener2);
        this.observable.removeChangeListener((IChangeListener)listener3);
        Assert.assertTrue((boolean)this.observable.lastListenerRemoved);
        Assert.assertFalse((boolean)this.observable.hasListeners());
    }

    @Test
    public void testHasListenersWithChangeAndStaleListeners() throws Exception {
        ChangeEventTracker changeListener = new ChangeEventTracker();
        StaleEventTracker staleListener = new StaleEventTracker();
        Assert.assertFalse((boolean)this.observable.hasListeners());
        Assert.assertFalse((boolean)this.observable.firstListenerAdded);
        Assert.assertFalse((boolean)this.observable.lastListenerRemoved);
        this.observable.addChangeListener((IChangeListener)changeListener);
        Assert.assertTrue((boolean)this.observable.hasListeners());
        Assert.assertTrue((boolean)this.observable.firstListenerAdded);
        Assert.assertFalse((boolean)this.observable.lastListenerRemoved);
        this.observable.firstListenerAdded = false;
        this.observable.lastListenerRemoved = false;
        this.observable.addStaleListener((IStaleListener)staleListener);
        Assert.assertTrue((boolean)this.observable.hasListeners());
        Assert.assertFalse((boolean)this.observable.firstListenerAdded);
        Assert.assertFalse((boolean)this.observable.lastListenerRemoved);
        this.observable.removeChangeListener((IChangeListener)changeListener);
        Assert.assertTrue((boolean)this.observable.hasListeners());
        Assert.assertFalse((boolean)this.observable.firstListenerAdded);
        Assert.assertFalse((boolean)this.observable.lastListenerRemoved);
        this.observable.removeStaleListener((IStaleListener)staleListener);
        Assert.assertFalse((boolean)this.observable.hasListeners());
        Assert.assertFalse((boolean)this.observable.firstListenerAdded);
        Assert.assertTrue((boolean)this.observable.lastListenerRemoved);
    }

    @Test
    public void testFireStaleRealmChecks() throws Exception {
        RealmTester.setDefault((Realm)new CurrentRealm(true));
        RealmTester.exerciseCurrent(() -> {
            this.observable = new ObservableStub();
            this.observable.fireStale();
        });
    }

    @Test
    public void testFireChangeRealmChecks() throws Exception {
        RealmTester.setDefault((Realm)new CurrentRealm(true));
        RealmTester.exerciseCurrent(() -> {
            this.observable = new ObservableStub();
            this.observable.fireChange();
        });
    }

    @Test
    public void testAddDisposeListener_HasListenersFalse() {
        IDisposeListener disposeListener = staleEvent -> {};
        IStaleListener staleListener = staleEvent -> {};
        Assert.assertFalse((boolean)this.observable.hasListeners());
        this.observable.addDisposeListener(disposeListener);
        Assert.assertFalse((boolean)this.observable.hasListeners());
        Assert.assertFalse((boolean)this.observable.firstListenerAdded);
        Assert.assertFalse((boolean)this.observable.lastListenerRemoved);
        this.observable.addStaleListener(staleListener);
        Assert.assertTrue((boolean)this.observable.hasListeners());
        Assert.assertTrue((boolean)this.observable.firstListenerAdded);
        Assert.assertFalse((boolean)this.observable.lastListenerRemoved);
        this.observable.removeDisposeListener(disposeListener);
        Assert.assertTrue((boolean)this.observable.hasListeners());
        Assert.assertTrue((boolean)this.observable.firstListenerAdded);
        Assert.assertFalse((boolean)this.observable.lastListenerRemoved);
        this.observable.removeStaleListener(staleListener);
        Assert.assertFalse((boolean)this.observable.hasListeners());
        Assert.assertTrue((boolean)this.observable.firstListenerAdded);
        Assert.assertTrue((boolean)this.observable.lastListenerRemoved);
    }

    public static void addConformanceTest(TestSuite suite) {
        Delegate delegate = new Delegate();
        suite.addTest(ObservableContractTest.suite((IObservableContractDelegate)delegate));
        suite.addTest(ObservableStaleContractTest.suite((IObservableContractDelegate)delegate));
    }

    static class Delegate
    extends AbstractObservableContractDelegate {
        Delegate() {
        }

        public void change(IObservable observable) {
            ((ObservableStub)observable).fireChange();
        }

        public void setStale(IObservable observable, boolean stale) {
            ((ObservableStub)observable).setStale(stale);
        }

        public IObservable createObservable(Realm realm) {
            return new ObservableStub(realm);
        }
    }

    private static class ObservableStub
    extends AbstractObservable {
        private boolean stale;
        private boolean firstListenerAdded;
        private boolean lastListenerRemoved;

        public ObservableStub() {
            this(Realm.getDefault());
        }

        public ObservableStub(Realm realm) {
            super(realm);
        }

        protected void fireStale() {
            super.fireStale();
        }

        protected void fireChange() {
            super.fireChange();
        }

        public boolean isStale() {
            this.getterCalled();
            return this.stale;
        }

        private void getterCalled() {
            ObservableTracker.getterCalled((IObservable)this);
        }

        public void setStale(boolean stale) {
            boolean old = this.stale;
            this.stale = stale;
            if (stale && !old) {
                this.fireStale();
            }
        }

        protected boolean hasListeners() {
            return super.hasListeners();
        }

        protected void firstListenerAdded() {
            this.firstListenerAdded = true;
        }

        protected void lastListenerRemoved() {
            this.lastListenerRemoved = true;
        }
    }
}

