/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.observable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;
import org.eclipse.core.databinding.observable.list.ListDiffVisitor;
import org.junit.Assert;
import org.junit.Test;

public class Diffs_ListDiffTests {
    @Test
    public void testListDiffEntryToStringDoesNotThrowNPEForNullListDiffEntry() {
        ListDiffEntry entry = new ListDiffEntry(){

            public Object getElement() {
                return null;
            }

            public int getPosition() {
                return 0;
            }

            public boolean isAddition() {
                return false;
            }
        };
        try {
            entry.toString();
            Assert.assertTrue((boolean)true);
        }
        catch (NullPointerException nullPointerException) {
            Assert.fail((String)"NPE was thrown.");
        }
    }

    @Test
    public void testListDiffToStringDoesNotThrowNPEForNullListDiff() {
        ListDiff diff = new ListDiff(){

            public ListDiffEntry[] getDifferences() {
                return null;
            }
        };
        try {
            diff.toString();
            Assert.assertTrue((boolean)true);
        }
        catch (NullPointerException nullPointerException) {
            Assert.fail((String)"NPE was thrown.");
        }
    }

    @Test
    public void testListDiffToStringDoesNotThrowNPEForNullListDiffEntry() {
        ListDiff diff = new ListDiff(){

            public ListDiffEntry[] getDifferences() {
                return new ListDiffEntry[1];
            }
        };
        try {
            diff.toString();
            Assert.assertTrue((boolean)true);
        }
        catch (NullPointerException nullPointerException) {
            Assert.fail((String)"NPE was thrown.");
        }
    }

    @Test
    public void testDiffScenario1() throws Exception {
        ListDiff diff = this.diff(null, null);
        Assert.assertEquals((long)0L, (long)diff.getDifferences().length);
    }

    private ListDiff diff(String[] oldArray, String[] newArray) {
        List<String> a = Arrays.asList(oldArray != null ? oldArray : new String[]{});
        List<String> b = Arrays.asList(newArray != null ? newArray : new String[]{});
        return Diffs.computeListDiff(a, b);
    }

    @Test
    public void testDiffScenario2() throws Exception {
        ListDiff diff = this.diff(new String[]{"a"}, null);
        Assert.assertEquals((long)1L, (long)diff.getDifferences().length);
        Diffs_ListDiffTests.assertEntry(diff.getDifferences()[0], false, 0, "a");
    }

    @Test
    public void testDiffScenario3() throws Exception {
        ListDiff diff = this.diff(null, new String[]{"a"});
        Assert.assertEquals((long)1L, (long)diff.getDifferences().length);
        Diffs_ListDiffTests.assertEntry(diff.getDifferences()[0], true, 0, "a");
    }

    @Test
    public void testDiffScenario4() throws Exception {
        ListDiff diff = this.diff(new String[]{"a"}, new String[]{"a"});
        Assert.assertEquals((long)0L, (long)diff.getDifferences().length);
    }

    @Test
    public void testDiffScenario5() throws Exception {
        ListDiff diff = this.diff(new String[]{"a"}, new String[]{"b"});
        Assert.assertEquals((long)2L, (long)diff.getDifferences().length);
        Diffs_ListDiffTests.assertEntry(diff.getDifferences()[0], true, 0, "b");
        Diffs_ListDiffTests.assertEntry(diff.getDifferences()[1], false, 1, "a");
    }

    @Test
    public void testDiffScenario6() throws Exception {
        ListDiff diff = this.diff(new String[]{"a"}, new String[]{"a", "b"});
        Assert.assertEquals((long)1L, (long)diff.getDifferences().length);
        Diffs_ListDiffTests.assertEntry(diff.getDifferences()[0], true, 1, "b");
    }

    @Test
    public void testDiffScenario7() throws Exception {
        ListDiff diff = this.diff(new String[]{"a"}, new String[]{"b", "a"});
        Assert.assertEquals((long)1L, (long)diff.getDifferences().length);
        Diffs_ListDiffTests.assertEntry(diff.getDifferences()[0], true, 0, "b");
    }

    @Test
    public void testDiffScenario8() throws Exception {
        ListDiff diff = this.diff(new String[]{"a"}, new String[]{"b", "b"});
        Assert.assertEquals((long)3L, (long)diff.getDifferences().length);
        Diffs_ListDiffTests.assertEntry(diff.getDifferences()[0], true, 0, "b");
        Diffs_ListDiffTests.assertEntry(diff.getDifferences()[1], true, 1, "b");
        Diffs_ListDiffTests.assertEntry(diff.getDifferences()[2], false, 2, "a");
    }

    @Test
    public void testDiffScenario9() throws Exception {
        ListDiff diff = this.diff(new String[]{"a"}, new String[]{"a", "b", "c"});
        Assert.assertEquals((long)2L, (long)diff.getDifferences().length);
        Diffs_ListDiffTests.assertEntry(diff.getDifferences()[0], true, 1, "b");
        Diffs_ListDiffTests.assertEntry(diff.getDifferences()[1], true, 2, "c");
    }

    @Test
    public void testDiffScenario10() throws Exception {
        ListDiff diff = this.diff(new String[]{"b"}, new String[]{"a", "b", "c"});
        Assert.assertEquals((long)2L, (long)diff.getDifferences().length);
        Diffs_ListDiffTests.assertEntry(diff.getDifferences()[0], true, 0, "a");
        Diffs_ListDiffTests.assertEntry(diff.getDifferences()[1], true, 2, "c");
    }

    @Test
    public void testDiffScenario11() throws Exception {
        ListDiff diff = this.diff(new String[]{"c"}, new String[]{"a", "b", "c"});
        Assert.assertEquals((long)2L, (long)diff.getDifferences().length);
        Diffs_ListDiffTests.assertEntry(diff.getDifferences()[0], true, 0, "a");
        Diffs_ListDiffTests.assertEntry(diff.getDifferences()[1], true, 1, "b");
    }

    @Test
    public void testDiffScenario12() throws Exception {
        ListDiff diff = this.diff(new String[]{"a", "b", "c"}, new String[]{"a", "b", "c"});
        Assert.assertEquals((long)0L, (long)diff.getDifferences().length);
    }

    @Test
    public void testDiffScenario13() throws Exception {
        ListDiff diff = this.diff(new String[]{"a", "b", "c"}, new String[]{"b", "c"});
        Assert.assertEquals((long)1L, (long)diff.getDifferences().length);
        Diffs_ListDiffTests.assertEntry(diff.getDifferences()[0], false, 0, "a");
    }

    @Test
    public void testDiffScenarios14() throws Exception {
        ListDiff diff = this.diff(new String[]{"a", "b", "c"}, new String[]{"a", "c"});
        Assert.assertEquals((long)1L, (long)diff.getDifferences().length);
        Diffs_ListDiffTests.assertEntry(diff.getDifferences()[0], false, 1, "b");
    }

    @Test
    public void testDiffScenarios15() throws Exception {
        ListDiff diff = this.diff(new String[]{"a", "b", "c"}, new String[]{"a", "b"});
        Assert.assertEquals((long)1L, (long)diff.getDifferences().length);
        Diffs_ListDiffTests.assertEntry(diff.getDifferences()[0], false, 2, "c");
    }

    @Test
    public void testDiffScenarios16() throws Exception {
        ListDiff diff = this.diff(new String[]{"a", "b", "c"}, new String[]{"c", "b", "a"});
        Assert.assertEquals((long)4L, (long)diff.getDifferences().length);
        Diffs_ListDiffTests.assertEntry(diff.getDifferences()[0], false, 2, "c");
        Diffs_ListDiffTests.assertEntry(diff.getDifferences()[1], true, 0, "c");
        Diffs_ListDiffTests.assertEntry(diff.getDifferences()[2], false, 2, "b");
        Diffs_ListDiffTests.assertEntry(diff.getDifferences()[3], true, 1, "b");
    }

    @Test
    public void testDiffScenarios17() throws Exception {
        ListDiff diff = this.diff(new String[]{"a", "b", "c"}, new String[]{"c", "b"});
        Assert.assertEquals((long)3L, (long)diff.getDifferences().length);
        Diffs_ListDiffTests.assertEntry(diff.getDifferences()[0], false, 0, "a");
        Diffs_ListDiffTests.assertEntry(diff.getDifferences()[1], false, 1, "c");
        Diffs_ListDiffTests.assertEntry(diff.getDifferences()[2], true, 0, "c");
    }

    private static void assertEntry(ListDiffEntry entry, boolean addition, int position, String element) {
        Assert.assertEquals((String)"addition", (Object)addition, (Object)entry.isAddition());
        Assert.assertEquals((String)"position", (long)position, (long)entry.getPosition());
        Assert.assertEquals((String)"element", (Object)element, (Object)entry.getElement());
    }

    @Test
    public void testComputeListDiff_SingleInsert() {
        Diffs_ListDiffTests.checkComputedListDiff(Arrays.asList("a", "c"), Arrays.asList("a", "b", "c"));
    }

    @Test
    public void testComputeListDiff_SingleAppend() {
        Diffs_ListDiffTests.checkComputedListDiff(Arrays.asList("a", "b"), Arrays.asList("a", "b", "c"));
    }

    @Test
    public void testComputeListDiff_SingleRemove() {
        Diffs_ListDiffTests.checkComputedListDiff(Arrays.asList("a", "b", "c"), Arrays.asList("a", "b"));
        Diffs_ListDiffTests.checkComputedListDiff(Arrays.asList("a", "b", "c"), Arrays.asList("a", "c"));
        Diffs_ListDiffTests.checkComputedListDiff(Arrays.asList("a", "b", "c"), Arrays.asList("b", "c"));
    }

    @Test
    public void testComputeListDiff_MoveDown1() {
        Diffs_ListDiffTests.checkComputedListDiff(Arrays.asList("a", "b"), Arrays.asList("b", "a"));
    }

    @Test
    public void testComputeListDiff_MoveDown2() {
        Diffs_ListDiffTests.checkComputedListDiff(Arrays.asList("a", "b", "c"), Arrays.asList("b", "c", "a"));
    }

    @Test
    public void testComputeListDiff_MoveUp1() {
        Diffs_ListDiffTests.checkComputedListDiff(Arrays.asList("a", "b"), Arrays.asList("b", "a"));
    }

    @Test
    public void testComputeListDiff_MoveUp2() {
        Diffs_ListDiffTests.checkComputedListDiff(Arrays.asList("a", "b", "c"), Arrays.asList("c", "a", "b"));
    }

    private static void checkComputedListDiff(List<Object> oldList, List<Object> newList) {
        ListDiff diff = Diffs.computeListDiff(oldList, newList);
        final ArrayList<Object> list = new ArrayList<Object>(oldList);
        diff.accept(new ListDiffVisitor(){

            public void handleAdd(int index, Object element) {
                list.add(index, element);
            }

            public void handleRemove(int index, Object element) {
                Assert.assertEquals((Object)element, list.remove(index));
            }

            public void handleReplace(int index, Object oldElement, Object newElement) {
                Assert.assertEquals((Object)oldElement, (Object)list.set(index, newElement));
            }
        });
        Assert.assertEquals((String)"Applying diff to old list should make it equal to new list", newList, list);
    }
}

