/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.observable.list;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestSuite;
import org.eclipse.core.databinding.observable.AbstractObservable;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.ComputedList;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.jface.databinding.conformance.ObservableListContractTest;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableCollectionContractDelegate;
import org.eclipse.jface.databinding.conformance.delegate.IObservableCollectionContractDelegate;
import org.eclipse.jface.databinding.conformance.util.ListChangeEventTracker;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ComputedListTest
extends AbstractDefaultRealmTestCase {
    ComputedListStub list;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.list = new ComputedListStub();
        this.list.size();
    }

    @Test
    public void testDependency_Staleness() {
        Assert.assertFalse((boolean)this.list.isStale());
        this.list.dependency.fireStale();
        Assert.assertTrue((boolean)this.list.isStale());
    }

    @Test
    public void testDependency_FiresListChange() {
        Assert.assertEquals((Object)this.list.nextComputation, (Object)((Object)this.list));
        Object element = new Object();
        this.list.nextComputation.add(element);
        this.list.dependency.fireChange();
        ArrayList<Object> expectedList = new ArrayList<Object>();
        expectedList.add(element);
        Assert.assertEquals(expectedList, (Object)((Object)this.list));
    }

    @Test
    public void testDependency_NoStaleEventIfAlreadyDirty() {
        this.list.dependency.fireChange();
        this.list.addStaleListener(staleEvent -> Assert.fail((String)"Should not fire stale when list is already dirty"));
        this.list.dependency.fireStale();
    }

    @Test
    public void testDependency_ListChangeEventFiresOnlyWhenNotDirty() {
        ListChangeEventTracker tracker = ListChangeEventTracker.observe((IObservableList)this.list);
        this.list.dependency.fireChange();
        Assert.assertEquals((String)"ComputedList should fire list change event when its dependency changes", (long)1L, (long)tracker.count);
        this.list.dependency.fireChange();
        Assert.assertEquals((String)"ComputedList should not fire list change events when dirty", (long)1L, (long)tracker.count);
        this.list.size();
        this.list.dependency.fireChange();
        Assert.assertEquals((String)"ComputedList should fire list change event when its dependency changes", (long)2L, (long)tracker.count);
    }

    public static void addConformanceTest(TestSuite suite) {
        suite.addTest(ObservableListContractTest.suite((IObservableCollectionContractDelegate)new Delegate()));
    }

    static class ComputedListStub
    extends ComputedList {
        List nextComputation = new ArrayList();
        ObservableStub dependency;

        ComputedListStub() {
            this(Realm.getDefault());
        }

        ComputedListStub(Realm realm) {
            super(realm);
            this.dependency = new ObservableStub(realm);
        }

        protected List calculate() {
            ObservableTracker.getterCalled((IObservable)this.dependency);
            return new ArrayList(this.nextComputation);
        }
    }

    static class Delegate
    extends AbstractObservableCollectionContractDelegate {
        Delegate() {
        }

        public IObservableCollection createObservableCollection(Realm realm, int elementCount) {
            ComputedListStub list = new ComputedListStub(realm);
            int i = 0;
            while (i < elementCount) {
                list.nextComputation.add(this.createElement((IObservableCollection)list));
                ++i;
            }
            list.size();
            return list;
        }

        public void change(IObservable observable) {
            ComputedListStub list = (ComputedListStub)observable;
            list.nextComputation.add(new Object());
            list.dependency.fireChange();
        }

        public void setStale(IObservable observable, boolean stale) {
            if (stale) {
                ((ComputedListStub)observable).dependency.fireStale();
            } else {
                ComputedListStub computedList = (ComputedListStub)observable;
                computedList.dependency.stale = false;
                computedList.dependency.fireChange();
            }
        }
    }

    static class ObservableStub
    extends AbstractObservable {
        boolean stale;

        public ObservableStub(Realm realm) {
            super(realm);
        }

        public boolean isStale() {
            return this.stale;
        }

        protected void fireStale() {
            this.stale = true;
            super.fireStale();
        }

        protected void fireChange() {
            super.fireChange();
        }
    }
}

