/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.observable.list;

import org.eclipse.core.databinding.observable.list.ListDiffVisitor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ListDiffVisitorTest {
    ListDiffVisitorStub visitor;

    @Before
    public void setUp() throws Exception {
        this.visitor = new ListDiffVisitorStub();
    }

    @Test
    public void testHandleMove_DelegatesByDefault() {
        this.visitor.handleMove(0, 1, "element");
        Assert.assertEquals((String)"Default ListDiffVisitor.handleMove must delegate to handleRemove and handleAdd", (Object)"remove(0,element), add(1,element)", (Object)this.visitor.log);
    }

    @Test
    public void testHandleReplace_DelegatesByDefault() {
        this.visitor.handleReplace(2, "oldElement", "newElement");
        Assert.assertEquals((String)"Default ListDiffVisitor.handleReplace must delegate to handleRemove and handleAdd", (Object)"remove(2,oldElement), add(2,newElement)", (Object)this.visitor.log);
    }

    static class ListDiffVisitorStub
    extends ListDiffVisitor {
        String log = "";

        ListDiffVisitorStub() {
        }

        private void log(String message) {
            if (this.log.length() > 0) {
                this.log = String.valueOf(this.log) + ", ";
            }
            this.log = String.valueOf(this.log) + message;
        }

        public void handleAdd(int index, Object element) {
            this.log("add(" + index + "," + element + ")");
        }

        public void handleRemove(int index, Object element) {
            this.log("remove(" + index + "," + element + ")");
        }
    }
}

