/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.observable.list;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import junit.framework.TestSuite;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.jface.databinding.conformance.MutableObservableListContractTest;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableCollectionContractDelegate;
import org.eclipse.jface.databinding.conformance.delegate.IObservableCollectionContractDelegate;
import org.eclipse.jface.databinding.conformance.util.CurrentRealm;
import org.eclipse.jface.databinding.conformance.util.RealmTester;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.swt.widgets.Display;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WritableListTest {
    @Before
    public void setUp() throws Exception {
        RealmTester.setDefault((Realm)new CurrentRealm(true));
    }

    @After
    public void tearDown() throws Exception {
        RealmTester.setDefault(null);
    }

    @Test
    public void testSetRealmChecks() throws Exception {
        RealmTester.exerciseCurrent(() -> {
            WritableList list = new WritableList();
            list.add((Object)"");
            list.set(0, (Object)"");
        });
    }

    @Test
    public void testAddRealmChecks() throws Exception {
        RealmTester.exerciseCurrent(() -> {
            WritableList list = new WritableList();
            list.add((Object)"");
        });
    }

    @Test
    public void testAddByIndexRealmChecks() throws Exception {
        RealmTester.exerciseCurrent(() -> {
            WritableList list = new WritableList();
            list.add(0, (Object)"");
        });
    }

    @Test
    public void testAddAllRealmChecks() throws Exception {
        RealmTester.exerciseCurrent(() -> {
            WritableList list = new WritableList();
            list.addAll((Collection)Collections.EMPTY_LIST);
        });
    }

    @Test
    public void testAddAllByIndexRealmChecks() throws Exception {
        RealmTester.exerciseCurrent(() -> {
            WritableList list = new WritableList();
            list.addAll(0, (Collection)Collections.EMPTY_LIST);
        });
    }

    @Test
    public void testRemoveRealmChecks() throws Exception {
        RealmTester.setDefault((Realm)new CurrentRealm(true));
        WritableList list = new WritableList();
        list.add((Object)"");
        list.add((Object)"");
        RealmTester.exerciseCurrent(() -> {
            boolean bl = list.remove((Object)"");
        });
        RealmTester.setDefault(null);
    }

    @Test
    public void testRemoveByIndexRealmChecks() throws Exception {
        RealmTester.setDefault((Realm)new CurrentRealm(true));
        WritableList list = new WritableList();
        list.add((Object)"");
        list.add((Object)"");
        RealmTester.exerciseCurrent(() -> {
            Object object = list.remove(list.size() - 1);
        });
        RealmTester.setDefault(null);
    }

    @Test
    public void testRemoveAllRealmChecks() throws Exception {
        RealmTester.exerciseCurrent(() -> {
            WritableList list = new WritableList();
            list.removeAll((Collection)Collections.EMPTY_LIST);
        });
    }

    @Test
    public void testRetainAllRealmChecks() throws Exception {
        RealmTester.exerciseCurrent(() -> {
            WritableList list = new WritableList();
            list.retainAll((Collection)Collections.EMPTY_LIST);
        });
    }

    @Test
    public void testClearRealmChecks() throws Exception {
        RealmTester.exerciseCurrent(() -> {
            WritableList list = new WritableList();
            list.clear();
        });
    }

    @Test
    public void testNullElementType() throws Exception {
        RealmTester.setDefault((Realm)DisplayRealm.getRealm((Display)Display.getDefault()));
        WritableList writableList = new WritableList();
        Assert.assertNull((Object)writableList.getElementType());
        writableList = new WritableList(Realm.getDefault());
        Assert.assertNull((Object)writableList.getElementType());
    }

    @Test
    public void testWithElementType() throws Exception {
        RealmTester.setDefault((Realm)DisplayRealm.getRealm((Display)Display.getDefault()));
        Class<String> elementType = String.class;
        WritableList list = WritableList.withElementType(elementType);
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((Object)Realm.getDefault(), (Object)list.getRealm());
        Assert.assertEquals(elementType, (Object)list.getElementType());
    }

    @Test
    public void testListConstructorsDoNotCopy_1() {
        RealmTester.setDefault((Realm)new CurrentRealm(true));
        ArrayList<Object> list = new ArrayList<Object>(Arrays.asList("a", "b", "c"));
        WritableList wlist = new WritableList(list, Object.class);
        wlist.remove(1);
        Assert.assertEquals((long)2L, (long)list.size());
        list.add("d");
        Assert.assertEquals((long)3L, (long)wlist.size());
    }

    @Test
    public void testListConstructorsDoNotCopy_2() {
        ArrayList<Object> list = new ArrayList<Object>(Arrays.asList("a", "b", "c"));
        WritableList wlist = new WritableList((Realm)new CurrentRealm(true), list, Object.class);
        wlist.remove(1);
        Assert.assertEquals((long)2L, (long)list.size());
        list.add("d");
        Assert.assertEquals((long)3L, (long)wlist.size());
    }

    @Test
    public void testCollectionConstructorsCopy_1() {
        RealmTester.setDefault((Realm)new CurrentRealm(true));
        ArrayList<Object> list = new ArrayList<Object>(Arrays.asList("a", "b", "c"));
        WritableList wlist = new WritableList(list, Object.class);
        wlist.remove(1);
        Assert.assertEquals((long)3L, (long)list.size());
        list.add("d");
        Assert.assertEquals((long)2L, (long)wlist.size());
    }

    @Test
    public void testCollectionConstructorsCopy_2() {
        ArrayList<Object> list = new ArrayList<Object>(Arrays.asList("a", "b", "c"));
        WritableList wlist = new WritableList((Realm)new CurrentRealm(true), list, Object.class);
        wlist.remove(1);
        Assert.assertEquals((long)3L, (long)list.size());
        list.add("d");
        Assert.assertEquals((long)2L, (long)wlist.size());
    }

    public static void addConformanceTest(TestSuite suite) {
        suite.addTest(MutableObservableListContractTest.suite((IObservableCollectionContractDelegate)new Delegate()));
    }

    static class Delegate
    extends AbstractObservableCollectionContractDelegate {
        Delegate() {
        }

        public Object createElement(IObservableCollection collection) {
            return String.valueOf(collection.size() + 1);
        }

        public Object getElementType(IObservableCollection collection) {
            return String.class;
        }

        public IObservableCollection createObservableCollection(Realm realm, int itemCount) {
            WritableList observable = new WritableList(realm, new ArrayList(), String.class);
            int i = 0;
            while (i < itemCount) {
                observable.add((Object)String.valueOf(i));
                ++i;
            }
            return observable;
        }

        public void change(IObservable observable) {
            ((WritableList)observable).add((Object)"");
        }
    }
}

