/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.observable.map;

import java.util.Set;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.map.AbstractObservableMap;
import org.eclipse.core.databinding.observable.map.MapDiff;
import org.eclipse.jface.databinding.conformance.util.CurrentRealm;
import org.eclipse.jface.databinding.conformance.util.RealmTester;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class AbstractObservableMapTest {
    private AbstractObservableMapStub map;

    @Before
    public void setUp() throws Exception {
        RealmTester.setDefault((Realm)new CurrentRealm(true));
        this.map = new AbstractObservableMapStub();
    }

    @After
    public void tearDown() throws Exception {
        RealmTester.setDefault(null);
    }

    @Test
    public void testIsStaleRealmChecks() throws Exception {
        RealmTester.exerciseCurrent(() -> {
            boolean bl = this.map.isStale();
        });
    }

    @Test
    public void testSetStaleRealmChecks() throws Exception {
        RealmTester.exerciseCurrent(() -> this.map.setStale(true));
    }

    @Test
    public void testFireStaleRealmChecks() throws Exception {
        RealmTester.exerciseCurrent(() -> this.map.fireStale());
    }

    @Test
    public void testFireChangeRealmChecks() throws Exception {
        RealmTester.exerciseCurrent(() -> this.map.fireChange());
    }

    @Test
    public void testFireMapChangeRealmChecks() throws Exception {
        RealmTester.exerciseCurrent(() -> this.map.fireMapChange(null));
    }

    @Test
    public void testAddListChangeListener_AfterDispose() {
        this.map.dispose();
        this.map.addMapChangeListener(event -> {});
    }

    @Test
    public void testRemoveListChangeListener_AfterDispose() {
        this.map.dispose();
        this.map.removeMapChangeListener(event -> {});
    }

    @Test
    public void testAddChangeListener_AfterDispose() {
        this.map.dispose();
        this.map.addChangeListener(event -> {});
    }

    @Test
    public void testRemoveChangeListener_AfterDispose() {
        this.map.dispose();
        this.map.removeChangeListener(event -> {});
    }

    @Test
    public void testAddStaleListener_AfterDispose() {
        this.map.dispose();
        this.map.addStaleListener(staleEvent -> {});
    }

    @Test
    public void testRemoveStaleListener_AfterDispose() {
        this.map.dispose();
        this.map.removeStaleListener(staleEvent -> {});
    }

    @Test
    public void testAddDisposeListener_AfterDispose() {
        this.map.dispose();
        this.map.addDisposeListener(event -> {});
    }

    @Test
    public void testRemoveDisposeListener_AfterDispose() {
        this.map.dispose();
        this.map.removeDisposeListener(event -> {});
    }

    @Test
    public void testHasListeners_AfterDispose() {
        this.map.dispose();
        this.map.hasListeners();
    }

    static class AbstractObservableMapStub
    extends AbstractObservableMap {
        AbstractObservableMapStub() {
        }

        public Set entrySet() {
            return null;
        }

        protected void fireChange() {
            super.fireChange();
        }

        protected void fireMapChange(MapDiff diff) {
            super.fireMapChange(diff);
        }

        protected void fireStale() {
            super.fireStale();
        }

        protected synchronized boolean hasListeners() {
            return super.hasListeners();
        }
    }
}

