/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.observable.set;

import java.util.Collection;
import java.util.Collections;
import junit.framework.TestSuite;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.set.DecoratingObservableSet;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.jface.databinding.conformance.MutableObservableCollectionContractTest;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableCollectionContractDelegate;
import org.eclipse.jface.databinding.conformance.delegate.IObservableCollectionContractDelegate;

public class DecoratingObservableSetTest {
    public static void addConformanceTest(TestSuite suite) {
        suite.addTest(MutableObservableCollectionContractTest.suite((IObservableCollectionContractDelegate)new Delegate()));
    }

    static class DecoratingObservableSetStub
    extends DecoratingObservableSet {
        IObservableSet wrappedSet;

        DecoratingObservableSetStub(IObservableSet wrappedSet) {
            super(wrappedSet, true);
            this.wrappedSet = wrappedSet;
        }
    }

    static class Delegate
    extends AbstractObservableCollectionContractDelegate {
        private Object elementType = Object.class;

        Delegate() {
        }

        public IObservableCollection createObservableCollection(Realm realm, int elementCount) {
            WritableSet wrappedSet = new WritableSet(realm, (Collection)Collections.EMPTY_SET, this.elementType);
            int i = 0;
            while (i < elementCount) {
                wrappedSet.add(this.createElement((IObservableCollection)wrappedSet));
                ++i;
            }
            return new DecoratingObservableSetStub((IObservableSet)wrappedSet);
        }

        public Object createElement(IObservableCollection collection) {
            return new Object();
        }

        public Object getElementType(IObservableCollection collection) {
            return this.elementType;
        }

        public void change(IObservable observable) {
            DecoratingObservableSetStub set = (DecoratingObservableSetStub)observable;
            set.wrappedSet.add(this.createElement((IObservableCollection)set));
        }
    }
}

