/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.observable.set;

import java.util.HashSet;
import java.util.Set;
import junit.framework.TestSuite;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.set.ObservableSet;
import org.eclipse.core.databinding.observable.set.SetDiff;
import org.eclipse.jface.databinding.conformance.ObservableCollectionContractTest;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableCollectionContractDelegate;
import org.eclipse.jface.databinding.conformance.delegate.IObservableCollectionContractDelegate;

public class ObservableSetTest {
    public static void addConformanceTest(TestSuite suite) {
        suite.addTest(ObservableCollectionContractTest.suite((IObservableCollectionContractDelegate)new Delegate()));
    }

    private static class Delegate
    extends AbstractObservableCollectionContractDelegate {
        private Delegate() {
        }

        public void change(IObservable observable) {
            ((ObservableSetStub)observable).fireSetChange(Diffs.createSetDiff(new HashSet(), new HashSet()));
        }

        public Object createElement(IObservableCollection collection) {
            return Integer.toString(collection.size());
        }

        public Object getElementType(IObservableCollection collection) {
            return String.class;
        }

        public IObservableCollection createObservableCollection(Realm realm, int elementCount) {
            ObservableSetStub set = new ObservableSetStub(realm, new HashSet(), String.class);
            int i = 0;
            while (i < elementCount) {
                set.add(Integer.toString(i));
                ++i;
            }
            return set;
        }
    }

    private static class ObservableSetStub
    extends ObservableSet {
        protected ObservableSetStub(Realm realm, Set wrappedSet, Object elementType) {
            super(realm, wrappedSet, elementType);
        }

        public void fireSetChange(SetDiff diff) {
            super.fireSetChange(diff);
        }
    }
}

