/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.observable.value;

import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.AbstractVetoableValue;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.jface.databinding.conformance.util.CurrentRealm;
import org.eclipse.jface.databinding.conformance.util.RealmTester;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AbstractVetoableValueTest {
    @Before
    public void setUp() throws Exception {
        RealmTester.setDefault((Realm)new CurrentRealm(true));
    }

    @After
    public void tearDown() throws Exception {
        RealmTester.setDefault(null);
    }

    @Test
    public void testSetValueInvokesDoSetApprovedValue() throws Exception {
        CurrentRealm realm = new CurrentRealm(true);
        class VetoableValue
        extends VetoableValueStub {
            int count;
            Object value;

            VetoableValue(Realm realm) {
                super(realm);
            }

            @Override
            protected void doSetApprovedValue(Object value) {
                ++this.count;
                this.value = value;
            }
        }
        VetoableValue vetoableValue = new VetoableValue((Realm)realm);
        Assert.assertEquals((long)0L, (long)vetoableValue.count);
        Assert.assertEquals(null, (Object)vetoableValue.value);
        Object value = new Object();
        vetoableValue.setValue(value);
        Assert.assertEquals((long)1L, (long)vetoableValue.count);
        Assert.assertEquals((Object)value, (Object)vetoableValue.value);
    }

    @Test
    public void testFireValueChangeRealmChecks() throws Exception {
        RealmTester.exerciseCurrent(() -> {
            VetoableValueStub observable = new VetoableValueStub();
            observable.fireValueChanging(null);
        });
    }

    private static class VetoableValueStub
    extends AbstractVetoableValue {
        VetoableValueStub() {
            this(Realm.getDefault());
        }

        VetoableValueStub(Realm realm) {
            super(realm);
        }

        protected void doSetApprovedValue(Object value) {
        }

        protected Object doGetValue() {
            return null;
        }

        public Object getValueType() {
            return null;
        }

        protected boolean fireValueChanging(ValueDiff diff) {
            return super.fireValueChanging(diff);
        }
    }
}

