/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding;

import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.internal.databinding.BindingStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BindingStatusTest {
    private BindingStatus bindingStatus;

    @Before
    public void setUp() throws Exception {
        this.bindingStatus = BindingStatus.ok();
    }

    @Test
    public void testMessageIsFromStatus() throws Exception {
        String message = "error message";
        IStatus status = ValidationStatus.error((String)message);
        this.bindingStatus.add(status);
        Assert.assertEquals((Object)message, (Object)this.bindingStatus.getMessage());
    }

    @Test
    public void testExceptionIsFromStatus() throws Exception {
        IllegalArgumentException e = new IllegalArgumentException();
        Status status = new Status(0, "org.eclipse.core.databinding", 0, "", (Throwable)e);
        this.bindingStatus.add((IStatus)status);
        Assert.assertEquals((Object)e, (Object)this.bindingStatus.getException());
    }

    @Test
    public void testPluginIsFromStatus() throws Exception {
        String plugin = "test";
        Status status = new Status(0, plugin, 0, "", null);
        this.bindingStatus.add((IStatus)status);
        Assert.assertEquals((Object)plugin, (Object)this.bindingStatus.getPlugin());
    }

    @Test
    public void testCodeIsFromStatus() throws Exception {
        int code = 1;
        Status status = new Status(0, "org.eclipse.core.databinding", code, "", null);
        this.bindingStatus.add((IStatus)status);
        Assert.assertEquals((long)code, (long)status.getCode());
    }

    @Test
    public void testSeverityIsFromStatus() throws Exception {
        IStatus status = ValidationStatus.error((String)"");
        this.bindingStatus.add(status);
        Assert.assertEquals((long)4L, (long)status.getSeverity());
    }

    @Test
    public void testLowerSeverityDoesNotOverwriteGreaterSeverity() throws Exception {
        String info = "info";
        String error = "error";
        this.bindingStatus.add(ValidationStatus.error((String)error));
        Assert.assertEquals((long)4L, (long)this.bindingStatus.getSeverity());
        Assert.assertEquals((Object)error, (Object)this.bindingStatus.getMessage());
        this.bindingStatus.add(ValidationStatus.info((String)info));
        Assert.assertEquals((long)4L, (long)this.bindingStatus.getSeverity());
        Assert.assertEquals((Object)error, (Object)this.bindingStatus.getMessage());
        IStatus[] children = this.bindingStatus.getChildren();
        Assert.assertEquals((long)2L, (long)children.length);
        Assert.assertEquals((long)4L, (long)children[0].getSeverity());
        Assert.assertEquals((long)1L, (long)children[1].getSeverity());
    }

    @Test
    public void testEqual() throws Exception {
        BindingStatus status1 = BindingStatus.ok();
        BindingStatus status2 = BindingStatus.ok();
        Assert.assertEquals((Object)status1, (Object)status2);
    }

    @Test
    public void testNotEqual() throws Exception {
        BindingStatus status1 = BindingStatus.ok();
        BindingStatus status2 = BindingStatus.ok();
        status2.add(ValidationStatus.error((String)""));
        Assert.assertFalse((boolean)status1.equals((Object)status2));
    }

    @Test
    public void testHashCode() throws Exception {
        BindingStatus status1 = BindingStatus.ok();
        BindingStatus status2 = BindingStatus.ok();
        Assert.assertEquals((long)status1.hashCode(), (long)status2.hashCode());
    }

    @Test
    public void testOkInitializesStatus() throws Exception {
        BindingStatus status = BindingStatus.ok();
        Assert.assertEquals((Object)"org.eclipse.core.databinding", (Object)status.getPlugin());
        Assert.assertEquals((Object)"", (Object)status.getMessage());
        Assert.assertEquals((long)0L, (long)status.getCode());
        Assert.assertEquals((long)0L, (long)status.getChildren().length);
        Assert.assertNull((Object)status.getException());
    }
}

