/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.ComputedList;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.set.ComputedSet;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.util.ILogger;
import org.eclipse.core.databinding.util.Policy;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.tests.databinding.observable.ThreadRealm;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DifferentRealmsBindingTest {
    ThreadRealm targetAndModelRealm = new ThreadRealm();
    ThreadRealm validationRealm = new ThreadRealm();
    List<IStatus> errorStatusses = new ArrayList<IStatus>();
    DataBindingContext dbc;
    ILogger logger = status -> {
        if (!status.isOK()) {
            this.errorStatusses.add(status);
        }
    };

    @Before
    public void setUp() throws Exception {
        this.errorStatusses.clear();
        new Thread(){

            @Override
            public void run() {
                DifferentRealmsBindingTest.this.targetAndModelRealm.init(Thread.currentThread());
                DifferentRealmsBindingTest.this.targetAndModelRealm.block();
            }
        }.start();
        this.validationRealm.init(Thread.currentThread());
        this.dbc = new DataBindingContext((Realm)this.validationRealm);
        Policy.setLog((ILogger)this.logger);
    }

    @After
    public void tearDown() throws Exception {
        this.dbc.dispose();
    }

    @Test
    public void testListBindingValidationRealm() throws Throwable {
        WritableList model = new WritableList((Realm)this.targetAndModelRealm);
        WritableList target = new WritableList((Realm)this.targetAndModelRealm);
        this.dbc.bindList((IObservableList)target, (IObservableList)model);
        this.targetAndModelRealm.waitUntilBlocking();
        this.targetAndModelRealm.processQueue();
        this.targetAndModelRealm.unblock();
        Assert.assertTrue((String)this.errorStatusses.toString(), (boolean)this.errorStatusses.isEmpty());
    }

    @Test
    public void testSetBindingValidationRealm() throws Throwable {
        WritableSet model = new WritableSet((Realm)this.targetAndModelRealm);
        WritableSet target = new WritableSet((Realm)this.targetAndModelRealm);
        this.dbc.bindSet((IObservableSet)target, (IObservableSet)model);
        this.targetAndModelRealm.waitUntilBlocking();
        this.targetAndModelRealm.processQueue();
        this.targetAndModelRealm.unblock();
        Assert.assertTrue((String)this.errorStatusses.toString(), (boolean)this.errorStatusses.isEmpty());
    }

    @Test
    public void testBindingCanBeCreatedOutsideOfValidationRealm() throws Exception {
        WritableSet model = new WritableSet((Realm)this.targetAndModelRealm);
        WritableSet target = new WritableSet((Realm)this.targetAndModelRealm);
        this.targetAndModelRealm.unblock();
        AtomicReference exceptionOccured = new AtomicReference();
        Thread t = new Thread((ObservableSet)target, (ObservableSet)model, exceptionOccured){
            private final /* synthetic */ ObservableSet val$target;
            private final /* synthetic */ ObservableSet val$model;
            private final /* synthetic */ AtomicReference val$exceptionOccured;
            {
                this.val$target = observableSet;
                this.val$model = observableSet2;
                this.val$exceptionOccured = atomicReference;
            }

            @Override
            public void run() {
                try {
                    DifferentRealmsBindingTest.this.dbc.bindSet((IObservableSet)this.val$target, (IObservableSet)this.val$model);
                }
                catch (Exception e) {
                    this.val$exceptionOccured.set(e);
                }
            }
        };
        t.start();
        t.join(1000L);
        Assert.assertNull(exceptionOccured.get());
    }

    @Test
    public void testBindComputedListToWritableListInDifferentRealm() {
        WritableValue modelValue = new WritableValue((Realm)this.validationRealm);
        ComputedList<String> model = new ComputedList<String>((Realm)this.validationRealm, (IObservableValue)modelValue){
            private final /* synthetic */ IObservableValue val$modelValue;
            {
                this.val$modelValue = iObservableValue;
                super($anonymous0);
            }

            protected List<String> calculate() {
                return Collections.singletonList((String)this.val$modelValue.getValue());
            }
        };
        WritableList target = new WritableList((Realm)this.targetAndModelRealm);
        this.dbc.bindList((IObservableList)target, (IObservableList)model);
        modelValue.setValue((Object)"Test");
        this.targetAndModelRealm.waitUntilBlocking();
        this.targetAndModelRealm.processQueue();
        this.targetAndModelRealm.unblock();
        Assert.assertTrue((String)this.errorStatusses.toString(), (boolean)this.errorStatusses.isEmpty());
    }

    @Test
    public void testBindComputedSetToWritableSetInDifferentRealm() {
        WritableValue modelValue = new WritableValue((Realm)this.validationRealm);
        ComputedSet<String> model = new ComputedSet<String>((Realm)this.validationRealm, (IObservableValue)modelValue){
            private final /* synthetic */ IObservableValue val$modelValue;
            {
                this.val$modelValue = iObservableValue;
                super($anonymous0);
            }

            protected Set<String> calculate() {
                return Collections.singleton((String)this.val$modelValue.getValue());
            }
        };
        WritableSet target = new WritableSet((Realm)this.targetAndModelRealm);
        this.dbc.bindSet((IObservableSet)target, (IObservableSet)model);
        modelValue.setValue((Object)"Test");
        this.targetAndModelRealm.waitUntilBlocking();
        this.targetAndModelRealm.processQueue();
        this.targetAndModelRealm.unblock();
        Assert.assertTrue((String)this.errorStatusses.toString(), (boolean)this.errorStatusses.isEmpty());
    }

    @Test
    public void testBindComputedValueToWritableValueInDifferentRealm() {
        WritableValue modelValue = new WritableValue((Realm)this.validationRealm);
        ComputedValue<String> model = new ComputedValue<String>((Realm)this.validationRealm, (IObservableValue)modelValue){
            private final /* synthetic */ IObservableValue val$modelValue;
            {
                this.val$modelValue = iObservableValue;
                super($anonymous0);
            }

            protected String calculate() {
                return (String)this.val$modelValue.getValue();
            }
        };
        WritableValue target = new WritableValue((Realm)this.targetAndModelRealm);
        this.dbc.bindValue((IObservableValue)target, (IObservableValue)model);
        modelValue.setValue((Object)"Test");
        this.targetAndModelRealm.waitUntilBlocking();
        this.targetAndModelRealm.processQueue();
        this.targetAndModelRealm.unblock();
        Assert.assertTrue((String)this.errorStatusses.toString(), (boolean)this.errorStatusses.isEmpty());
    }
}

