/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding;

import org.eclipse.core.internal.databinding.observable.Queue;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class QueueTest {
    private Queue queue;

    @Before
    public void setUp() throws Exception {
        this.queue = new Queue();
    }

    @Test
    public void testIsEmpty() {
        Assert.assertTrue((boolean)this.queue.isEmpty());
        this.queue.enqueue((Object)"foo");
        Assert.assertFalse((boolean)this.queue.isEmpty());
        this.queue.enqueue((Object)"bar");
        Assert.assertFalse((boolean)this.queue.isEmpty());
        this.queue.dequeue();
        Assert.assertFalse((boolean)this.queue.isEmpty());
        this.queue.dequeue();
        Assert.assertTrue((boolean)this.queue.isEmpty());
    }

    @Test
    public void testEnqueueAndDequeue() {
        try {
            this.queue.dequeue();
            Assert.fail((String)"expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {}
        this.queue.enqueue((Object)"foo");
        Assert.assertEquals((Object)"foo", (Object)this.queue.dequeue());
        try {
            this.queue.dequeue();
            Assert.fail((String)"expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {}
        this.queue.enqueue((Object)"foo");
        this.queue.enqueue((Object)"bar");
        this.queue.dequeue();
        this.queue.enqueue((Object)"bas");
        this.queue.enqueue((Object)"moo");
        Assert.assertEquals((Object)"bar", (Object)this.queue.dequeue());
        Assert.assertEquals((Object)"bas", (Object)this.queue.dequeue());
        Assert.assertEquals((Object)"moo", (Object)this.queue.dequeue());
        Assert.assertTrue((boolean)this.queue.isEmpty());
    }
}

