/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import junit.framework.TestSuite;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.IBeanObservable;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.tests.internal.databinding.beans.AnnoyingBean;
import org.eclipse.core.tests.internal.databinding.beans.Bean;
import org.eclipse.jface.databinding.conformance.MutableObservableListContractTest;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableCollectionContractDelegate;
import org.eclipse.jface.databinding.conformance.delegate.IObservableCollectionContractDelegate;
import org.eclipse.jface.databinding.conformance.util.CurrentRealm;
import org.eclipse.jface.databinding.conformance.util.ListChangeEventTracker;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.eclipse.swt.widgets.Display;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JavaBeanObservableArrayBasedListTest
extends AbstractDefaultRealmTestCase {
    private IObservableList list;
    private IBeanObservable beanObservable;
    private PropertyDescriptor propertyDescriptor;
    private Bean bean;
    private String propertyName;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.propertyName = "array";
        this.propertyDescriptor = BeanProperties.list(Bean.class, (String)this.propertyName).getPropertyDescriptor();
        this.bean = new Bean(new Object[0]);
        this.list = BeansObservables.observeList((Realm)DisplayRealm.getRealm((Display)Display.getDefault()), (Object)this.bean, (String)this.propertyName);
        this.beanObservable = (IBeanObservable)this.list;
    }

    @Test
    public void testGetObserved() throws Exception {
        Assert.assertSame((Object)this.bean, (Object)this.beanObservable.getObserved());
    }

    @Test
    public void testGetPropertyDescriptor() throws Exception {
        Assert.assertEquals((Object)this.propertyDescriptor, (Object)this.beanObservable.getPropertyDescriptor());
    }

    @Test
    public void testRegistersListenerAfterFirstListenerIsAdded() throws Exception {
        Assert.assertFalse((boolean)this.bean.changeSupport.hasListeners(this.propertyName));
        this.list.addListChangeListener((IListChangeListener)new ListChangeEventTracker());
        Assert.assertTrue((boolean)this.bean.changeSupport.hasListeners(this.propertyName));
    }

    @Test
    public void testRemovesListenerAfterLastListenerIsRemoved() throws Exception {
        ListChangeEventTracker listener = new ListChangeEventTracker();
        this.list.addListChangeListener((IListChangeListener)listener);
        Assert.assertTrue((boolean)this.bean.changeSupport.hasListeners(this.propertyName));
        this.list.removeListChangeListener((IListChangeListener)listener);
        Assert.assertFalse((boolean)this.bean.changeSupport.hasListeners(this.propertyName));
    }

    @Test
    public void testFiresListChangeEvents() throws Exception {
        ListChangeEventTracker listener = new ListChangeEventTracker();
        this.list.addListChangeListener((IListChangeListener)listener);
        Assert.assertEquals((long)0L, (long)listener.count);
        this.bean.setArray(new Bean[]{new Bean()});
        Assert.assertEquals((long)1L, (long)listener.count);
    }

    @Test
    public void testAddAddsElement() throws Exception {
        int count = this.list.size();
        String element = "1";
        Assert.assertEquals((long)0L, (long)count);
        this.list.add((Object)element);
        Assert.assertEquals((long)(count + 1), (long)this.list.size());
        Assert.assertEquals((Object)element, (Object)this.bean.getArray()[count]);
    }

    @Test
    public void testAddListChangeEvent() throws Exception {
        ListChangeEventTracker listener = new ListChangeEventTracker();
        this.list.addListChangeListener((IListChangeListener)listener);
        Assert.assertEquals((long)0L, (long)listener.count);
        String element = "1";
        this.list.add((Object)element);
        Assert.assertEquals((long)1L, (long)listener.count);
        ListChangeEvent event = listener.event;
        Assert.assertSame((Object)this.list, (Object)event.getObservableList());
        JavaBeanObservableArrayBasedListTest.assertDiff(event.diff, Collections.EMPTY_LIST, Collections.singletonList("1"));
    }

    @Test
    public void testAdd_FiresPropertyChangeEvent() throws Exception {
        JavaBeanObservableArrayBasedListTest.assertPropertyChangeEvent(this.bean, () -> {
            boolean bl = this.list.add((Object)"0");
        });
    }

    @Test
    public void testAddWithIndex() throws Exception {
        String element = "1";
        Assert.assertEquals((long)0L, (long)this.list.size());
        this.list.add(0, (Object)element);
        Assert.assertEquals((Object)element, (Object)this.bean.getArray()[0]);
    }

    @Test
    public void testAddAtIndexListChangeEvent() throws Exception {
        String element = "1";
        Assert.assertEquals((long)0L, (long)this.list.size());
        ListChangeEventTracker listener = new ListChangeEventTracker();
        this.list.addListChangeListener((IListChangeListener)listener);
        this.list.add(0, (Object)element);
        ListChangeEvent event = listener.event;
        JavaBeanObservableArrayBasedListTest.assertDiff(event.diff, Collections.EMPTY_LIST, Collections.singletonList("1"));
    }

    @Test
    public void testAddAtIndexPropertyChangeEvent() throws Exception {
        JavaBeanObservableArrayBasedListTest.assertPropertyChangeEvent(this.bean, () -> this.list.add(0, (Object)"0"));
    }

    @Test
    public void testRemove() throws Exception {
        String element = "1";
        this.list.add((Object)element);
        Assert.assertEquals((long)1L, (long)this.bean.getArray().length);
        this.list.remove((Object)element);
        Assert.assertEquals((long)0L, (long)this.bean.getArray().length);
    }

    @Test
    public void testRemoveListChangeEvent() throws Exception {
        String element = "1";
        this.list.add((Object)element);
        Assert.assertEquals((long)1L, (long)this.list.size());
        ListChangeEventTracker listener = new ListChangeEventTracker();
        this.list.addListChangeListener((IListChangeListener)listener);
        this.list.remove((Object)element);
        Assert.assertEquals((long)1L, (long)listener.count);
        ListChangeEvent event = listener.event;
        Assert.assertSame((Object)this.list, (Object)event.getObservableList());
        JavaBeanObservableArrayBasedListTest.assertDiff(event.diff, Collections.singletonList("1"), Collections.EMPTY_LIST);
    }

    @Test
    public void testRemovePropertyChangeEvent() throws Exception {
        this.list.add((Object)"0");
        JavaBeanObservableArrayBasedListTest.assertPropertyChangeEvent(this.bean, () -> {
            boolean bl = this.list.remove((Object)"0");
        });
    }

    @Test
    public void testRemoveAtIndex() throws Exception {
        String element = "1";
        this.list.add((Object)element);
        Assert.assertEquals((Object)element, (Object)this.bean.getArray()[0]);
        this.list.remove(0);
        Assert.assertEquals((long)0L, (long)this.bean.getArray().length);
    }

    @Test
    public void testRemoveAtIndexListChangeEvent() throws Exception {
        String element = "1";
        this.list.add((Object)element);
        Assert.assertEquals((long)1L, (long)this.list.size());
        ListChangeEventTracker listener = new ListChangeEventTracker();
        this.list.addListChangeListener((IListChangeListener)listener);
        this.list.remove(0);
        Assert.assertEquals((long)1L, (long)listener.count);
        ListChangeEvent event = listener.event;
        Assert.assertSame((Object)this.list, (Object)event.getObservableList());
        JavaBeanObservableArrayBasedListTest.assertDiff(event.diff, Collections.singletonList(element), Collections.EMPTY_LIST);
    }

    @Test
    public void testRemoveAtIndexPropertyChangeEvent() throws Exception {
        this.list.add((Object)"0");
        JavaBeanObservableArrayBasedListTest.assertPropertyChangeEvent(this.bean, () -> {
            Object object = this.list.remove(0);
        });
    }

    @Test
    public void testAddAll() throws Exception {
        List<String> elements = Arrays.asList("1", "2");
        Assert.assertEquals((long)0L, (long)this.list.size());
        this.list.addAll(elements);
        Assert.assertEquals((long)2L, (long)this.bean.getArray().length);
    }

    @Test
    public void testAddAllListChangEvent() throws Exception {
        List<String> elements = Arrays.asList("1", "2");
        Assert.assertEquals((long)0L, (long)this.list.size());
        ListChangeEventTracker listener = new ListChangeEventTracker();
        this.list.addListChangeListener((IListChangeListener)listener);
        Assert.assertEquals((long)0L, (long)listener.count);
        this.list.addAll(elements);
        Assert.assertEquals((long)1L, (long)listener.count);
        ListChangeEvent event = listener.event;
        Assert.assertSame((Object)this.list, (Object)event.getObservableList());
        JavaBeanObservableArrayBasedListTest.assertDiff(event.diff, Collections.EMPTY_LIST, Arrays.asList("1", "2"));
    }

    @Test
    public void testAddAllPropertyChangeEvent() throws Exception {
        JavaBeanObservableArrayBasedListTest.assertPropertyChangeEvent(this.bean, () -> {
            boolean bl = this.list.addAll(Arrays.asList("0", "1"));
        });
    }

    @Test
    public void testAddAllAtIndex() throws Exception {
        List<String> elements = Arrays.asList("1", "2");
        this.list.addAll(elements);
        Assert.assertEquals((long)2L, (long)this.list.size());
        this.list.addAll(2, elements);
        Assert.assertEquals((long)4L, (long)this.bean.getArray().length);
        Assert.assertEquals((Object)elements.get(0), (Object)this.bean.getArray()[0]);
        Assert.assertEquals((Object)elements.get(1), (Object)this.bean.getArray()[1]);
    }

    @Test
    public void testAddAllAtIndexListChangeEvent() throws Exception {
        List<String> elements = Arrays.asList("1", "2");
        this.list.addAll(elements);
        ListChangeEventTracker listener = new ListChangeEventTracker();
        this.list.addListChangeListener((IListChangeListener)listener);
        Assert.assertEquals((long)0L, (long)listener.count);
        this.list.addAll(2, elements);
        Assert.assertEquals((long)1L, (long)listener.count);
        ListChangeEvent event = listener.event;
        Assert.assertSame((Object)this.list, (Object)event.getObservableList());
        JavaBeanObservableArrayBasedListTest.assertDiff(event.diff, Arrays.asList("1", "2"), Arrays.asList("1", "2", "1", "2"));
    }

    @Test
    public void testAddAllAtIndexPropertyChangeEvent() throws Exception {
        JavaBeanObservableArrayBasedListTest.assertPropertyChangeEvent(this.bean, () -> {
            boolean bl = this.list.addAll(0, Arrays.asList("1", "2"));
        });
    }

    @Test
    public void testRemoveAll() throws Exception {
        this.list.addAll(Arrays.asList("1", "2", "3", "4"));
        Assert.assertEquals((long)4L, (long)this.bean.getArray().length);
        this.list.removeAll(Arrays.asList("2", "4"));
        Assert.assertEquals((long)2L, (long)this.bean.getArray().length);
        Assert.assertEquals((Object)"1", (Object)this.bean.getArray()[0]);
        Assert.assertEquals((Object)"3", (Object)this.bean.getArray()[1]);
    }

    @Test
    public void testRemoveAllListChangeEvent() throws Exception {
        List<String> elements = Arrays.asList("1", "2");
        this.list.addAll(elements);
        this.list.addAll(elements);
        ListChangeEventTracker listener = new ListChangeEventTracker();
        this.list.addListChangeListener((IListChangeListener)listener);
        Assert.assertEquals((long)0L, (long)listener.count);
        this.list.removeAll(elements);
        ListChangeEvent event = listener.event;
        Assert.assertSame((Object)this.list, (Object)event.getObservableList());
        JavaBeanObservableArrayBasedListTest.assertDiff(event.diff, Arrays.asList("1", "2", "1", "2"), Collections.EMPTY_LIST);
    }

    @Test
    public void testRemoveAllPropertyChangeEvent() throws Exception {
        this.list.add((Object)"0");
        JavaBeanObservableArrayBasedListTest.assertPropertyChangeEvent(this.bean, () -> {
            boolean bl = this.list.removeAll(Arrays.asList("0"));
        });
    }

    @Test
    public void testRetainAll() throws Exception {
        List<String> elements = Arrays.asList("0", "1", "2", "3");
        this.list.addAll(elements);
        Assert.assertEquals((long)4L, (long)this.bean.getArray().length);
        this.list.retainAll(elements.subList(0, 2));
        Assert.assertEquals((long)2L, (long)this.bean.getArray().length);
        Assert.assertEquals((Object)elements.get(0), (Object)this.bean.getArray()[0]);
        Assert.assertEquals((Object)elements.get(1), (Object)this.bean.getArray()[1]);
    }

    @Test
    public void testRetainAllListChangeEvent() throws Exception {
        List<String> elements = Arrays.asList("0", "1", "2", "3");
        this.list.addAll(elements);
        ListChangeEventTracker listener = new ListChangeEventTracker();
        this.list.addListChangeListener((IListChangeListener)listener);
        Assert.assertEquals((long)0L, (long)listener.count);
        this.list.retainAll(elements.subList(0, 2));
        Assert.assertEquals((long)1L, (long)listener.count);
        ListChangeEvent event = listener.event;
        Assert.assertSame((Object)this.list, (Object)event.getObservableList());
        JavaBeanObservableArrayBasedListTest.assertDiff(event.diff, Arrays.asList("0", "1", "2", "3"), Arrays.asList("0", "1"));
    }

    @Test
    public void testRetainAllPropertyChangeEvent() throws Exception {
        this.list.addAll(Arrays.asList("0", "1"));
        JavaBeanObservableArrayBasedListTest.assertPropertyChangeEvent(this.bean, () -> {
            boolean bl = this.list.retainAll(Arrays.asList("0"));
        });
    }

    @Test
    public void testSet() throws Exception {
        String oldElement = "old";
        String newElement = "new";
        this.list.add((Object)oldElement);
        Assert.assertEquals((Object)oldElement, (Object)this.bean.getArray()[0]);
        this.list.set(0, (Object)newElement);
        Assert.assertEquals((Object)newElement, (Object)this.bean.getArray()[0]);
    }

    @Test
    public void testMove() throws Exception {
        String element0 = "element0";
        String element1 = "element1";
        this.list.add((Object)element0);
        this.list.add((Object)element1);
        Assert.assertEquals((long)2L, (long)this.bean.getArray().length);
        Assert.assertEquals((Object)element0, (Object)this.bean.getArray()[0]);
        Assert.assertEquals((Object)element1, (Object)this.bean.getArray()[1]);
        this.list.move(0, 1);
        Assert.assertEquals((long)2L, (long)this.bean.getArray().length);
        Assert.assertEquals((Object)element1, (Object)this.bean.getArray()[0]);
        Assert.assertEquals((Object)element0, (Object)this.bean.getArray()[1]);
    }

    @Test
    public void testSetListChangeEvent() throws Exception {
        String oldElement = "old";
        String newElement = "new";
        this.list.add((Object)oldElement);
        ListChangeEventTracker listener = new ListChangeEventTracker();
        this.list.addListChangeListener((IListChangeListener)listener);
        Assert.assertEquals((long)0L, (long)listener.count);
        this.list.set(0, (Object)newElement);
        Assert.assertEquals((long)1L, (long)listener.count);
        ListChangeEvent event = listener.event;
        Assert.assertSame((Object)this.list, (Object)event.getObservableList());
        JavaBeanObservableArrayBasedListTest.assertDiff(event.diff, Collections.singletonList(oldElement), Collections.singletonList(newElement));
    }

    @Test
    public void testSetPropertyChangeEvent() throws Exception {
        this.list.add((Object)"0");
        JavaBeanObservableArrayBasedListTest.assertPropertyChangeEvent(this.bean, () -> {
            Object object = this.list.set(0, (Object)"1");
        });
    }

    @Test
    public void testListChangeEventFiresWhenNewListIsSet() throws Exception {
        Object[] elements = new Bean[]{new Bean(), new Bean()};
        ListChangeEventTracker listener = new ListChangeEventTracker();
        this.list.addListChangeListener((IListChangeListener)listener);
        Assert.assertEquals((long)0L, (long)listener.count);
        this.bean.setArray(elements);
        Assert.assertEquals((long)1L, (long)listener.count);
    }

    @Test
    public void testSetBeanProperty_CorrectForNullOldAndNewValues() {
        AnnoyingBean bean = new AnnoyingBean();
        ((Bean)bean).setArray(new Object[]{"old"});
        IObservableList observable = BeansObservables.observeList((Realm)new CurrentRealm(true), (Object)bean, (String)"array");
        ListChangeEventTracker tracker = ListChangeEventTracker.observe((IObservableList)observable);
        ((Bean)bean).setArray(new Object[]{"new"});
        Assert.assertEquals((long)1L, (long)tracker.count);
        ArrayList<String> list = new ArrayList<String>();
        list.add("old");
        tracker.event.diff.applyTo(list);
        Assert.assertEquals(Collections.singletonList("new"), list);
    }

    @Test
    public void testModifyObservableList_FiresListChange() {
        Bean bean = new Bean(new Object[]{"old"});
        IObservableList observable = BeansObservables.observeList((Object)bean, (String)"array");
        ListChangeEventTracker tracker = ListChangeEventTracker.observe((IObservableList)observable);
        observable.set(0, (Object)"new");
        Assert.assertEquals((long)1L, (long)tracker.count);
        JavaBeanObservableArrayBasedListTest.assertDiff(tracker.event.diff, Collections.singletonList("old"), Collections.singletonList("new"));
    }

    @Test
    public void testSetBeanPropertyOutsideRealm_FiresEventInsideRealm() {
        Bean bean = new Bean(new Object[0]);
        CurrentRealm realm = new CurrentRealm(true);
        IObservableList observable = BeansObservables.observeList((Realm)realm, (Object)bean, (String)"array");
        ListChangeEventTracker tracker = ListChangeEventTracker.observe((IObservableList)observable);
        realm.setCurrent(false);
        bean.setArray(new Object[]{"element"});
        Assert.assertEquals((long)0L, (long)tracker.count);
        realm.setCurrent(true);
        Assert.assertEquals((long)1L, (long)tracker.count);
        JavaBeanObservableArrayBasedListTest.assertDiff(tracker.event.diff, Collections.EMPTY_LIST, Collections.singletonList("element"));
    }

    private static void assertDiff(ListDiff diff, List oldList, List newList) {
        oldList = new ArrayList(oldList);
        diff.applyTo(oldList);
        Assert.assertEquals((String)"applying diff to list did not produce expected result", (Object)newList, oldList);
    }

    private static void assertPropertyChangeEvent(Bean bean, Runnable runnable) {
        PropertyChangeTracker listener = new PropertyChangeTracker();
        bean.addPropertyChangeListener(listener);
        Object[] old = bean.getArray();
        Assert.assertEquals((long)0L, (long)listener.count);
        runnable.run();
        PropertyChangeEvent event = listener.evt;
        Assert.assertEquals((String)"event did not fire", (long)1L, (long)listener.count);
        Assert.assertEquals((Object)"array", (Object)event.getPropertyName());
        Assert.assertTrue((String)"old value", (boolean)Arrays.equals(old, (Object[])event.getOldValue()));
        Assert.assertTrue((String)"new value", (boolean)Arrays.equals(bean.getArray(), (Object[])event.getNewValue()));
        Assert.assertFalse((String)"lists are equal", (boolean)Arrays.equals(bean.getArray(), old));
    }

    public static void addConformanceTest(TestSuite suite) {
        suite.addTest(MutableObservableListContractTest.suite((IObservableCollectionContractDelegate)new Delegate()));
    }

    static class Delegate
    extends AbstractObservableCollectionContractDelegate {
        Delegate() {
        }

        public IObservableCollection createObservableCollection(Realm realm, int elementCount) {
            String propertyName = "array";
            Bean bean = new Bean(new Object[0]);
            IObservableList list = BeansObservables.observeList((Realm)realm, (Object)bean, (String)propertyName, String.class);
            int i = 0;
            while (i < elementCount) {
                list.add(this.createElement((IObservableCollection)list));
                ++i;
            }
            return list;
        }

        public Object createElement(IObservableCollection collection) {
            return new Object();
        }

        public Object getElementType(IObservableCollection collection) {
            return String.class;
        }

        public void change(IObservable observable) {
            IObservableList list = (IObservableList)observable;
            list.add(this.createElement((IObservableCollection)list));
        }
    }

    private static class PropertyChangeTracker
    implements PropertyChangeListener {
        int count;
        PropertyChangeEvent evt;

        private PropertyChangeTracker() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ++this.count;
            this.evt = evt;
        }
    }
}

