/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.beans;

import java.beans.PropertyDescriptor;
import junit.framework.TestSuite;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.IBeanObservable;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.tests.internal.databinding.beans.AnnoyingBean;
import org.eclipse.core.tests.internal.databinding.beans.Bean;
import org.eclipse.jface.databinding.conformance.MutableObservableValueContractTest;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.delegate.IObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.util.ChangeEventTracker;
import org.eclipse.jface.databinding.conformance.util.CurrentRealm;
import org.eclipse.jface.databinding.conformance.util.ValueChangeEventTracker;
import org.eclipse.jface.examples.databinding.model.SimplePerson;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JavaBeanObservableValueTest
extends AbstractDefaultRealmTestCase {
    private Bean bean;
    private IObservableValue observableValue;
    private IBeanObservable beanObservable;
    private PropertyDescriptor propertyDescriptor;
    private String propertyName;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.bean = new Bean();
        this.propertyName = "value";
        this.propertyDescriptor = BeanProperties.value(Bean.class, (String)this.propertyName).getPropertyDescriptor();
        this.observableValue = BeansObservables.observeValue((Object)this.bean, (String)this.propertyName);
        this.beanObservable = (IBeanObservable)this.observableValue;
    }

    @Test
    public void testGetObserved() throws Exception {
        Assert.assertEquals((Object)this.bean, (Object)this.beanObservable.getObserved());
    }

    @Test
    public void testGetPropertyDescriptor() throws Exception {
        Assert.assertEquals((Object)this.propertyDescriptor, (Object)this.beanObservable.getPropertyDescriptor());
    }

    @Test
    public void testSetValueThrowsExceptionThrownByBean() throws Exception {
        ThrowsSetException temp = new ThrowsSetException();
        IObservableValue observable = BeansObservables.observeValue((Object)temp, (String)"value");
        try {
            observable.setValue((Object)"");
            Assert.fail((String)"exception should have been thrown");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)temp.thrownException, (Object)e.getCause());
        }
    }

    @Test
    public void testGetValueThrowsExceptionThrownByBean() throws Exception {
        ThrowsGetException temp = new ThrowsGetException();
        IObservableValue observable = BeansObservables.observeValue((Object)temp, (String)"value");
        try {
            observable.getValue();
            Assert.fail((String)"exception should have been thrown");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)temp.thrownException, (Object)e.getCause());
        }
    }

    @Test
    public void testBug198519() {
        SimplePerson person = new SimplePerson();
        ComputedValue cv = new ComputedValue(person){
            final IObservableValue name;
            {
                this.name = BeansObservables.observeValue((Object)simplePerson, (String)"name");
            }

            protected Object calculate() {
                return this.name.getValue() != null;
            }
        };
        cv.addChangeListener(event -> {
            Object object = cv.getValue();
        });
        person.setName("foo");
    }

    @Test
    public void testConstructor_RegistersListeners() throws Exception {
        IObservableValue observable = BeansObservables.observeValue((Object)this.bean, (String)this.propertyName);
        ChangeEventTracker.observe((IObservable)observable);
        Assert.assertTrue((boolean)this.bean.hasListeners(this.propertyName));
    }

    @Test
    public void testConstructor_SkipRegisterListeners() throws Exception {
        IObservableValue observable = PojoObservables.observeValue((Object)this.bean, (String)this.propertyName);
        ChangeEventTracker.observe((IObservable)observable);
        Assert.assertFalse((boolean)this.bean.hasListeners(this.propertyName));
    }

    @Test
    public void testSetBeanProperty_CorrectForNullOldAndNewValues() {
        AnnoyingBean bean = new AnnoyingBean();
        ((Bean)bean).setValue("old");
        IObservableValue observable = BeansObservables.observeValue((Object)bean, (String)"value");
        ValueChangeEventTracker tracker = ValueChangeEventTracker.observe((IObservableValue)observable);
        ((Bean)bean).setValue("new");
        Assert.assertEquals((long)1L, (long)tracker.count);
        Assert.assertEquals((Object)"old", (Object)tracker.event.diff.getOldValue());
        Assert.assertEquals((Object)"new", (Object)tracker.event.diff.getNewValue());
    }

    @Test
    public void testSetBeanPropertyOutsideRealm_FiresEventInsideRealm() {
        Bean bean = new Bean("old");
        CurrentRealm realm = new CurrentRealm(true);
        IObservableValue observable = BeansObservables.observeValue((Realm)realm, (Object)bean, (String)"value");
        ValueChangeEventTracker tracker = ValueChangeEventTracker.observe((IObservableValue)observable);
        realm.setCurrent(false);
        bean.setValue("new");
        Assert.assertEquals((long)0L, (long)tracker.count);
        realm.setCurrent(true);
        Assert.assertEquals((long)1L, (long)tracker.count);
        Assert.assertEquals((Object)Diffs.createValueDiff((Object)"old", (Object)"new"), (Object)tracker.event.diff);
    }

    public static void addConformanceTest(TestSuite suite) {
        suite.addTest(MutableObservableValueContractTest.suite((IObservableValueContractDelegate)new Delegate()));
    }

    static class Delegate
    extends AbstractObservableValueContractDelegate {
        private Bean bean;

        Delegate() {
        }

        public void setUp() {
            super.setUp();
            this.bean = new Bean("");
        }

        public IObservableValue createObservableValue(Realm realm) {
            return BeansObservables.observeValue((Realm)realm, (Object)this.bean, (String)"value");
        }

        public void change(IObservable observable) {
            IObservableValue observableValue = (IObservableValue)observable;
            observableValue.setValue(this.createValue(observableValue));
        }

        public Object getValueType(IObservableValue observable) {
            return String.class;
        }

        public Object createValue(IObservableValue observable) {
            return observable.getValue() + "a";
        }
    }

    class ThrowsGetException {
        public String value;
        NullPointerException thrownException;

        ThrowsGetException() {
        }

        public String getValue() {
            this.thrownException = new NullPointerException();
            throw this.thrownException;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    class ThrowsSetException {
        private String value;
        NullPointerException thrownException;

        ThrowsSetException() {
        }

        public void setValue(String value) {
            this.thrownException = new NullPointerException();
            throw this.thrownException;
        }

        public String getValue() {
            return this.value;
        }
    }
}

