/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.beans;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.tests.internal.databinding.beans.AnnoyingBean;
import org.eclipse.core.tests.internal.databinding.beans.Bean;
import org.eclipse.jface.databinding.conformance.util.CurrentRealm;
import org.eclipse.jface.databinding.conformance.util.MapChangeEventTracker;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.junit.Assert;
import org.junit.Test;

public class JavaBeanPropertyObservableMapTest
extends AbstractDefaultRealmTestCase {
    @Test
    public void testSetBeanProperty_CorrectForNullOldAndNewValues() {
        AnnoyingBean bean = new AnnoyingBean();
        ((Bean)bean).setMap(Collections.singletonMap("key", "old"));
        IObservableMap map = BeansObservables.observeMap((Realm)new CurrentRealm(true), (Object)bean, (String)"map");
        MapChangeEventTracker tracker = MapChangeEventTracker.observe((IObservableMap)map);
        ((Bean)bean).setMap(Collections.singletonMap("key", "new"));
        Assert.assertEquals((long)1L, (long)tracker.count);
        Assert.assertEquals((Object)Collections.EMPTY_SET, (Object)tracker.event.diff.getAddedKeys());
        Assert.assertEquals(Collections.singleton("key"), (Object)tracker.event.diff.getChangedKeys());
        Assert.assertEquals((Object)Collections.EMPTY_SET, (Object)tracker.event.diff.getRemovedKeys());
        Assert.assertEquals((Object)"old", (Object)tracker.event.diff.getOldValue((Object)"key"));
        Assert.assertEquals((Object)"new", (Object)tracker.event.diff.getNewValue((Object)"key"));
    }

    @Test
    public void testUpdatedBeanMapIsModifiable() {
        Bean bean = new Bean(new ArrayList());
        IObservableMap observable = BeansObservables.observeMap((Object)bean, (String)"map");
        observable.put(new Object(), new Object());
        bean.getMap().clear();
    }

    @Test
    public void testUpdatedPojoMapIsModifiable() {
        Bean bean = new Bean(new ArrayList());
        IObservableMap observable = PojoObservables.observeMap((Object)bean, (String)"map");
        observable.put(new Object(), new Object());
        bean.getMap().clear();
    }
}

