/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.conversion;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.internal.databinding.BindingMessages;
import org.eclipse.core.internal.databinding.conversion.DateConversionSupport;
import org.junit.Assert;
import org.junit.Test;

public class DateConversionSupportTest {
    @Test
    public void testDatePatternIsExternalized() throws Exception {
        StubConverter stub = new StubConverter();
        String key = "DateFormat_DateTime";
        String format = BindingMessages.getString((String)key);
        Assert.assertFalse((String)"format is defined", (boolean)key.equals(format));
        SimpleDateFormat dateFormat = (SimpleDateFormat)stub.getDateFormat(0);
        Assert.assertEquals((Object)format, (Object)dateFormat.toPattern());
    }

    @Test
    public void testTimePatternIsExternalized() throws Exception {
        StubConverter stub = new StubConverter();
        String key = "DateFormat_Time";
        String format = BindingMessages.getString((String)key);
        Assert.assertFalse((String)"format is defined", (boolean)key.equals(format));
        SimpleDateFormat dateFormat = (SimpleDateFormat)stub.getDateFormat(1);
        Assert.assertEquals((Object)format, (Object)dateFormat.toPattern());
    }

    @Test
    public void testFormat_NullDate() {
        StubConverter stub = new StubConverter();
        Assert.assertNull((Object)stub.format(null));
    }

    static class StubConverter
    extends DateConversionSupport {
        StubConverter() {
        }

        protected DateFormat getDateFormat(int index) {
            return super.getDateFormat(index);
        }

        protected String format(Date date) {
            return super.format(date);
        }
    }
}

