/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.conversion;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.internal.databinding.BindingMessages;
import org.eclipse.core.internal.databinding.conversion.StringToBooleanConverter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StringToBooleanConverterTest {
    private StringToBooleanConverter converter;
    private List<String> trueValues;
    private List<String> falseValues;

    @Before
    public void setUp() {
        this.trueValues = Collections.unmodifiableList(this.toValues(BindingMessages.getString((String)"ValueDelimiter"), BindingMessages.getString((String)"TrueStringValues")));
        this.falseValues = Collections.unmodifiableList(this.toValues(BindingMessages.getString((String)"ValueDelimiter"), BindingMessages.getString((String)"FalseStringValues")));
        this.converter = new StringToBooleanConverter();
        Assert.assertTrue((this.trueValues.size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.falseValues.size() > 0 ? 1 : 0) != 0);
    }

    private List<String> toValues(String delimiter, String values) {
        StringTokenizer tokenizer = new StringTokenizer(values, delimiter);
        LinkedList<String> result = new LinkedList<String>();
        while (tokenizer.hasMoreTokens()) {
            result.add(tokenizer.nextToken());
        }
        return result;
    }

    @Test
    public void testConvertsToTrue() throws Exception {
        Boolean result = this.converter.convert(this.trueValues.get(0));
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testConvertsToFalse() throws Exception {
        Boolean result = this.converter.convert(this.falseValues.get(0));
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testUpperCaseStringConvertsToTrue() throws Exception {
        Boolean result = this.converter.convert(this.trueValues.get(0).toUpperCase());
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testUpperCaseStringConvertsToFalse() throws Exception {
        Boolean result = this.converter.convert(this.falseValues.get(0).toUpperCase());
        Assert.assertFalse((boolean)result);
    }
}

