/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.conversion;

import com.ibm.icu.text.NumberFormat;
import org.eclipse.core.internal.databinding.conversion.StringToByteConverter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StringToByteConverterTest {
    private NumberFormat numberFormat;
    private StringToByteConverter converter;

    @Before
    public void setUp() throws Exception {
        this.numberFormat = NumberFormat.getIntegerInstance();
        this.converter = StringToByteConverter.toByte((NumberFormat)this.numberFormat, (boolean)false);
    }

    @Test
    public void testConvertsToByte() throws Exception {
        Byte value = 1;
        Byte result = this.converter.convert((Object)this.numberFormat.format((Object)value));
        Assert.assertEquals((Object)value, (Object)result);
    }

    @Test
    public void testConvertsToBytePrimitive() throws Exception {
        this.converter = StringToByteConverter.toByte((NumberFormat)this.numberFormat, (boolean)true);
        Byte value = 1;
        Byte result = this.converter.convert((Object)this.numberFormat.format((Object)value));
        Assert.assertEquals((Object)value, (Object)result);
    }

    @Test
    public void testFromTypeIsString() throws Exception {
        Assert.assertEquals(String.class, (Object)this.converter.getFromType());
    }

    @Test
    public void testToTypeIsShort() throws Exception {
        Assert.assertEquals(Byte.class, (Object)this.converter.getToType());
    }

    @Test
    public void testToTypeIsBytePrimitive() throws Exception {
        this.converter = StringToByteConverter.toByte((boolean)true);
        Assert.assertEquals(Byte.TYPE, (Object)this.converter.getToType());
    }

    @Test
    public void testReturnsNullBoxedTypeForEmptyString() throws Exception {
        Assert.assertNull((Object)this.converter.convert((Object)""));
    }

    @Test
    public void testThrowsIllegalArgumentExceptionIfAskedToConvertNonString() throws Exception {
        try {
            this.converter.convert((Object)new Integer(1));
            Assert.fail((String)"exception should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }
}

