/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.conversion;

import com.ibm.icu.text.NumberFormat;
import org.eclipse.core.internal.databinding.conversion.StringToNumberParser;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StringToNumberParserTest {
    private NumberFormat integerFormat;

    @Before
    public void setUp() throws Exception {
        this.integerFormat = NumberFormat.getIntegerInstance();
    }

    @Test
    public void testParseNonStringThrowsIllegalArgumentException() throws Exception {
        try {
            StringToNumberParser.parse((Object)0, (NumberFormat)this.integerFormat, (boolean)false);
            Assert.fail((String)"exception should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void testEmptyStringReturnsNullIfNotPrimitive() throws Exception {
        StringToNumberParser.ParseResult result = StringToNumberParser.parse((Object)"", (NumberFormat)this.integerFormat, (boolean)false);
        Assert.assertNull((Object)result.getNumber());
    }

    @Test
    public void testReturnsParsePositionWhenValueCannotBeParsed() throws Exception {
        StringToNumberParser.ParseResult result = StringToNumberParser.parse((Object)"adsf", (NumberFormat)this.integerFormat, (boolean)false);
        Assert.assertNotNull((Object)result.getPosition());
        Assert.assertNull((Object)result.getNumber());
    }

    @Test
    public void testReturnsNumberWhenSuccessfullyParsed() throws Exception {
        Integer number = 5;
        StringToNumberParser.ParseResult result = StringToNumberParser.parse((Object)this.integerFormat.format(number.longValue()), (NumberFormat)this.integerFormat, (boolean)false);
        Assert.assertNull((Object)result.getPosition());
        Assert.assertEquals((long)number.intValue(), (long)result.getNumber().intValue());
    }
}

