/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.conversion;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.core.internal.databinding.conversion.StringToNumberParser;
import org.junit.Assert;
import org.junit.Test;

public abstract class StringToNumberParserTestHarness {
    protected abstract Number getValidMax();

    protected abstract Number getValidMin();

    protected abstract boolean assertValid(Number var1);

    @Test
    public void testRanges() throws Exception {
        Number min = this.getValidMin();
        Number max = this.getValidMax();
        double minDouble = min.doubleValue();
        double maxDouble = max.doubleValue();
        Assert.assertTrue((String)"valid byte", (boolean)this.assertValid((byte)1));
        Assert.assertTrue((String)"valid byte min", (boolean)this.assertValid((byte)-128));
        Assert.assertTrue((String)"valid byte max", (boolean)this.assertValid((byte)127));
        Assert.assertTrue((String)"valid short", (boolean)this.assertValid((short)1));
        boolean result = this.assertValid((short)Short.MIN_VALUE);
        if (minDouble > -32768.0) {
            Assert.assertFalse((String)"invalid short min", (boolean)result);
        } else {
            Assert.assertTrue((String)"valid short min", (boolean)result);
        }
        result = this.assertValid((short)Short.MAX_VALUE);
        if (maxDouble < 32767.0) {
            Assert.assertFalse((String)"invalid short max", (boolean)result);
        } else {
            Assert.assertTrue((String)"valid short max", (boolean)result);
        }
        Assert.assertTrue((String)"valid Integer", (boolean)this.assertValid(1));
        result = this.assertValid(Integer.MIN_VALUE);
        if (minDouble > -2.147483648E9) {
            Assert.assertFalse((String)"invalid Integer min", (boolean)result);
        } else {
            Assert.assertTrue((String)"valid integer min", (boolean)result);
        }
        result = this.assertValid(Integer.MAX_VALUE);
        if (maxDouble < 2.147483647E9) {
            Assert.assertFalse((String)"valid Integer max", (boolean)result);
        } else {
            Assert.assertTrue((String)"valid integer max", (boolean)result);
        }
        Assert.assertTrue((String)"valid long", (boolean)this.assertValid(1L));
        result = this.assertValid(Long.MIN_VALUE);
        if (minDouble > -9.223372036854776E18) {
            Assert.assertFalse((String)"invalid long min", (boolean)result);
        } else {
            Assert.assertTrue((String)"valid long min", (boolean)result);
        }
        result = this.assertValid(Long.MAX_VALUE);
        if (maxDouble < 9.223372036854776E18) {
            Assert.assertFalse((String)"invalid long max", (boolean)result);
        } else {
            Assert.assertTrue((String)"valid long max", (boolean)result);
        }
        Assert.assertTrue((String)"valid float", (boolean)this.assertValid(new Float(1.0f)));
        result = this.assertValid(new Float(-3.4028235E38f));
        if (minDouble > -3.4028234663852886E38) {
            Assert.assertFalse((String)"invalid float min", (boolean)result);
        } else {
            Assert.assertTrue((String)"valid float min", (boolean)result);
        }
        result = this.assertValid(new Float(Float.MAX_VALUE));
        if (maxDouble < 3.4028234663852886E38) {
            Assert.assertFalse((String)"invalid float max", (boolean)result);
        } else {
            Assert.assertTrue((String)"valid float max", (boolean)result);
        }
        Assert.assertFalse((String)"invalid negative float infinity", (boolean)this.assertValid(new Float(Float.NEGATIVE_INFINITY)));
        Assert.assertFalse((String)"invalid positive float infinity", (boolean)this.assertValid(new Float(Float.POSITIVE_INFINITY)));
        Assert.assertFalse((String)"invalid float NaN", (boolean)this.assertValid(new Float(Float.NaN)));
        Assert.assertTrue((String)"valid double", (boolean)this.assertValid(new Double(1.0)));
        result = this.assertValid(new Double(-1.7976931348623157E308));
        if (minDouble > -1.7976931348623157E308) {
            Assert.assertFalse((String)"invalid double min", (boolean)result);
        } else {
            Assert.assertTrue((String)"valid double min", (boolean)result);
        }
        result = this.assertValid(new Double(Double.MAX_VALUE));
        if (maxDouble < Double.MAX_VALUE) {
            Assert.assertFalse((String)"invalid float max", (boolean)result);
        } else {
            Assert.assertTrue((String)"valid float max", (boolean)result);
        }
        Assert.assertFalse((String)"invalid negative double infinity", (boolean)this.assertValid(new Double(Double.NEGATIVE_INFINITY)));
        Assert.assertFalse((String)"invalid positive double infinity", (boolean)this.assertValid(new Double(Double.POSITIVE_INFINITY)));
        Assert.assertFalse((String)"invalid double NaN", (boolean)this.assertValid(new Double(Double.NaN)));
        Assert.assertTrue((String)"valid BigInteger", (boolean)this.assertValid(BigInteger.valueOf(1L)));
        BigDecimal bigDecimalMin = new BigDecimal(min.doubleValue());
        bigDecimalMin = bigDecimalMin.subtract(new BigDecimal(1));
        Assert.assertFalse((String)"invalid BigInteger min", (boolean)this.assertValid(bigDecimalMin.toBigInteger()));
        BigDecimal bigDecimalMax = new BigDecimal(max.doubleValue());
        bigDecimalMax = bigDecimalMax.add(new BigDecimal(1));
        Assert.assertFalse((String)"invalid BigInteger max", (boolean)this.assertValid(bigDecimalMax.toBigInteger()));
        Assert.assertTrue((String)"valid BigDecimal", (boolean)this.assertValid(new BigDecimal(1)));
        Assert.assertFalse((String)"invalid BigDecimal min", (boolean)this.assertValid(bigDecimalMin));
        Assert.assertFalse((String)"invalid BigDecimal max", (boolean)this.assertValid(bigDecimalMax));
        class MyNumber
        extends Number {
            double value;
            int count;
            private static final long serialVersionUID = 1L;

            MyNumber(double value) {
                this.value = value;
            }

            @Override
            public double doubleValue() {
                ++this.count;
                return this.value;
            }

            @Override
            public float floatValue() {
                return 0.0f;
            }

            @Override
            public int intValue() {
                return 0;
            }

            @Override
            public long longValue() {
                return 0L;
            }
        }
        MyNumber number = new MyNumber(1.0);
        Assert.assertEquals((long)0L, (long)number.count);
        Assert.assertTrue((boolean)StringToNumberParser.inIntegerRange((Number)number));
        Assert.assertTrue((String)"double value retrieved", (number.count > 0 ? 1 : 0) != 0);
    }
}

