/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.conversion;

import com.ibm.icu.text.NumberFormat;
import org.eclipse.core.internal.databinding.conversion.StringToShortConverter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StringToShortConverterTest {
    private NumberFormat numberFormat;
    private StringToShortConverter converter;

    @Before
    public void setUp() throws Exception {
        this.numberFormat = NumberFormat.getIntegerInstance();
        this.converter = StringToShortConverter.toShort((NumberFormat)this.numberFormat, (boolean)false);
    }

    @Test
    public void testConvertsToShort() throws Exception {
        Short value = 1;
        Short result = this.converter.convert((Object)this.numberFormat.format((Object)value));
        Assert.assertEquals((Object)value, (Object)result);
    }

    @Test
    public void testConvertsToShortPrimitive() throws Exception {
        this.converter = StringToShortConverter.toShort((NumberFormat)this.numberFormat, (boolean)true);
        Short value = 1;
        Short result = this.converter.convert((Object)this.numberFormat.format((Object)value));
        Assert.assertEquals((Object)value, (Object)result);
    }

    @Test
    public void testFromTypeIsString() throws Exception {
        Assert.assertEquals(String.class, (Object)this.converter.getFromType());
    }

    @Test
    public void testToTypeIsShort() throws Exception {
        Assert.assertEquals(Short.class, (Object)this.converter.getToType());
    }

    @Test
    public void testToTypeIsShortPrimitive() throws Exception {
        this.converter = StringToShortConverter.toShort((boolean)true);
        Assert.assertEquals(Short.TYPE, (Object)this.converter.getToType());
    }

    @Test
    public void testReturnsNullBoxedTypeForEmptyString() throws Exception {
        Assert.assertNull((Object)this.converter.convert((Object)""));
    }

    @Test
    public void testThrowsIllegalArgumentExceptionIfAskedToConvertNonString() throws Exception {
        try {
            this.converter.convert((Object)1);
            Assert.fail((String)"exception should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }
}

