/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.observable;

import junit.framework.TestSuite;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.conformance.MutableObservableValueContractTest;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.delegate.IObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.util.ValueChangeEventTracker;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.eclipse.swt.widgets.Display;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DelayedObservableValueTest
extends AbstractDefaultRealmTestCase {
    private Object oldValue;
    private Object newValue;
    private ObservableValueStub target;
    private IObservableValue delayed;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.target = new ObservableValueStub(Realm.getDefault());
        this.oldValue = new Object();
        this.newValue = new Object();
        this.target.setValue(this.oldValue);
        this.delayed = Observables.observeDelayedValue((int)1, (IObservableValue)this.target);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.target.dispose();
        this.target = null;
        super.tearDown();
    }

    @Test
    public void testIsStale_WhenTargetIsStale() {
        Assert.assertFalse((boolean)this.target.isStale());
        Assert.assertFalse((boolean)this.delayed.isStale());
        this.target.fireStale();
        Assert.assertTrue((boolean)this.target.isStale());
        Assert.assertTrue((boolean)this.delayed.isStale());
    }

    @Test
    public void testIsStale_DuringDelay() {
        Assert.assertFalse((boolean)this.target.isStale());
        Assert.assertFalse((boolean)this.delayed.isStale());
        this.target.setValue(this.newValue);
        Assert.assertFalse((boolean)this.target.isStale());
        Assert.assertTrue((boolean)this.delayed.isStale());
    }

    @Test
    public void testGetValueType_SameAsTarget() {
        Assert.assertEquals((Object)this.target.getValueType(), (Object)this.delayed.getValueType());
    }

    @Test
    public void testGetValue_FiresPendingValueChange() {
        this.assertFiresPendingValueChange(() -> {
            Object value = this.delayed.getValue();
            Assert.assertEquals((Object)this.newValue, (Object)value);
        });
    }

    @Test
    public void testSetValue_PropagatesToTarget() {
        Assert.assertEquals((Object)this.oldValue, (Object)this.delayed.getValue());
        Assert.assertEquals((Object)this.oldValue, (Object)this.target.getValue());
        this.delayed.setValue(this.newValue);
        Assert.assertEquals((Object)this.newValue, (Object)this.target.getValue());
        Assert.assertEquals((Object)this.newValue, (Object)this.delayed.getValue());
    }

    @Test
    public void testSetValue_CachesGetValueFromTarget() {
        Object overrideValue = this.target.overrideValue = new Object();
        Assert.assertEquals((Object)this.oldValue, (Object)this.delayed.getValue());
        Assert.assertEquals((Object)this.oldValue, (Object)this.target.getValue());
        this.delayed.setValue(this.newValue);
        Assert.assertEquals((Object)overrideValue, (Object)this.target.getValue());
        Assert.assertEquals((Object)overrideValue, (Object)this.delayed.getValue());
    }

    @Test
    public void testSetValue_FiresValueChangeEvent() {
        ValueChangeEventTracker targetTracker = ValueChangeEventTracker.observe((IObservableValue)this.target);
        ValueChangeEventTracker delayedTracker = ValueChangeEventTracker.observe((IObservableValue)this.delayed);
        this.delayed.setValue(this.newValue);
        Assert.assertEquals((long)1L, (long)targetTracker.count);
        Assert.assertEquals((Object)this.oldValue, (Object)targetTracker.event.diff.getOldValue());
        Assert.assertEquals((Object)this.newValue, (Object)targetTracker.event.diff.getNewValue());
        Assert.assertEquals((long)1L, (long)delayedTracker.count);
        Assert.assertEquals((Object)this.oldValue, (Object)delayedTracker.event.diff.getOldValue());
        Assert.assertEquals((Object)this.newValue, (Object)delayedTracker.event.diff.getNewValue());
    }

    @Test
    public void testWait_FiresPendingValueChange() {
        this.assertFiresPendingValueChange(new Runnable(){

            @Override
            public void run() {
                long timeout = this.time() + 5000L;
                do {
                    this.sleep(10);
                    this.processDisplayEvents();
                } while (DelayedObservableValueTest.this.delayed.isStale() && this.time() < timeout);
            }

            private void sleep(int delay) {
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }

            private void processDisplayEvents() {
                Display display = Display.getCurrent();
                while (display.readAndDispatch()) {
                }
            }

            private long time() {
                return System.currentTimeMillis();
            }
        });
    }

    private void assertFiresPendingValueChange(Runnable runnable) {
        ValueChangeEventTracker tracker = ValueChangeEventTracker.observe((IObservableValue)this.delayed);
        this.target.setValue(this.newValue);
        Assert.assertTrue((boolean)this.delayed.isStale());
        Assert.assertEquals((long)0L, (long)tracker.count);
        runnable.run();
        Assert.assertFalse((boolean)this.delayed.isStale());
        Assert.assertEquals((long)1L, (long)tracker.count);
        Assert.assertEquals((Object)this.oldValue, (Object)tracker.event.diff.getOldValue());
        Assert.assertEquals((Object)this.newValue, (Object)tracker.event.diff.getNewValue());
    }

    public static void addConformanceTest(TestSuite suite) {
        suite.addTest(MutableObservableValueContractTest.suite((IObservableValueContractDelegate)new Delegate()));
    }

    static class Delegate
    extends AbstractObservableValueContractDelegate {
        Delegate() {
        }

        public IObservableValue createObservableValue(Realm realm) {
            return Observables.observeDelayedValue((int)0, (IObservableValue)new ObservableValueStub(realm));
        }

        public Object getValueType(IObservableValue observable) {
            return Object.class;
        }

        public void change(IObservable observable) {
            IObservableValue observableValue = (IObservableValue)observable;
            observableValue.setValue(this.createValue(observableValue));
        }

        public Object createValue(IObservableValue observable) {
            return new Object();
        }
    }

    static class ObservableValueStub
    extends AbstractObservableValue {
        private Object value;
        private boolean stale;
        Object overrideValue;

        public ObservableValueStub(Realm realm) {
            super(realm);
        }

        protected Object doGetValue() {
            return this.value;
        }

        protected void doSetValue(Object value) {
            Object oldValue = this.value;
            if (this.overrideValue != null) {
                value = this.overrideValue;
            }
            this.value = value;
            this.stale = false;
            this.fireValueChange(Diffs.createValueDiff((Object)oldValue, (Object)value));
        }

        public Object getValueType() {
            return Object.class;
        }

        protected void fireStale() {
            this.stale = true;
            super.fireStale();
        }

        public boolean isStale() {
            return this.stale;
        }
    }
}

