/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.observable;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import junit.framework.TestSuite;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.ObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.core.internal.databinding.observable.UnmodifiableObservableSet;
import org.eclipse.jface.databinding.conformance.ObservableCollectionContractTest;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableCollectionContractDelegate;
import org.eclipse.jface.databinding.conformance.delegate.IObservableCollectionContractDelegate;
import org.eclipse.jface.databinding.conformance.util.ChangeEventTracker;
import org.eclipse.jface.databinding.conformance.util.SetChangeEventTracker;
import org.eclipse.jface.databinding.conformance.util.StaleEventTracker;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UnmodifiableObservableSetTest
extends AbstractDefaultRealmTestCase {
    UnmodifiableObservableSet unmodifiable;
    MutableObservableSet mutable;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        HashSet<String> set = new HashSet<String>();
        set.add("1");
        set.add("2");
        this.mutable = new MutableObservableSet(set, String.class);
        this.unmodifiable = (UnmodifiableObservableSet)Observables.unmodifiableObservableSet((IObservableSet)this.mutable);
    }

    @Test
    public void testFiresChangeEvents() throws Exception {
        ChangeEventTracker mutableListener = new ChangeEventTracker();
        ChangeEventTracker unmodifiableListener = new ChangeEventTracker();
        this.mutable.addChangeListener((IChangeListener)mutableListener);
        this.unmodifiable.addChangeListener((IChangeListener)unmodifiableListener);
        Assert.assertEquals((long)0L, (long)mutableListener.count);
        Assert.assertEquals((long)0L, (long)unmodifiableListener.count);
        this.mutable.add("3");
        Assert.assertEquals((long)1L, (long)mutableListener.count);
        Assert.assertEquals((long)1L, (long)unmodifiableListener.count);
    }

    @Test
    public void testFiresSetChangeEvents() throws Exception {
        SetChangeEventTracker mutableListener = new SetChangeEventTracker();
        SetChangeEventTracker unmodifiableListener = new SetChangeEventTracker();
        this.mutable.addSetChangeListener((ISetChangeListener)mutableListener);
        this.unmodifiable.addSetChangeListener((ISetChangeListener)unmodifiableListener);
        Assert.assertEquals((long)0L, (long)mutableListener.count);
        Assert.assertEquals((long)0L, (long)unmodifiableListener.count);
        String element = "3";
        this.mutable.add(element);
        Assert.assertEquals((long)1L, (long)mutableListener.count);
        Assert.assertEquals((Object)((Object)this.mutable), (Object)mutableListener.event.getObservableSet());
        Assert.assertEquals((long)1L, (long)mutableListener.event.diff.getAdditions().size());
        Object addition = mutableListener.event.diff.getAdditions().toArray()[0];
        Assert.assertEquals((Object)element, (Object)addition);
        Assert.assertEquals((long)3L, (long)this.mutable.size());
        Assert.assertEquals((long)1L, (long)unmodifiableListener.count);
        Assert.assertEquals((Object)this.unmodifiable, (Object)unmodifiableListener.event.getObservableSet());
        Assert.assertEquals((long)1L, (long)unmodifiableListener.event.diff.getAdditions().size());
        addition = unmodifiableListener.event.diff.getAdditions().toArray()[0];
        Assert.assertEquals((Object)element, (Object)addition);
        Assert.assertEquals((long)3L, (long)this.unmodifiable.size());
    }

    @Test
    public void testFiresStaleEvents() throws Exception {
        StaleEventTracker mutableListener = new StaleEventTracker();
        StaleEventTracker unmodifiableListener = new StaleEventTracker();
        this.mutable.addStaleListener((IStaleListener)mutableListener);
        this.unmodifiable.addStaleListener((IStaleListener)unmodifiableListener);
        Assert.assertEquals((long)0L, (long)mutableListener.count);
        Assert.assertEquals((long)0L, (long)unmodifiableListener.count);
        this.mutable.setStale(true);
        Assert.assertEquals((long)1L, (long)mutableListener.count);
        Assert.assertEquals((Object)((Object)this.mutable), (Object)mutableListener.event.getObservable());
        Assert.assertTrue((boolean)this.mutable.isStale());
        Assert.assertEquals((long)1L, (long)unmodifiableListener.count);
        Assert.assertEquals((Object)this.unmodifiable, (Object)unmodifiableListener.event.getObservable());
        Assert.assertTrue((boolean)this.unmodifiable.isStale());
    }

    @Test
    public void testIsStale() throws Exception {
        Assert.assertFalse((boolean)this.mutable.isStale());
        Assert.assertFalse((boolean)this.unmodifiable.isStale());
        this.mutable.setStale(true);
        Assert.assertTrue((boolean)this.mutable.isStale());
        Assert.assertTrue((boolean)this.unmodifiable.isStale());
    }

    public static void addConformanceTest(TestSuite suite) {
        suite.addTest(ObservableCollectionContractTest.suite((IObservableCollectionContractDelegate)new Delegate()));
    }

    private static class Delegate
    extends AbstractObservableCollectionContractDelegate {
        private Object elementType = new Object();

        private Delegate() {
        }

        public IObservableCollection createObservableCollection(Realm realm, int elementCount) {
            WritableSet backingList = new WritableSet(realm, new HashSet(), this.elementType);
            UnmodifiableObservableSetStub result = new UnmodifiableObservableSetStub((IObservableSet)backingList);
            int i = 0;
            while (i < elementCount) {
                backingList.add(this.createElement((IObservableCollection)result));
                ++i;
            }
            return result;
        }

        public Object createElement(IObservableCollection collection) {
            return new Object();
        }

        public Object getElementType(IObservableCollection collection) {
            return this.elementType;
        }

        public void change(IObservable observable) {
            UnmodifiableObservableSetStub unmodifiableList = (UnmodifiableObservableSetStub)observable;
            IObservableSet wrappedList = unmodifiableList.wrappedSet;
            wrappedList.add(this.createElement((IObservableCollection)unmodifiableList));
        }
    }

    private static class MutableObservableSet
    extends ObservableSet {
        public MutableObservableSet(Set wrappedSet, Object elementType) {
            super(wrappedSet, elementType);
        }

        public boolean add(Object o) {
            boolean result = this.wrappedSet.add(o);
            if (result) {
                this.fireSetChange(Diffs.createSetDiff(Collections.singleton(o), (Set)Collections.EMPTY_SET));
            }
            return result;
        }
    }

    private static class UnmodifiableObservableSetStub
    extends UnmodifiableObservableSet {
        IObservableSet wrappedSet;

        UnmodifiableObservableSetStub(IObservableSet wrappedSet) {
            super(wrappedSet);
            this.wrappedSet = wrappedSet;
        }
    }
}

