/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.observable;

import junit.framework.TestSuite;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.internal.databinding.validation.ValidatedObservableValue;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.conformance.MutableObservableValueContractTest;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.delegate.IObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.util.CurrentRealm;
import org.eclipse.jface.databinding.conformance.util.ValueChangeEventTracker;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ValidatedObservableValueTest
extends AbstractDefaultRealmTestCase {
    private ValidatedObservableValue validated;
    private ObservableValueStub target;
    private IObservableValue validationStatus;
    private Object oldValue;
    private Object newValue;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.oldValue = new Object();
        this.newValue = new Object();
        this.target = new ObservableValueStub(Realm.getDefault());
        this.target.setValue(this.oldValue);
        this.validationStatus = new WritableValue((Object)ValidationStatus.ok(), IStatus.class);
        this.validated = new ValidatedObservableValue((IObservableValue)this.target, this.validationStatus);
    }

    @Test
    public void testConstructor_RequireObservablesOnSameRealm() {
        CurrentRealm realm1 = new CurrentRealm(true);
        CurrentRealm realm2 = new CurrentRealm(true);
        this.target = new ObservableValueStub((Realm)realm1);
        this.validationStatus = new WritableValue((Realm)realm2);
        try {
            new ValidatedObservableValue((IObservableValue)this.target, this.validationStatus);
            Assert.fail((String)"Expected exception--target and validation status should have the same realm");
        }
        catch (RuntimeException runtimeException) {}
    }

    @Test
    public void testIsStale_WhenTargetIsStale() {
        Assert.assertFalse((boolean)this.target.isStale());
        Assert.assertFalse((boolean)this.validated.isStale());
        this.target.fireStale();
        Assert.assertTrue((boolean)this.target.isStale());
        Assert.assertTrue((boolean)this.validated.isStale());
    }

    @Test
    public void testIsStale_WhileChangesPending() {
        Assert.assertFalse((boolean)this.target.isStale());
        Assert.assertFalse((boolean)this.validated.isStale());
        this.validationStatus.setValue((Object)ValidationStatus.error((String)"error"));
        Assert.assertFalse((boolean)this.target.isStale());
        Assert.assertFalse((boolean)this.validated.isStale());
        this.target.setValue(this.newValue);
        Assert.assertFalse((boolean)this.target.isStale());
        Assert.assertTrue((boolean)this.validated.isStale());
        this.validationStatus.setValue((Object)ValidationStatus.ok());
        Assert.assertFalse((boolean)this.validated.isStale());
    }

    @Test
    public void testGetValueType_SameAsTarget() {
        Assert.assertEquals((Object)this.target.getValueType(), (Object)this.validated.getValueType());
    }

    @Test
    public void testGetValue_InitialValue() {
        Assert.assertEquals((Object)this.oldValue, (Object)this.target.getValue());
        Assert.assertEquals((Object)this.oldValue, (Object)this.validated.getValue());
    }

    @Test
    public void testGetValue_WhileChangesPending() {
        Assert.assertEquals((Object)this.oldValue, (Object)this.target.getValue());
        Assert.assertEquals((Object)this.oldValue, (Object)this.validated.getValue());
        this.validationStatus.setValue((Object)ValidationStatus.error((String)"error"));
        Assert.assertEquals((Object)this.oldValue, (Object)this.target.getValue());
        Assert.assertEquals((Object)this.oldValue, (Object)this.validated.getValue());
        this.target.setValue(this.newValue);
        Assert.assertEquals((Object)this.newValue, (Object)this.target.getValue());
        Assert.assertEquals((Object)this.oldValue, (Object)this.validated.getValue());
        this.validationStatus.setValue((Object)ValidationStatus.ok());
        Assert.assertEquals((Object)this.newValue, (Object)this.validated.getValue());
    }

    @Test
    public void testSetValue_PropagatesToTarget() {
        this.validated.setValue(this.newValue);
        Assert.assertEquals((Object)this.newValue, (Object)this.validated.getValue());
        Assert.assertEquals((Object)this.newValue, (Object)this.target.getValue());
    }

    @Test
    public void testSetValue_PropagatesToTargetWhileStatusNotOK() {
        this.validationStatus.setValue((Object)ValidationStatus.error((String)"error"));
        this.validated.setValue(this.newValue);
        Assert.assertEquals((Object)this.newValue, (Object)this.validated.getValue());
        Assert.assertEquals((Object)this.newValue, (Object)this.target.getValue());
        Assert.assertFalse((boolean)this.validated.isStale());
    }

    @Test
    public void testSetValue_CachesGetValueFromTarget() {
        Object overrideValue = this.target.overrideValue = new Object();
        Assert.assertEquals((Object)this.oldValue, (Object)this.validated.getValue());
        Assert.assertEquals((Object)this.oldValue, (Object)this.target.getValue());
        this.validationStatus.setValue((Object)ValidationStatus.error((String)"error"));
        this.validated.setValue(this.newValue);
        Assert.assertEquals((Object)overrideValue, (Object)this.target.getValue());
        Assert.assertEquals((Object)overrideValue, (Object)this.validated.getValue());
    }

    @Test
    public void testSetValue_SingleValueChangeEvent() {
        ValueChangeEventTracker tracker = ValueChangeEventTracker.observe((IObservableValue)this.validated);
        this.validated.setValue(this.newValue);
        Assert.assertEquals((long)1L, (long)tracker.count);
        Assert.assertEquals((Object)this.oldValue, (Object)tracker.event.diff.getOldValue());
        Assert.assertEquals((Object)this.newValue, (Object)tracker.event.diff.getNewValue());
    }

    @Test
    public void testSetValue_SingleValueChangeEventWhileInvalid() {
        ValueChangeEventTracker tracker = ValueChangeEventTracker.observe((IObservableValue)this.validated);
        this.validationStatus.setValue((Object)ValidationStatus.error((String)"error"));
        this.validated.setValue(this.newValue);
        Assert.assertEquals((long)1L, (long)tracker.count);
        Assert.assertEquals((Object)this.oldValue, (Object)tracker.event.diff.getOldValue());
        Assert.assertEquals((Object)this.newValue, (Object)tracker.event.diff.getNewValue());
    }

    @Test
    public void testSetValue_FiresSingleValueChangeEventWithTargetOverride() {
        Object overrideValue;
        ValueChangeEventTracker tracker = ValueChangeEventTracker.observe((IObservableValue)this.validated);
        this.target.overrideValue = overrideValue = new Object();
        this.validated.setValue(this.newValue);
        Assert.assertEquals((long)1L, (long)tracker.count);
        Assert.assertEquals((Object)this.oldValue, (Object)tracker.event.diff.getOldValue());
        Assert.assertEquals((Object)overrideValue, (Object)tracker.event.diff.getNewValue());
    }

    @Test
    public void testSetValue_FiresValueChangeEvent() {
        ValueChangeEventTracker targetTracker = ValueChangeEventTracker.observe((IObservableValue)this.target);
        ValueChangeEventTracker validatedTracker = ValueChangeEventTracker.observe((IObservableValue)this.validated);
        this.validated.setValue(this.newValue);
        Assert.assertEquals((long)1L, (long)targetTracker.count);
        Assert.assertEquals((Object)this.oldValue, (Object)targetTracker.event.diff.getOldValue());
        Assert.assertEquals((Object)this.newValue, (Object)targetTracker.event.diff.getNewValue());
        Assert.assertEquals((long)1L, (long)validatedTracker.count);
        Assert.assertEquals((Object)this.oldValue, (Object)validatedTracker.event.diff.getOldValue());
        Assert.assertEquals((Object)this.newValue, (Object)validatedTracker.event.diff.getNewValue());
    }

    @Test
    public void testIsStale_MatchTargetStaleness() {
        this.target.forceStale = true;
        this.target.fireStale();
        Assert.assertTrue((boolean)this.target.isStale());
        Assert.assertTrue((boolean)this.validated.isStale());
        this.target.setValue(this.newValue);
        Assert.assertTrue((boolean)this.target.isStale());
        Assert.assertTrue((boolean)this.validated.isStale());
    }

    public static void addConformanceTest(TestSuite suite) {
        suite.addTest(MutableObservableValueContractTest.suite((IObservableValueContractDelegate)new Delegate()));
    }

    static class Delegate
    extends AbstractObservableValueContractDelegate {
        private Object valueType = new Object();

        Delegate() {
        }

        public IObservableValue createObservableValue(Realm realm) {
            return new ValidatedObservableValueStub(realm, this.valueType);
        }

        public Object createValue(IObservableValue observable) {
            return new Object();
        }

        public Object getValueType(IObservableValue observable) {
            return this.valueType;
        }

        public void change(IObservable observable) {
            ValidatedObservableValueStub validated = (ValidatedObservableValueStub)observable;
            IObservableValue target = validated.target;
            target.setValue(this.createValue((IObservableValue)validated));
        }
    }

    static class ObservableValueStub
    extends AbstractObservableValue {
        private Object value;
        private boolean stale;
        private boolean forceStale;
        Object overrideValue;

        public ObservableValueStub(Realm realm) {
            super(realm);
        }

        protected Object doGetValue() {
            return this.value;
        }

        protected void doSetValue(Object value) {
            Object oldValue = this.value;
            if (this.overrideValue != null) {
                value = this.overrideValue;
            }
            this.value = value;
            this.stale = this.forceStale;
            this.fireValueChange(Diffs.createValueDiff((Object)oldValue, (Object)value));
        }

        public Object getValueType() {
            return Object.class;
        }

        protected void fireStale() {
            this.stale = true;
            super.fireStale();
        }

        public boolean isStale() {
            return this.stale;
        }
    }

    static class ValidatedObservableValueStub
    extends ValidatedObservableValue {
        final IObservableValue target;
        final IObservableValue validationStatus;

        ValidatedObservableValueStub(Realm realm, Object valueType) {
            this((IObservableValue)new WritableValue(realm, null, valueType), (IObservableValue)new WritableValue(realm, (Object)ValidationStatus.ok(), IStatus.class));
        }

        private ValidatedObservableValueStub(IObservableValue target, IObservableValue validationStatus) {
            super(target, validationStatus);
            this.target = target;
            this.validationStatus = validationStatus;
        }
    }
}

