/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.observable.masterdetail;

import java.util.ArrayList;
import java.util.Arrays;
import junit.framework.TestSuite;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.masterdetail.MasterDetailObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.internal.databinding.observable.masterdetail.DetailObservableList;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.jface.databinding.conformance.MutableObservableListContractTest;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableCollectionContractDelegate;
import org.eclipse.jface.databinding.conformance.delegate.IObservableCollectionContractDelegate;
import org.eclipse.jface.databinding.conformance.util.DisposeEventTracker;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.junit.Assert;
import org.junit.Test;

public class DetailObservableListTest
extends AbstractDefaultRealmTestCase {
    @Test
    public void testElementTypeNull() throws Exception {
        WritableValue observableValue = new WritableValue((Object)new WritableList(new ArrayList(), Object.class), null);
        WritableListFactory factory = new WritableListFactory();
        DetailObservableList detailObservable = new DetailObservableList((IObservableFactory)factory, (IObservableValue)observableValue, null);
        Assert.assertNull((Object)detailObservable.getElementType());
        factory.type = String.class;
        observableValue.setValue((Object)new WritableList(new ArrayList(), String.class));
        Assert.assertNull((String)"element type not null", (Object)detailObservable.getElementType());
    }

    @Test
    public void testElementTypeNotNull() throws Exception {
        WritableValue observableValue = new WritableValue((Object)new WritableList(new ArrayList(), Object.class), null);
        WritableListFactory factory = new WritableListFactory();
        DetailObservableList detailObservable = new DetailObservableList((IObservableFactory)factory, (IObservableValue)observableValue, Object.class);
        Assert.assertEquals((Object)factory.type, (Object)detailObservable.getElementType());
        try {
            factory.type = String.class;
            observableValue.setValue((Object)new WritableList(Arrays.asList(new Object()), String.class));
            Assert.fail((String)"if an element type is set this cannot be changed");
        }
        catch (AssertionFailedException assertionFailedException) {}
    }

    @Test
    public void testMasterNotDisposedWhenDetailDisposed() {
        class OuterObservable
        extends WritableValue {
            boolean disposed = false;

            OuterObservable() {
            }

            public synchronized void dispose() {
                this.disposed = true;
                super.dispose();
            }
        }
        OuterObservable outerObservable = new OuterObservable();
        WritableListFactory factory = new WritableListFactory();
        DetailObservableList detailObservable = new DetailObservableList((IObservableFactory)factory, (IObservableValue)outerObservable, null);
        Assert.assertFalse((boolean)outerObservable.disposed);
        detailObservable.dispose();
        Assert.assertFalse((boolean)outerObservable.disposed);
    }

    @Test
    public void testDisposeMasterDisposesDetail() {
        WritableValue master = new WritableValue();
        WritableListFactory factory = new WritableListFactory();
        master.setValue((Object)"");
        IObservableList detailObservable = MasterDetailObservables.detailList((IObservableValue)master, (IObservableFactory)factory, null);
        DisposeEventTracker tracker = DisposeEventTracker.observe((IObservable)detailObservable);
        master.dispose();
        Assert.assertEquals((long)1L, (long)tracker.count);
        Assert.assertTrue((boolean)detailObservable.isDisposed());
    }

    @Test
    public void testDisposeWhileFiringEvents() {
        WritableValue master = new WritableValue();
        WritableListFactory factory = new WritableListFactory();
        master.setValue((Object)"");
        IObservableList[] detailObservable = new IObservableList[1];
        master.addValueChangeListener(event -> detailObservable[0].dispose());
        detailObservable[0] = MasterDetailObservables.detailList((IObservableValue)master, (IObservableFactory)factory, null);
        master.setValue((Object)"New Value");
    }

    public static void addConformanceTest(TestSuite suite) {
        suite.addTest(MutableObservableListContractTest.suite((IObservableCollectionContractDelegate)new Delegate()));
    }

    static class Delegate
    extends AbstractObservableCollectionContractDelegate {
        Object elementType = Object.class;

        Delegate() {
        }

        public IObservableCollection createObservableCollection(Realm realm, int elementCount) {
            WritableValue master = new WritableValue(realm, (Object)elementCount, Integer.class);
            FactoryStub factory = new FactoryStub(realm, this.elementType);
            return new DetailObservableListStub(factory, (IObservableValue)master, this.elementType);
        }

        public Object createElement(IObservableCollection collection) {
            return new Object();
        }

        public Object getElementType(IObservableCollection collection) {
            return this.elementType;
        }

        public void change(IObservable observable) {
            IObservableValue master = ((DetailObservableListStub)observable).master;
            master.setValue((Object)((Integer)master.getValue() + 1));
        }
    }

    static class DetailObservableListStub
    extends DetailObservableList {
        IObservableValue master;

        DetailObservableListStub(IObservableFactory factory, IObservableValue master, Object elementType) {
            super(factory, master, elementType);
            this.master = master;
        }
    }

    static class FactoryStub
    implements IObservableFactory {
        private Realm realm;
        private Object elementType;
        Object type = Object.class;

        FactoryStub(Realm realm, Object elementType) {
            this.realm = realm;
            this.elementType = elementType;
        }

        public IObservable createObservable(Object target) {
            int elementCount = (Integer)target;
            ArrayList<Object> wrappedList = new ArrayList<Object>();
            int i = 0;
            while (i < elementCount) {
                wrappedList.add(new Object());
                ++i;
            }
            return new WritableList(this.realm, wrappedList, this.elementType);
        }
    }

    private static class WritableListFactory
    implements IObservableFactory {
        Object type = Object.class;

        private WritableListFactory() {
        }

        public IObservable createObservable(Object target) {
            return new WritableList(new ArrayList(), this.type);
        }
    }
}

