/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.observable.masterdetail;

import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.WritableMap;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.masterdetail.MasterDetailObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.internal.databinding.observable.masterdetail.DetailObservableMap;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.jface.databinding.conformance.util.DisposeEventTracker;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.junit.Assert;
import org.junit.Test;

public class DetailObservableMapTest
extends AbstractDefaultRealmTestCase {
    @Test
    public void testKeyValueTypeNull() throws Exception {
        WritableValue observableValue = new WritableValue();
        WritableMapFactory factory = new WritableMapFactory();
        DetailObservableMap detailObservable = new DetailObservableMap((IObservableFactory)factory, (IObservableValue)observableValue, null, null);
        Assert.assertNull((Object)detailObservable.getKeyType());
        Assert.assertNull((Object)detailObservable.getValueType());
        factory.keyType = Object.class;
        factory.valueType = Object.class;
        observableValue.setValue(new Object());
        Assert.assertNull((String)"key type not null", (Object)detailObservable.getKeyType());
        Assert.assertNull((String)"value type not null", (Object)detailObservable.getValueType());
        factory.keyType = String.class;
        factory.valueType = String.class;
        observableValue.setValue(new Object());
        Assert.assertNull((String)"key type not null", (Object)detailObservable.getKeyType());
        Assert.assertNull((String)"value type not null", (Object)detailObservable.getValueType());
    }

    @Test
    public void testKeyValueTypeNotNull() throws Exception {
        WritableValue observableValue = new WritableValue();
        WritableMapFactory factory = new WritableMapFactory();
        DetailObservableMap detailObservable = new DetailObservableMap((IObservableFactory)factory, (IObservableValue)observableValue, Object.class, Object.class);
        Assert.assertEquals(Object.class, (Object)detailObservable.getKeyType());
        Assert.assertEquals(Object.class, (Object)detailObservable.getValueType());
        try {
            factory.keyType = String.class;
            factory.valueType = String.class;
            observableValue.setValue(new Object());
            Assert.fail((String)"if an element type is set this cannot be changed");
        }
        catch (AssertionFailedException assertionFailedException) {}
    }

    @Test
    public void testMasterNotDisposedWhenDetailDisposed() {
        class OuterObservable
        extends WritableValue {
            boolean disposed = false;

            OuterObservable() {
            }

            public synchronized void dispose() {
                this.disposed = true;
                super.dispose();
            }
        }
        OuterObservable outerObservable = new OuterObservable();
        WritableMapFactory factory = new WritableMapFactory();
        DetailObservableMap detailObservable = new DetailObservableMap((IObservableFactory)factory, (IObservableValue)outerObservable, null, null);
        Assert.assertFalse((boolean)outerObservable.disposed);
        detailObservable.dispose();
        Assert.assertFalse((boolean)outerObservable.disposed);
    }

    @Test
    public void testDisposeMasterDisposesDetail() {
        WritableValue master = new WritableValue();
        WritableMapFactory factory = new WritableMapFactory();
        master.setValue((Object)"");
        IObservableMap detailObservable = MasterDetailObservables.detailMap((IObservableValue)master, (IObservableFactory)factory, null, null);
        DisposeEventTracker tracker = DisposeEventTracker.observe((IObservable)detailObservable);
        master.dispose();
        Assert.assertEquals((long)1L, (long)tracker.count);
        Assert.assertTrue((boolean)detailObservable.isDisposed());
    }

    @Test
    public void testDisposeWhileFiringEvents() {
        WritableValue master = new WritableValue();
        WritableMapFactory factory = new WritableMapFactory();
        master.setValue((Object)"");
        IObservableMap[] detailObservable = new IObservableMap[1];
        master.addValueChangeListener(event -> detailObservable[0].dispose());
        detailObservable[0] = MasterDetailObservables.detailMap((IObservableValue)master, (IObservableFactory)factory, null, null);
        master.setValue((Object)"New Value");
    }

    private static class WritableMapFactory
    implements IObservableFactory {
        Object keyType = Object.class;
        Object valueType = Object.class;

        private WritableMapFactory() {
        }

        public IObservable createObservable(Object target) {
            return new WritableMap(this.keyType, this.valueType);
        }
    }
}

