/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.observable.masterdetail;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import junit.framework.TestSuite;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.internal.databinding.observable.masterdetail.ListDetailValueObservableList;
import org.eclipse.jface.databinding.conformance.ObservableListContractTest;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableCollectionContractDelegate;
import org.eclipse.jface.databinding.conformance.delegate.IObservableCollectionContractDelegate;
import org.eclipse.jface.databinding.conformance.util.ListChangeEventTracker;
import org.eclipse.jface.examples.databinding.model.SimplePerson;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.junit.Assert;
import org.junit.Test;

public class ListDetailValueObservableListTest
extends AbstractDefaultRealmTestCase {
    public static void addConformanceTest(TestSuite suite) {
        suite.addTest(ObservableListContractTest.suite((IObservableCollectionContractDelegate)new Delegate()));
    }

    @Test
    public void testUnmodifiability() {
        WritableList masterObservableList = new WritableList();
        masterObservableList.add((Object)new SimplePerson());
        masterObservableList.add((Object)new SimplePerson());
        ListDetailValueObservableList ldol = new ListDetailValueObservableList((IObservableList)masterObservableList, BeansObservables.valueFactory((String)"name"), null);
        try {
            ldol.add((Object)"name");
            Assert.fail((String)"ListDetailValueObservableList must not be modifiable.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
        try {
            ldol.remove(masterObservableList.get(0));
            Assert.fail((String)"ListDetailValueObservableList must not be modifiable.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
        try {
            ldol.removeAll(Collections.singleton(masterObservableList.get(0)));
            Assert.fail((String)"ListDetailValueObservableList must not be modifiable.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
        try {
            ldol.retainAll((Collection)Collections.EMPTY_LIST);
            Assert.fail((String)"ListDetailValueObservableList must not be modifiable.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
        try {
            ldol.move(0, 1);
            Assert.fail((String)"ListDetailValueObservableList must not be modifiable.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
    }

    @Test
    public void testGetElementType() {
        ListDetailValueObservableList ldol = new ListDetailValueObservableList((IObservableList)new WritableList(), BeansObservables.valueFactory((String)"name"), String.class);
        Assert.assertSame(String.class, (Object)ldol.getElementType());
    }

    @Test
    public void testGetObserved() {
        WritableList masterList = new WritableList();
        ListDetailValueObservableList ldol = new ListDetailValueObservableList((IObservableList)masterList, BeansObservables.valueFactory((String)"name"), String.class);
        Assert.assertSame((Object)masterList, (Object)ldol.getObserved());
    }

    @Test
    public void testMasterListInitiallyNotEmpty() {
        WritableList masterList = new WritableList();
        SimplePerson person = new SimplePerson();
        person.setName("name");
        masterList.add((Object)person);
        ListDetailValueObservableList ldol = new ListDetailValueObservableList((IObservableList)masterList, BeansObservables.valueFactory((String)"name"), String.class);
        Assert.assertEquals((long)masterList.size(), (long)ldol.size());
        Assert.assertEquals((Object)person.getName(), (Object)ldol.get(0));
    }

    @Test
    public void testAddRemove() {
        WritableList masterList = new WritableList();
        ListDetailValueObservableList ldol = new ListDetailValueObservableList((IObservableList)masterList, BeansObservables.valueFactory((String)"name"), String.class);
        Assert.assertTrue((boolean)ldol.isEmpty());
        SimplePerson p1 = new SimplePerson();
        p1.setName("name1");
        masterList.add((Object)p1);
        Assert.assertEquals((long)masterList.size(), (long)ldol.size());
        Assert.assertEquals((Object)p1.getName(), (Object)ldol.get(0));
        SimplePerson p2 = new SimplePerson();
        p2.setName("name2");
        masterList.add((Object)p2);
        Assert.assertEquals((long)masterList.size(), (long)ldol.size());
        Assert.assertEquals((Object)p2.getName(), (Object)ldol.get(1));
        masterList.remove(0);
        Assert.assertEquals((long)masterList.size(), (long)ldol.size());
        Assert.assertEquals((Object)p2.getName(), (Object)ldol.get(0));
        masterList.remove(0);
        Assert.assertTrue((boolean)ldol.isEmpty());
    }

    @Test
    public void testChangeDetail() {
        WritableList masterList = new WritableList();
        ListDetailValueObservableList ldol = new ListDetailValueObservableList((IObservableList)masterList, BeansObservables.valueFactory((String)"name"), String.class);
        SimplePerson p1 = new SimplePerson();
        p1.setName("name1");
        masterList.add((Object)p1);
        Assert.assertEquals((Object)p1.getName(), (Object)ldol.get(0));
        p1.setName("name2");
        Assert.assertEquals((Object)p1.getName(), (Object)ldol.get(0));
        SimplePerson p2 = new SimplePerson();
        p2.setName("name3");
        masterList.set(0, (Object)p2);
        Assert.assertEquals((Object)p2.getName(), (Object)ldol.get(0));
    }

    @Test
    public void testSet() {
        WritableList masterList = new WritableList();
        ListDetailValueObservableList ldol = new ListDetailValueObservableList((IObservableList)masterList, BeansObservables.valueFactory((String)"name"), String.class);
        SimplePerson person = new SimplePerson();
        person.setName("name1");
        masterList.add((Object)person);
        Assert.assertEquals((Object)person.getName(), (Object)ldol.get(0));
        ldol.set(0, (Object)"name2");
        Assert.assertEquals((Object)"name2", (Object)person.getName());
        Assert.assertEquals((Object)person.getName(), (Object)ldol.get(0));
    }

    @Test
    public void testDuplicateMasterElements() {
        WritableList masterList = new WritableList();
        ListDetailValueObservableList ldol = new ListDetailValueObservableList((IObservableList)masterList, BeansObservables.valueFactory((String)"name"), String.class);
        SimplePerson master = new SimplePerson();
        master.setName("name1");
        masterList.add((Object)master);
        masterList.add((Object)master);
        ListChangeEventTracker changeTracker = ListChangeEventTracker.observe((IObservableList)ldol);
        master.setName("name2");
        Assert.assertEquals((long)1L, (long)changeTracker.count);
        Assert.assertEquals((long)4L, (long)changeTracker.event.diff.getDifferences().length);
        this.assertReplaceDiffAt(changeTracker.event.diff, 0, 0, "name1", "name2");
        this.assertReplaceDiffAt(changeTracker.event.diff, 2, 0, "name1", "name2");
        masterList.remove((Object)master);
        ldol.set(0, (Object)"name3");
        Assert.assertEquals((Object)"name3", (Object)master.getName());
    }

    @Test
    public void testDetailObservableChangeEvent() {
        WritableList masterList = new WritableList();
        ListDetailValueObservableList ldol = new ListDetailValueObservableList((IObservableList)masterList, BeansObservables.valueFactory((String)"name"), String.class);
        ListChangeEventTracker changeTracker = ListChangeEventTracker.observe((IObservableList)ldol);
        SimplePerson person = new SimplePerson();
        person.setName("old name");
        Assert.assertEquals((long)0L, (long)changeTracker.count);
        masterList.add((Object)person);
        Assert.assertEquals((long)1L, (long)changeTracker.count);
        Assert.assertEquals((long)1L, (long)changeTracker.event.diff.getDifferences().length);
        Assert.assertTrue((boolean)changeTracker.event.diff.getDifferences()[0].isAddition());
        Assert.assertEquals((long)0L, (long)changeTracker.event.diff.getDifferences()[0].getPosition());
        Assert.assertEquals((Object)person.getName(), (Object)changeTracker.event.diff.getDifferences()[0].getElement());
        person.setName("new name");
        Assert.assertEquals((long)2L, (long)changeTracker.count);
        this.assertIsSingleReplaceDiff(changeTracker.event.diff, 0, "old name", "new name");
    }

    private void assertIsSingleReplaceDiff(ListDiff diff, int index, Object oldElement, Object newElement) {
        Assert.assertEquals((long)2L, (long)diff.getDifferences().length);
        this.assertReplaceDiffAt(diff, 0, index, oldElement, newElement);
    }

    private void assertReplaceDiffAt(ListDiff diff, int diffOffset, int index, Object oldElement, Object newElement) {
        ListDiffEntry entry1 = diff.getDifferences()[0];
        ListDiffEntry entry2 = diff.getDifferences()[1];
        Assert.assertTrue((boolean)(entry1.isAddition() ^ entry2.isAddition()));
        Assert.assertEquals((long)index, (long)entry1.getPosition());
        Assert.assertEquals((long)index, (long)entry2.getPosition());
        if (entry1.isAddition()) {
            Assert.assertEquals((Object)oldElement, (Object)entry2.getElement());
            Assert.assertEquals((Object)newElement, (Object)entry1.getElement());
        } else {
            Assert.assertEquals((Object)oldElement, (Object)entry1.getElement());
            Assert.assertEquals((Object)newElement, (Object)entry2.getElement());
        }
    }

    @Test
    public void testMasterNull() {
        WritableList masterObservableList = new WritableList();
        ListDetailValueObservableList ldol = new ListDetailValueObservableList((IObservableList)masterObservableList, BeansObservables.valueFactory((String)"name"), String.class);
        masterObservableList.add(null);
        Assert.assertEquals((long)1L, (long)ldol.size());
        Assert.assertNull((Object)ldol.get(0));
    }

    @Test
    public void testDetailObservableValuesAreDisposed() {
        ArrayList detailObservables = new ArrayList();
        IObservableFactory detailValueFactory = target -> {
            WritableValue detailObservable = new WritableValue();
            detailObservables.add(detailObservable);
            return detailObservable;
        };
        WritableList masterList = new WritableList();
        ListDetailValueObservableList ldol = new ListDetailValueObservableList((IObservableList)masterList, detailValueFactory, null);
        masterList.add(new Object());
        masterList.add(new Object());
        Assert.assertEquals((long)ldol.size(), (long)detailObservables.size());
        Assert.assertFalse((boolean)((WritableValue)detailObservables.get(0)).isDisposed());
        Assert.assertFalse((boolean)((WritableValue)detailObservables.get(1)).isDisposed());
        masterList.remove(1);
        Assert.assertFalse((boolean)((WritableValue)detailObservables.get(0)).isDisposed());
        Assert.assertTrue((boolean)((WritableValue)detailObservables.get(1)).isDisposed());
        ldol.dispose();
        Assert.assertTrue((boolean)((WritableValue)detailObservables.get(0)).isDisposed());
        Assert.assertTrue((boolean)((WritableValue)detailObservables.get(1)).isDisposed());
    }

    @Test
    public void testDisposeOnMasterDisposed() {
        WritableList masterList = new WritableList();
        ListDetailValueObservableList ldol = new ListDetailValueObservableList((IObservableList)masterList, BeansObservables.valueFactory((String)"name"), String.class);
        Assert.assertFalse((boolean)masterList.isDisposed());
        Assert.assertFalse((boolean)ldol.isDisposed());
        masterList.dispose();
        Assert.assertTrue((boolean)masterList.isDisposed());
        Assert.assertTrue((boolean)ldol.isDisposed());
    }

    private static class Delegate
    extends AbstractObservableCollectionContractDelegate {
        private Delegate() {
        }

        public IObservableCollection createObservableCollection(Realm realm, int elementCount) {
            WritableList masterList = new WritableList(realm);
            int i = 0;
            while (i < elementCount) {
                masterList.add((Object)new SimplePerson());
                ++i;
            }
            return new TestListDetailValueObservableList((IObservableList)masterList, BeansObservables.valueFactory((Realm)realm, (String)"name"), String.class);
        }

        public void change(IObservable observable) {
            TestListDetailValueObservableList ldol = (TestListDetailValueObservableList)observable;
            ldol.masterList.add((Object)new SimplePerson());
        }

        public Object getElementType(IObservableCollection collection) {
            return String.class;
        }
    }

    private static class TestListDetailValueObservableList
    extends ListDetailValueObservableList {
        final IObservableList masterList;

        public TestListDetailValueObservableList(IObservableList masterList, IObservableFactory detailValueFactory, Object detailType) {
            super(masterList, detailValueFactory, detailType);
            this.masterList = masterList;
        }
    }
}

