/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.observable.masterdetail;

import java.util.HashMap;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.WritableMap;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.internal.databinding.observable.masterdetail.MapDetailValueObservableMap;
import org.eclipse.jface.databinding.conformance.util.MapChangeEventTracker;
import org.eclipse.jface.examples.databinding.model.SimplePerson;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.junit.Assert;
import org.junit.Test;

public class MapDetailValueObservableMapTest
extends AbstractDefaultRealmTestCase {
    @Test
    public void testGetKeyType() {
        MapDetailValueObservableMap mdom = new MapDetailValueObservableMap((IObservableMap)new WritableMap(SimplePerson.class, SimplePerson.class), BeansObservables.valueFactory((String)"name"), String.class);
        Assert.assertSame(SimplePerson.class, (Object)mdom.getKeyType());
    }

    @Test
    public void testGetValueType() {
        MapDetailValueObservableMap mdom = new MapDetailValueObservableMap((IObservableMap)new WritableMap(), BeansObservables.valueFactory((String)"name"), String.class);
        Assert.assertSame(String.class, (Object)mdom.getValueType());
    }

    @Test
    public void testGetObserved() {
        WritableMap masterMap = new WritableMap();
        MapDetailValueObservableMap mdom = new MapDetailValueObservableMap((IObservableMap)masterMap, BeansObservables.valueFactory((String)"name"), String.class);
        Assert.assertSame((Object)masterMap, (Object)mdom.getObserved());
    }

    @Test
    public void testMasterSetInitiallyNotEmpty() {
        WritableMap masterMap = new WritableMap();
        SimplePerson person = new SimplePerson();
        person.setName("name");
        masterMap.put((Object)person, (Object)person);
        MapDetailValueObservableMap mdom = new MapDetailValueObservableMap((IObservableMap)masterMap, BeansObservables.valueFactory((String)"name"), String.class);
        Assert.assertEquals((long)masterMap.size(), (long)mdom.size());
        Assert.assertEquals((Object)person.getName(), (Object)mdom.get((Object)person));
    }

    @Test
    public void testAddRemove() {
        WritableMap masterMap = new WritableMap();
        MapDetailValueObservableMap mdom = new MapDetailValueObservableMap((IObservableMap)masterMap, BeansObservables.valueFactory((String)"name"), String.class);
        Assert.assertTrue((boolean)mdom.isEmpty());
        SimplePerson p1 = new SimplePerson();
        p1.setName("name1");
        masterMap.put((Object)p1, (Object)p1);
        Assert.assertEquals((long)masterMap.size(), (long)mdom.size());
        Assert.assertEquals((Object)p1.getName(), (Object)mdom.get((Object)p1));
        SimplePerson p2 = new SimplePerson();
        p2.setName("name2");
        masterMap.put((Object)p2, (Object)p2);
        Assert.assertEquals((long)masterMap.size(), (long)mdom.size());
        Assert.assertEquals((Object)p2.getName(), (Object)mdom.get((Object)p2));
        masterMap.remove((Object)p1);
        Assert.assertEquals((long)masterMap.size(), (long)mdom.size());
        Assert.assertEquals((Object)p2.getName(), (Object)mdom.get((Object)p2));
        masterMap.remove((Object)p2);
        Assert.assertTrue((boolean)mdom.isEmpty());
    }

    @Test
    public void testChangeDetail() {
        WritableMap masterMap = new WritableMap();
        MapDetailValueObservableMap mdom = new MapDetailValueObservableMap((IObservableMap)masterMap, BeansObservables.valueFactory((String)"name"), String.class);
        SimplePerson p1 = new SimplePerson();
        p1.setName("name1");
        masterMap.put((Object)p1, (Object)p1);
        Assert.assertEquals((Object)p1.getName(), (Object)mdom.get((Object)p1));
        p1.setName("name2");
        Assert.assertEquals((Object)p1.getName(), (Object)mdom.get((Object)p1));
        SimplePerson p2 = new SimplePerson();
        p2.setName("name3");
        masterMap.put((Object)p1, (Object)p2);
        Assert.assertEquals((Object)p2.getName(), (Object)mdom.get((Object)p1));
    }

    @Test
    public void testPut() {
        WritableMap masterMap = new WritableMap();
        MapDetailValueObservableMap mdom = new MapDetailValueObservableMap((IObservableMap)masterMap, BeansObservables.valueFactory((String)"name"), String.class);
        SimplePerson person = new SimplePerson();
        person.setName("name1");
        masterMap.put((Object)person, (Object)person);
        Assert.assertEquals((Object)person.getName(), (Object)mdom.get((Object)person));
        mdom.put((Object)person, (Object)"name2");
        Assert.assertEquals((Object)"name2", (Object)person.getName());
        Assert.assertEquals((Object)person.getName(), (Object)mdom.get((Object)person));
    }

    @Test
    public void testContainsValue() {
        WritableMap masterMap = new WritableMap();
        MapDetailValueObservableMap mdom = new MapDetailValueObservableMap((IObservableMap)masterMap, BeansObservables.valueFactory((String)"name"), String.class);
        SimplePerson person = new SimplePerson();
        person.setName("name");
        masterMap.put((Object)person, (Object)person);
        Assert.assertTrue((boolean)mdom.containsValue((Object)person.getName()));
        masterMap.remove((Object)person);
        Assert.assertFalse((boolean)mdom.containsValue((Object)person.getName()));
    }

    @Test
    public void testRemove() {
        WritableMap masterMap = new WritableMap();
        MapDetailValueObservableMap mdom = new MapDetailValueObservableMap((IObservableMap)masterMap, BeansObservables.valueFactory((String)"name"), String.class);
        SimplePerson p1 = new SimplePerson();
        SimplePerson p2 = new SimplePerson();
        masterMap.put((Object)p1, (Object)p1);
        masterMap.put((Object)p2, (Object)p2);
        Assert.assertTrue((boolean)mdom.containsKey((Object)p1));
        Assert.assertTrue((boolean)mdom.containsKey((Object)p2));
        mdom.remove((Object)p1);
        Assert.assertFalse((boolean)mdom.containsKey((Object)p1));
        Assert.assertTrue((boolean)mdom.containsKey((Object)p2));
        mdom.remove((Object)p1);
        Assert.assertFalse((boolean)mdom.containsKey((Object)p1));
        Assert.assertTrue((boolean)mdom.containsKey((Object)p2));
    }

    @Test
    public void testDetailObservableChangeEvent() {
        WritableMap masterMap = new WritableMap();
        MapDetailValueObservableMap mdom = new MapDetailValueObservableMap((IObservableMap)masterMap, BeansObservables.valueFactory((String)"name"), String.class);
        MapChangeEventTracker changeTracker = MapChangeEventTracker.observe((IObservableMap)mdom);
        SimplePerson person = new SimplePerson();
        person.setName("old name");
        Assert.assertEquals((long)0L, (long)changeTracker.count);
        masterMap.put((Object)person, (Object)person);
        Assert.assertEquals((long)1L, (long)changeTracker.count);
        Assert.assertEquals((long)1L, (long)changeTracker.event.diff.getAddedKeys().size());
        Assert.assertEquals((long)0L, (long)changeTracker.event.diff.getRemovedKeys().size());
        Assert.assertEquals((long)0L, (long)changeTracker.event.diff.getChangedKeys().size());
        Assert.assertSame((Object)person, changeTracker.event.diff.getAddedKeys().iterator().next());
        Assert.assertNull((Object)changeTracker.event.diff.getOldValue((Object)person));
        Assert.assertEquals((Object)"old name", (Object)changeTracker.event.diff.getNewValue((Object)person));
        person.setName("new name");
        Assert.assertEquals((long)2L, (long)changeTracker.count);
        Assert.assertEquals((long)0L, (long)changeTracker.event.diff.getAddedKeys().size());
        Assert.assertEquals((long)0L, (long)changeTracker.event.diff.getRemovedKeys().size());
        Assert.assertEquals((long)1L, (long)changeTracker.event.diff.getChangedKeys().size());
        Assert.assertSame((Object)person, changeTracker.event.diff.getChangedKeys().iterator().next());
        Assert.assertEquals((Object)"old name", (Object)changeTracker.event.diff.getOldValue((Object)person));
        Assert.assertEquals((Object)"new name", (Object)changeTracker.event.diff.getNewValue((Object)person));
    }

    @Test
    public void testMasterNull() {
        WritableMap masterMap = new WritableMap();
        MapDetailValueObservableMap mdom = new MapDetailValueObservableMap((IObservableMap)masterMap, BeansObservables.valueFactory((String)"name"), String.class);
        masterMap.put(null, null);
        Assert.assertEquals((long)1L, (long)mdom.size());
        Assert.assertNull((Object)mdom.get(null));
    }

    @Test
    public void testDetailObservableValuesAreDisposed() {
        HashMap detailObservables = new HashMap();
        IObservableFactory detailValueFactory = target -> {
            WritableValue detailObservable = new WritableValue();
            detailObservables.put(target, detailObservable);
            return detailObservable;
        };
        WritableMap masterMap = new WritableMap();
        MapDetailValueObservableMap mdom = new MapDetailValueObservableMap((IObservableMap)masterMap, detailValueFactory, null);
        Object master1 = new Object();
        Object master2 = new Object();
        masterMap.put(master1, master1);
        masterMap.put(master2, master2);
        MapChangeEventTracker.observe((IObservableMap)mdom);
        Assert.assertEquals((long)mdom.size(), (long)detailObservables.size());
        Assert.assertFalse((boolean)((WritableValue)detailObservables.get(master1)).isDisposed());
        Assert.assertFalse((boolean)((WritableValue)detailObservables.get(master2)).isDisposed());
        masterMap.remove(master2);
        Assert.assertFalse((boolean)((WritableValue)detailObservables.get(master1)).isDisposed());
        Assert.assertTrue((boolean)((WritableValue)detailObservables.get(master2)).isDisposed());
        mdom.dispose();
        Assert.assertTrue((boolean)((WritableValue)detailObservables.get(master1)).isDisposed());
        Assert.assertTrue((boolean)((WritableValue)detailObservables.get(master2)).isDisposed());
    }

    @Test
    public void testDisposeOnMasterDisposed() {
        WritableMap masterMap = new WritableMap();
        MapDetailValueObservableMap mdom = new MapDetailValueObservableMap((IObservableMap)masterMap, BeansObservables.valueFactory((String)"name"), String.class);
        Assert.assertFalse((boolean)masterMap.isDisposed());
        Assert.assertFalse((boolean)mdom.isDisposed());
        masterMap.dispose();
        Assert.assertTrue((boolean)masterMap.isDisposed());
        Assert.assertTrue((boolean)mdom.isDisposed());
    }
}

