/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.observable.masterdetail;

import java.util.HashMap;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.internal.databinding.observable.masterdetail.SetDetailValueObservableMap;
import org.eclipse.jface.databinding.conformance.util.MapChangeEventTracker;
import org.eclipse.jface.examples.databinding.model.SimplePerson;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.junit.Assert;
import org.junit.Test;

public class SetDetailValueObservableMapTest
extends AbstractDefaultRealmTestCase {
    @Test
    public void testGetValueType() {
        SetDetailValueObservableMap sdom = new SetDetailValueObservableMap((IObservableSet)new WritableSet(), BeansObservables.valueFactory((String)"name"), String.class);
        Assert.assertSame(String.class, (Object)sdom.getValueType());
    }

    @Test
    public void testGetObserved() {
        WritableSet masterKeySet = new WritableSet();
        SetDetailValueObservableMap sdom = new SetDetailValueObservableMap((IObservableSet)masterKeySet, BeansObservables.valueFactory((String)"name"), String.class);
        Assert.assertSame((Object)masterKeySet, (Object)sdom.getObserved());
    }

    @Test
    public void testMasterSetInitiallyNotEmpty() {
        WritableSet masterKeySet = new WritableSet();
        SimplePerson person = new SimplePerson();
        person.setName("name");
        masterKeySet.add((Object)person);
        SetDetailValueObservableMap sdom = new SetDetailValueObservableMap((IObservableSet)masterKeySet, BeansObservables.valueFactory((String)"name"), String.class);
        Assert.assertEquals((long)masterKeySet.size(), (long)sdom.size());
        Assert.assertEquals((Object)person.getName(), (Object)sdom.get((Object)person));
    }

    @Test
    public void testAddRemove() {
        WritableSet masterKeySet = new WritableSet();
        SetDetailValueObservableMap sdom = new SetDetailValueObservableMap((IObservableSet)masterKeySet, BeansObservables.valueFactory((String)"name"), String.class);
        Assert.assertTrue((boolean)sdom.isEmpty());
        SimplePerson p1 = new SimplePerson();
        p1.setName("name1");
        masterKeySet.add((Object)p1);
        Assert.assertEquals((long)masterKeySet.size(), (long)sdom.size());
        Assert.assertEquals((Object)p1.getName(), (Object)sdom.get((Object)p1));
        SimplePerson p2 = new SimplePerson();
        p2.setName("name2");
        masterKeySet.add((Object)p2);
        Assert.assertEquals((long)masterKeySet.size(), (long)sdom.size());
        Assert.assertEquals((Object)p2.getName(), (Object)sdom.get((Object)p2));
        masterKeySet.remove((Object)p1);
        Assert.assertEquals((long)masterKeySet.size(), (long)sdom.size());
        Assert.assertEquals((Object)p2.getName(), (Object)sdom.get((Object)p2));
        masterKeySet.remove((Object)p2);
        Assert.assertTrue((boolean)sdom.isEmpty());
    }

    @Test
    public void testChangeDetail() {
        WritableSet masterKeySet = new WritableSet();
        SetDetailValueObservableMap sdom = new SetDetailValueObservableMap((IObservableSet)masterKeySet, BeansObservables.valueFactory((String)"name"), String.class);
        SimplePerson p1 = new SimplePerson();
        p1.setName("name1");
        masterKeySet.add((Object)p1);
        Assert.assertEquals((Object)p1.getName(), (Object)sdom.get((Object)p1));
        p1.setName("name2");
        Assert.assertEquals((Object)p1.getName(), (Object)sdom.get((Object)p1));
        SimplePerson p2 = new SimplePerson();
        p2.setName("name3");
        masterKeySet.add((Object)p2);
        Assert.assertEquals((Object)p2.getName(), (Object)sdom.get((Object)p2));
    }

    @Test
    public void testPut() {
        WritableSet masterKeySet = new WritableSet();
        SetDetailValueObservableMap sdom = new SetDetailValueObservableMap((IObservableSet)masterKeySet, BeansObservables.valueFactory((String)"name"), String.class);
        SimplePerson person = new SimplePerson();
        person.setName("name1");
        masterKeySet.add((Object)person);
        Assert.assertEquals((Object)person.getName(), (Object)sdom.get((Object)person));
        sdom.put((Object)person, (Object)"name2");
        Assert.assertEquals((Object)"name2", (Object)person.getName());
        Assert.assertEquals((Object)person.getName(), (Object)sdom.get((Object)person));
    }

    @Test
    public void testContainsValue() {
        WritableSet masterKeySet = new WritableSet();
        SetDetailValueObservableMap sdom = new SetDetailValueObservableMap((IObservableSet)masterKeySet, BeansObservables.valueFactory((String)"name"), String.class);
        SimplePerson person = new SimplePerson();
        person.setName("name");
        masterKeySet.add((Object)person);
        Assert.assertTrue((boolean)sdom.containsValue((Object)person.getName()));
        masterKeySet.remove((Object)person);
        Assert.assertFalse((boolean)sdom.containsValue((Object)person.getName()));
    }

    @Test
    public void testRemove() {
        WritableSet masterKeySet = new WritableSet();
        SetDetailValueObservableMap sdom = new SetDetailValueObservableMap((IObservableSet)masterKeySet, BeansObservables.valueFactory((String)"name"), String.class);
        SimplePerson p1 = new SimplePerson();
        SimplePerson p2 = new SimplePerson();
        masterKeySet.add((Object)p1);
        masterKeySet.add((Object)p2);
        Assert.assertTrue((boolean)sdom.containsKey((Object)p1));
        Assert.assertTrue((boolean)sdom.containsKey((Object)p2));
        sdom.remove((Object)p1);
        Assert.assertFalse((boolean)sdom.containsKey((Object)p1));
        Assert.assertTrue((boolean)sdom.containsKey((Object)p2));
        sdom.remove((Object)p1);
        Assert.assertFalse((boolean)sdom.containsKey((Object)p1));
        Assert.assertTrue((boolean)sdom.containsKey((Object)p2));
    }

    @Test
    public void testDetailObservableChangeEvent() {
        WritableSet masterKeySet = new WritableSet();
        SetDetailValueObservableMap sdom = new SetDetailValueObservableMap((IObservableSet)masterKeySet, BeansObservables.valueFactory((String)"name"), String.class);
        MapChangeEventTracker changeTracker = MapChangeEventTracker.observe((IObservableMap)sdom);
        SimplePerson person = new SimplePerson();
        person.setName("old name");
        Assert.assertEquals((long)0L, (long)changeTracker.count);
        masterKeySet.add((Object)person);
        Assert.assertEquals((long)1L, (long)changeTracker.count);
        Assert.assertEquals((long)1L, (long)changeTracker.event.diff.getAddedKeys().size());
        Assert.assertEquals((long)0L, (long)changeTracker.event.diff.getRemovedKeys().size());
        Assert.assertEquals((long)0L, (long)changeTracker.event.diff.getChangedKeys().size());
        Assert.assertSame((Object)person, changeTracker.event.diff.getAddedKeys().iterator().next());
        Assert.assertNull((Object)changeTracker.event.diff.getOldValue((Object)person));
        Assert.assertEquals((Object)"old name", (Object)changeTracker.event.diff.getNewValue((Object)person));
        person.setName("new name");
        Assert.assertEquals((long)2L, (long)changeTracker.count);
        Assert.assertEquals((long)0L, (long)changeTracker.event.diff.getAddedKeys().size());
        Assert.assertEquals((long)0L, (long)changeTracker.event.diff.getRemovedKeys().size());
        Assert.assertEquals((long)1L, (long)changeTracker.event.diff.getChangedKeys().size());
        Assert.assertSame((Object)person, changeTracker.event.diff.getChangedKeys().iterator().next());
        Assert.assertEquals((Object)"old name", (Object)changeTracker.event.diff.getOldValue((Object)person));
        Assert.assertEquals((Object)"new name", (Object)changeTracker.event.diff.getNewValue((Object)person));
    }

    @Test
    public void testMasterNull() {
        WritableSet masterKeySet = new WritableSet();
        SetDetailValueObservableMap sdom = new SetDetailValueObservableMap((IObservableSet)masterKeySet, BeansObservables.valueFactory((String)"name"), String.class);
        masterKeySet.add(null);
        Assert.assertEquals((long)1L, (long)sdom.size());
        Assert.assertNull((Object)sdom.get(null));
    }

    @Test
    public void testDetailObservableValuesAreDisposed() {
        HashMap detailObservables = new HashMap();
        IObservableFactory detailValueFactory = target -> {
            WritableValue detailObservable = new WritableValue();
            detailObservables.put(target, detailObservable);
            return detailObservable;
        };
        WritableSet masterKeySet = new WritableSet();
        SetDetailValueObservableMap sdom = new SetDetailValueObservableMap((IObservableSet)masterKeySet, detailValueFactory, null);
        Object master1 = new Object();
        Object master2 = new Object();
        masterKeySet.add(master1);
        masterKeySet.add(master2);
        MapChangeEventTracker.observe((IObservableMap)sdom);
        Assert.assertEquals((long)sdom.size(), (long)detailObservables.size());
        Assert.assertFalse((boolean)((WritableValue)detailObservables.get(master1)).isDisposed());
        Assert.assertFalse((boolean)((WritableValue)detailObservables.get(master2)).isDisposed());
        masterKeySet.remove(master2);
        Assert.assertFalse((boolean)((WritableValue)detailObservables.get(master1)).isDisposed());
        Assert.assertTrue((boolean)((WritableValue)detailObservables.get(master2)).isDisposed());
        sdom.dispose();
        Assert.assertTrue((boolean)((WritableValue)detailObservables.get(master1)).isDisposed());
        Assert.assertTrue((boolean)((WritableValue)detailObservables.get(master2)).isDisposed());
    }

    @Test
    public void testDisposeOnMasterDisposed() {
        WritableSet masterKeySet = new WritableSet();
        SetDetailValueObservableMap sdom = new SetDetailValueObservableMap((IObservableSet)masterKeySet, BeansObservables.valueFactory((String)"name"), String.class);
        Assert.assertFalse((boolean)masterKeySet.isDisposed());
        Assert.assertFalse((boolean)sdom.isDisposed());
        masterKeySet.dispose();
        Assert.assertTrue((boolean)masterKeySet.isDisposed());
        Assert.assertTrue((boolean)sdom.isDisposed());
    }
}

