/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.validation;

import org.eclipse.core.internal.databinding.validation.NumberToNumberValidator;
import org.eclipse.core.runtime.IStatus;
import org.junit.Assert;
import org.junit.Test;

public abstract class NumberToNumberValidatorTestHarness {
    protected abstract NumberToNumberValidator doGetToPrimitiveValidator(Class<?> var1);

    protected abstract NumberToNumberValidator doGetToBoxedTypeValidator(Class<?> var1);

    protected abstract Number doGetOutOfRangeNumber();

    @Test
    public void testValidateNullForBoxedTypeIsOK() throws Exception {
        IStatus status = this.doGetToBoxedTypeValidator(Integer.class).validate(null);
        Assert.assertTrue((boolean)status.isOK());
    }

    @Test
    public void testValidateNullForPrimitiveThrowsIllegalArgumentException() throws Exception {
        NumberToNumberValidator validator = this.doGetToPrimitiveValidator(Integer.class);
        if (validator == null) {
            return;
        }
        try {
            this.doGetToPrimitiveValidator(Integer.class).validate(null);
            Assert.fail((String)"exception should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void testValidReturnsOK() throws Exception {
        Assert.assertTrue((boolean)this.doGetToBoxedTypeValidator(Integer.class).validate((Object)1).isOK());
    }

    @Test
    public void testOutOfRangeReturnsError() throws Exception {
        Number number = this.doGetOutOfRangeNumber();
        if (number == null) {
            return;
        }
        IStatus status = this.doGetToBoxedTypeValidator(Integer.class).validate((Object)number);
        Assert.assertEquals((long)4L, (long)status.getSeverity());
        Assert.assertTrue((status.getMessage() != null ? 1 : 0) != 0);
    }

    @Test
    public void testValidateIncorrectTypeThrowsIllegalArgumentException() throws Exception {
        try {
            this.doGetToBoxedTypeValidator(Integer.class).validate((Object)"");
            Assert.fail((String)"exception should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }
}

