/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.validation;

import com.ibm.icu.text.NumberFormat;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.tests.databinding.BindingTestSetup;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public abstract class StringToNumberValidatorTestHarness {
    private NumberFormat numberFormat;
    private IValidator<Object> validator;
    @Rule
    public BindingTestSetup testSetup = new BindingTestSetup();

    @Before
    public void setUp() throws Exception {
        this.numberFormat = this.setupNumberFormat();
        this.validator = this.setupValidator(this.numberFormat);
    }

    protected abstract NumberFormat setupNumberFormat();

    protected abstract IValidator<Object> setupValidator(NumberFormat var1);

    protected abstract String getInvalidString();

    protected abstract Number getOutOfRangeNumber();

    protected abstract Number getInRangeNumber();

    @Test
    public void testInvalidValueReturnsError() throws Exception {
        IStatus status = this.validator.validate((Object)this.getInvalidString());
        Assert.assertEquals((String)"error severity", (long)4L, (long)status.getSeverity());
        Assert.assertNotNull((String)"message not null", (Object)status.getMessage());
    }

    @Test
    public void testOutOfRangeValueReturnsError() throws Exception {
        String string = this.numberFormat.format((Object)this.getOutOfRangeNumber());
        IStatus status = this.validator.validate((Object)string);
        Assert.assertEquals((long)4L, (long)status.getSeverity());
        Assert.assertNotNull((Object)status.getMessage());
    }

    @Test
    public void testValidateValidValue() throws Exception {
        String string = this.numberFormat.format((Object)this.getInRangeNumber());
        Assert.assertTrue((boolean)this.validator.validate((Object)string).isOK());
    }
}

