/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.databinding.scenarios;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.masterdetail.MasterDetailObservables;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewerSupport;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.examples.databinding.model.Adventure;
import org.eclipse.jface.examples.databinding.model.Catalog;
import org.eclipse.jface.examples.databinding.model.Category;
import org.eclipse.jface.examples.databinding.model.Lodging;
import org.eclipse.jface.examples.databinding.model.SampleData;
import org.eclipse.jface.tests.databinding.scenarios.ScenariosTestCase;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.junit.Assert;
import org.junit.Test;

public class MasterDetailScenarios
extends ScenariosTestCase {
    protected Object getViewerSelection(ContentViewer contentViewer) {
        return ((IStructuredSelection)contentViewer.getSelection()).getFirstElement();
    }

    protected List getViewerContent(ContentViewer contentViewer) {
        Object[] elements = ((IStructuredContentProvider)contentViewer.getContentProvider()).getElements(null);
        if (elements != null) {
            return Arrays.asList(elements);
        }
        return null;
    }

    @Test
    public void testScenario01() {
        ListViewer listViewer = new ListViewer(this.getComposite(), 2048);
        Realm realm = DisplayRealm.getRealm((Display)listViewer.getControl().getDisplay());
        listViewer.getList().setLayoutData((Object)new GridData(4, 4, false, false));
        Catalog catalog = SampleData.CATALOG_2005;
        IObservableList lodgings = BeansObservables.observeList((Realm)realm, (Object)catalog, (String)"lodgings");
        ViewerSupport.bind((StructuredViewer)listViewer, (IObservableList)lodgings, (IValueProperty)BeanProperties.value(Lodging.class, (String)"name"));
        this.assertArrayEquals(catalog.getLodgings(), this.getViewerContent((ContentViewer)listViewer).toArray());
        IViewerObservableValue selectedLodging = ViewersObservables.observeSingleSelection((Viewer)listViewer);
        selectedLodging.setValue((Object)SampleData.CAMP_GROUND);
        Assert.assertEquals((Object)SampleData.CAMP_GROUND, (Object)this.getViewerSelection((ContentViewer)listViewer));
        Text txtName = new Text(this.getComposite(), 2048);
        this.getDbc().bindValue((IObservableValue)SWTObservables.observeText((Control)txtName, (int)24), BeansObservables.observeDetailValue((IObservableValue)selectedLodging, (String)"name", String.class));
        Assert.assertEquals((Object)txtName.getText(), (Object)SampleData.CAMP_GROUND.getName());
        this.enterText(txtName, "foobar");
        Assert.assertEquals((Object)"foobar", (Object)SampleData.CAMP_GROUND.getName());
        listViewer.setSelection((ISelection)new StructuredSelection((Object)SampleData.FIVE_STAR_HOTEL));
        Assert.assertEquals((Object)SampleData.FIVE_STAR_HOTEL, (Object)selectedLodging.getValue());
        Assert.assertEquals((Object)SampleData.FIVE_STAR_HOTEL.getName(), (Object)txtName.getText());
        SampleData.FIVE_STAR_HOTEL.setName("barfoo");
        Assert.assertEquals((Object)"barfoo", (Object)txtName.getText());
        selectedLodging.dispose();
    }

    @Test
    public void testScenario02() {
        ListViewer listViewer = new ListViewer(this.getComposite(), 2048);
        listViewer.getList().setLayoutData((Object)new GridData(4, 4, false, false));
        Catalog catalog = SampleData.CATALOG_2005;
        IObservableList lodgings = BeansObservables.observeList((Realm)this.realm, (Object)catalog, (String)"lodgings");
        ViewerSupport.bind((StructuredViewer)listViewer, (IObservableList)lodgings, (IValueProperty)BeanProperties.value(Lodging.class, (String)"name"));
        this.assertArrayEquals(catalog.getLodgings(), this.getViewerContent((ContentViewer)listViewer).toArray());
        IViewerObservableValue selectedLodgingObservable = ViewersObservables.observeSingleSelection((Viewer)listViewer);
        selectedLodgingObservable.setValue(null);
        Assert.assertTrue((boolean)listViewer.getStructuredSelection().isEmpty());
        ComputedValue selectionExistsObservable = new ComputedValue(Boolean.TYPE, (IObservableValue)selectedLodgingObservable){
            private final /* synthetic */ IObservableValue val$selectedLodgingObservable;
            {
                this.val$selectedLodgingObservable = iObservableValue;
                super($anonymous0);
            }

            protected Object calculate() {
                return this.val$selectedLodgingObservable.getValue() != null;
            }
        };
        Assert.assertFalse((boolean)((Boolean)selectionExistsObservable.getValue()));
        Text txtName = new Text(this.getComposite(), 2048);
        this.getDbc().bindValue((IObservableValue)SWTObservables.observeEnabled((Control)txtName), (IObservableValue)selectionExistsObservable);
        this.getDbc().bindValue((IObservableValue)SWTObservables.observeText((Control)txtName, (int)24), BeansObservables.observeDetailValue((IObservableValue)selectedLodgingObservable, (String)"name", String.class));
        Assert.assertEquals((Object)txtName.getText(), (Object)"");
        Assert.assertFalse((boolean)txtName.getEnabled());
        Text txtDescription = new Text(this.getComposite(), 2048);
        this.getDbc().bindValue((IObservableValue)SWTObservables.observeEnabled((Control)txtDescription), (IObservableValue)selectionExistsObservable);
        this.getDbc().bindValue((IObservableValue)SWTObservables.observeText((Control)txtDescription, (int)24), MasterDetailObservables.detailValue((IObservableValue)selectedLodgingObservable, (IObservableFactory)BeansObservables.valueFactory((Realm)this.realm, (String)"description"), String.class));
        Assert.assertEquals((Object)txtDescription.getText(), (Object)"");
        Assert.assertFalse((boolean)txtDescription.getEnabled());
        Button addButton = new Button(this.getComposite(), 8);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter((IObservableValue)selectedLodgingObservable, catalog, listViewer, txtName, txtDescription){
            private final /* synthetic */ IObservableValue val$selectedLodgingObservable;
            private final /* synthetic */ Catalog val$catalog;
            private final /* synthetic */ ListViewer val$listViewer;
            private final /* synthetic */ Text val$txtName;
            private final /* synthetic */ Text val$txtDescription;
            {
                this.val$selectedLodgingObservable = iObservableValue;
                this.val$catalog = catalog;
                this.val$listViewer = listViewer;
                this.val$txtName = text;
                this.val$txtDescription = text2;
            }

            public void widgetSelected(SelectionEvent e) {
                Lodging selectedLodging = (Lodging)this.val$selectedLodgingObservable.getValue();
                int insertionIndex = 0;
                if (selectedLodging != null) {
                    insertionIndex = Arrays.asList(this.val$catalog.getLodgings()).indexOf(selectedLodging);
                    Assert.assertTrue((insertionIndex >= 0 ? 1 : 0) != 0);
                }
                Lodging newLodging = SampleData.FACTORY.createLodging();
                int itemCount = this.val$listViewer.getList().getItemCount();
                newLodging.setName("new lodging name " + itemCount);
                newLodging.setDescription("new lodging description " + itemCount);
                this.val$catalog.addLodging(newLodging);
                Assert.assertEquals((long)(itemCount + 1), (long)this.val$listViewer.getList().getItemCount());
                this.val$listViewer.setSelection((ISelection)new StructuredSelection((Object)newLodging));
                Assert.assertSame((Object)newLodging, (Object)this.val$selectedLodgingObservable.getValue());
                Assert.assertTrue((boolean)this.val$txtName.getEnabled());
                Assert.assertTrue((boolean)this.val$txtDescription.getEnabled());
                Assert.assertEquals((Object)newLodging.getName(), (Object)this.val$txtName.getText());
                Assert.assertEquals((Object)newLodging.getDescription(), (Object)this.val$txtDescription.getText());
            }
        });
        Button removeButton = new Button(this.getComposite(), 8);
        removeButton.addSelectionListener(new SelectionListener((IObservableValue)selectedLodgingObservable, catalog, listViewer){
            private final /* synthetic */ IObservableValue val$selectedLodgingObservable;
            private final /* synthetic */ Catalog val$catalog;
            private final /* synthetic */ ListViewer val$listViewer;
            {
                this.val$selectedLodgingObservable = iObservableValue;
                this.val$catalog = catalog;
                this.val$listViewer = listViewer;
            }

            public void widgetSelected(SelectionEvent e) {
                Lodging selectedLodging = (Lodging)this.val$selectedLodgingObservable.getValue();
                Assert.assertNotNull((Object)selectedLodging);
                int deletionIndex = Arrays.asList(this.val$catalog.getLodgings()).indexOf(selectedLodging);
                Assert.assertTrue((deletionIndex >= 0 ? 1 : 0) != 0);
                int itemCount = this.val$listViewer.getList().getItemCount();
                this.val$catalog.removeLodging(selectedLodging);
                Assert.assertEquals((long)(itemCount - 1), (long)this.val$listViewer.getList().getItemCount());
                Assert.assertNull((Object)this.val$selectedLodgingObservable.getValue());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.pushButtonWithEvents(addButton);
        this.pushButtonWithEvents(removeButton);
        this.pushButtonWithEvents(addButton);
        this.pushButtonWithEvents(addButton);
        this.pushButtonWithEvents(removeButton);
    }

    @Test
    public void testScenario03() {
        Catalog catalog = SampleData.CATALOG_2005;
        ListViewer categoryListViewer = new ListViewer(this.getComposite(), 2048);
        categoryListViewer.getList().setLayoutData((Object)new GridData(4, 4, false, false));
        IObservableList categories = BeansObservables.observeList((Realm)this.realm, (Object)catalog, (String)"categories");
        ViewerSupport.bind((StructuredViewer)categoryListViewer, (IObservableList)categories, (IValueProperty)BeanProperties.value(Category.class, (String)"name"));
        this.assertArrayEquals(catalog.getCategories(), this.getViewerContent((ContentViewer)categoryListViewer).toArray());
        IViewerObservableValue selectedCategoryObservable = ViewersObservables.observeSingleSelection((Viewer)categoryListViewer);
        ListViewer adventureListViewer = new ListViewer(this.getComposite(), 2048);
        adventureListViewer.getList().setLayoutData((Object)new GridData(4, 4, false, false));
        IObservableList adventures = BeansObservables.observeDetailList((IObservableValue)selectedCategoryObservable, (String)"adventures", Adventure.class);
        ViewerSupport.bind((StructuredViewer)adventureListViewer, (IObservableList)adventures, (IValueProperty)BeanProperties.value(Adventure.class, (String)"name"));
        ComputedValue categorySelectionExistsObservable = new ComputedValue((IObservableValue)selectedCategoryObservable){
            private final /* synthetic */ IObservableValue val$selectedCategoryObservable;
            {
                this.val$selectedCategoryObservable = iObservableValue;
            }

            protected Object calculate() {
                return this.val$selectedCategoryObservable.getValue() != null;
            }
        };
        this.getDbc().bindValue((IObservableValue)SWTObservables.observeEnabled((Control)adventureListViewer.getList()), (IObservableValue)categorySelectionExistsObservable);
        IViewerObservableValue selectedAdventureObservable = ViewersObservables.observeSingleSelection((Viewer)adventureListViewer);
        ComputedValue adventureSelectionExistsObservable = new ComputedValue((IObservableValue)selectedAdventureObservable){
            private final /* synthetic */ IObservableValue val$selectedAdventureObservable;
            {
                this.val$selectedAdventureObservable = iObservableValue;
            }

            protected Object calculate() {
                return this.val$selectedAdventureObservable.getValue() != null;
            }
        };
        Text txtName = new Text(this.getComposite(), 2048);
        this.getDbc().bindValue((IObservableValue)SWTObservables.observeEnabled((Control)txtName), (IObservableValue)adventureSelectionExistsObservable);
        this.getDbc().bindValue((IObservableValue)SWTObservables.observeText((Control)txtName, (int)24), BeansObservables.observeDetailValue((IObservableValue)selectedAdventureObservable, (String)"name", String.class));
        Assert.assertEquals((Object)txtName.getText(), (Object)"");
        Assert.assertFalse((boolean)txtName.getEnabled());
        Text txtDescription = new Text(this.getComposite(), 2048);
        this.getDbc().bindValue((IObservableValue)SWTObservables.observeEnabled((Control)txtDescription), (IObservableValue)adventureSelectionExistsObservable);
        this.getDbc().bindValue((IObservableValue)SWTObservables.observeText((Control)txtDescription, (int)24), BeansObservables.observeDetailValue((IObservableValue)selectedAdventureObservable, (String)"description", String.class));
        Assert.assertFalse((boolean)adventureListViewer.getList().isEnabled());
        categoryListViewer.setSelection((ISelection)new StructuredSelection((Object)SampleData.SUMMER_CATEGORY));
        Assert.assertTrue((boolean)adventureListViewer.getList().isEnabled());
        Assert.assertFalse((boolean)txtName.getEnabled());
        adventureListViewer.setSelection((ISelection)new StructuredSelection((Object)SampleData.RAFTING_HOLIDAY));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)adventureSelectionExistsObservable.getValue());
        Assert.assertTrue((boolean)txtName.getEnabled());
        Assert.assertEquals((Object)SampleData.RAFTING_HOLIDAY.getName(), (Object)txtName.getText());
        categoryListViewer.setSelection((ISelection)new StructuredSelection((Object)SampleData.WINTER_CATEGORY));
        Assert.assertTrue((boolean)adventureListViewer.getList().isEnabled());
        Assert.assertFalse((boolean)txtName.getEnabled());
    }
}

