/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.databinding.scenarios;

import com.ibm.icu.text.NumberFormat;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import org.eclipse.core.databinding.AggregateValidationStatus;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.conversion.NumberToStringConverter;
import org.eclipse.core.databinding.conversion.StringToNumberConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.internal.databinding.conversion.IdentityConverter;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.examples.databinding.model.Account;
import org.eclipse.jface.examples.databinding.model.Adventure;
import org.eclipse.jface.examples.databinding.model.Cart;
import org.eclipse.jface.examples.databinding.model.SampleData;
import org.eclipse.jface.tests.databinding.scenarios.ScenariosTestCase;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PropertyScenarios
extends ScenariosTestCase {
    private Adventure adventure;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.adventure = SampleData.WINTER_HOLIDAY;
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testEnterText() {
        Text text = new Text(this.getComposite(), 2048);
        final boolean[] focusLostHolder = new boolean[1];
        text.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                focusLostHolder[0] = true;
            }
        });
        this.enterText(text, "hallo");
        Assert.assertTrue((boolean)focusLostHolder[0]);
    }

    @Test
    public void testScenario01() {
        Text text = new Text(this.getComposite(), 2048);
        this.getDbc().bindValue((IObservableValue)SWTObservables.observeText((Control)text, (int)24), BeansObservables.observeValue((Object)this.adventure, (String)"name"));
        Assert.assertEquals((Object)this.adventure.getName(), (Object)text.getText());
        this.enterText(text, "foobar");
        Assert.assertEquals((Object)"foobar", (Object)this.adventure.getName());
        this.adventure.setName("barfoo");
        Assert.assertEquals((Object)"barfoo", (Object)text.getText());
    }

    @Test
    public void testScenario02() {
        Text text = new Text(this.getComposite(), 8);
        this.getDbc().bindValue((IObservableValue)SWTObservables.observeText((Control)text, (int)0), BeansObservables.observeValue((Object)this.adventure, (String)"name"));
        Assert.assertEquals((Object)this.adventure.getName(), (Object)text.getText());
    }

    @Test
    public void testScenario03() {
        Cart cart = SampleData.CART;
        cart.setAdventureDays(42);
        Text text = new Text(this.getComposite(), 2048);
        System.out.println("Expecting message about not being able to attach a listener");
        this.getDbc().bindValue((IObservableValue)SWTObservables.observeText((Control)text, (int)24), BeansObservables.observeValue((Object)cart, (String)"lodgingDays"));
        Assert.assertEquals((Object)Integer.valueOf(cart.getLodgingDays()).toString(), (Object)text.getText());
    }

    @Test
    public void testScenario04() {
        Text text = new Text(this.getComposite(), 2048);
        IObservableValue defaultLodging = BeansObservables.observeDetailValue((IObservableValue)BeansObservables.observeValue((Object)this.adventure, (String)"defaultLodging"), (String)"description", String.class);
        this.getDbc().bindValue((IObservableValue)SWTObservables.observeText((Control)text, (int)24), defaultLodging);
        Assert.assertEquals((Object)this.adventure.getDefaultLodging().getDescription(), (Object)text.getText());
        this.enterText(text, "foobar");
        Assert.assertEquals((Object)"foobar", (Object)this.adventure.getDefaultLodging().getDescription());
        this.adventure.getDefaultLodging().setDescription("barfoo");
        Assert.assertEquals((Object)this.adventure.getDefaultLodging().getDescription(), (Object)text.getText());
        this.adventure.setDefaultLodging(SampleData.CAMP_GROUND);
        Assert.assertEquals((Object)this.adventure.getDefaultLodging().getDescription(), (Object)text.getText());
        this.adventure.getDefaultLodging().setDescription("barfo");
        Assert.assertEquals((Object)this.adventure.getDefaultLodging().getDescription(), (Object)text.getText());
        this.adventure.setDefaultLodging(null);
        Assert.assertEquals((Object)"", (Object)text.getText());
        this.adventure.setDefaultLodging(SampleData.FIVE_STAR_HOTEL);
        Assert.assertEquals((Object)this.adventure.getDefaultLodging().getDescription(), (Object)text.getText());
        this.adventure.getDefaultLodging().setDescription("barf");
        Assert.assertEquals((Object)this.adventure.getDefaultLodging().getDescription(), (Object)text.getText());
    }

    @Test
    public void testScenario05() {
        Text text = new Text(this.getComposite(), 2048);
        this.adventure.setName("UPPERCASE");
        IConverter converter1 = new IConverter(){

            public Object getFromType() {
                return String.class;
            }

            public Object getToType() {
                return String.class;
            }

            public Object convert(Object toObject) {
                String modelValue = (String)toObject;
                if (modelValue == null || modelValue.equals("")) {
                    return modelValue;
                }
                String firstChar = modelValue.substring(0, 1);
                String remainingChars = modelValue.substring(1);
                return String.valueOf(firstChar.toUpperCase()) + remainingChars.toLowerCase();
            }
        };
        IConverter converter2 = new IConverter(){

            public Object getFromType() {
                return String.class;
            }

            public Object getToType() {
                return String.class;
            }

            public Object convert(Object fromObject) {
                return ((String)fromObject).toUpperCase();
            }
        };
        this.getDbc().bindValue((IObservableValue)SWTObservables.observeText((Control)text, (int)24), BeansObservables.observeValue((Object)this.adventure, (String)"name"), new UpdateValueStrategy().setConverter(converter2), new UpdateValueStrategy().setConverter(converter1));
        Assert.assertEquals((Object)"Uppercase", (Object)text.getText());
        this.enterText(text, "lowercase");
        Assert.assertEquals((Object)"LOWERCASE", (Object)this.adventure.getName());
    }

    @Test
    public void testScenario06() {
        Text text = new Text(this.getComposite(), 2048);
        this.adventure.setName("ValidValue");
        IValidator validator = value -> {
            String stringValue = (String)value;
            if (stringValue.length() > 15) {
                return ValidationStatus.error((String)"Maximum length for name is 15 characters.");
            }
            if (stringValue.indexOf(32) != -1) {
                return ValidationStatus.cancel((String)"Name must not contain spaces.");
            }
            return Status.OK_STATUS;
        };
        Binding binding = this.getDbc().bindValue((IObservableValue)SWTObservables.observeText((Control)text, (int)24), BeansObservables.observeValue((Object)this.adventure, (String)"name"), new UpdateValueStrategy().setConverter((IConverter)new IdentityConverter(String.class)).setAfterGetValidator(validator), new UpdateValueStrategy().setConverter((IConverter)new IdentityConverter(String.class)));
        Assert.assertTrue((boolean)((IStatus)binding.getValidationStatus().getValue()).isOK());
        this.enterText(text, "Invalid Value");
        Assert.assertEquals((Object)"Name must not contain spaces.", (Object)((IStatus)binding.getValidationStatus().getValue()).getMessage());
        Assert.assertEquals((Object)"ValidValue", (Object)this.adventure.getName());
        text.setText("InvalidValueBecauseTooLong");
        Assert.assertEquals((Object)"Maximum length for name is 15 characters.", (Object)((IStatus)binding.getValidationStatus().getValue()).getMessage());
        Assert.assertEquals((Object)"ValidValue", (Object)this.adventure.getName());
        this.enterText(text, "anothervalid");
        Assert.assertTrue((boolean)((IStatus)binding.getValidationStatus().getValue()).isOK());
        Assert.assertEquals((Object)"anothervalid", (Object)this.adventure.getName());
    }

    @Test
    public void testScenario07() {
        Text text = new Text(this.getComposite(), 2048);
        this.adventure.setPrice(5.0);
        IValidator validator = value -> {
            String stringValue = (String)value;
            try {
                double doubleValue = new Double(stringValue);
                if (doubleValue < 0.0) {
                    return ValidationStatus.error((String)"Price cannot be negative.");
                }
                return Status.OK_STATUS;
            }
            catch (NumberFormatException numberFormatException) {
                return ValidationStatus.error((String)"Price must be a currency.");
            }
        };
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMinimumFractionDigits(1);
        StringToNumberConverter targetToModelConverter = StringToNumberConverter.toDouble((NumberFormat)numberFormat, (boolean)true);
        NumberToStringConverter modelToTargetConverter = NumberToStringConverter.fromDouble((NumberFormat)numberFormat, (boolean)true);
        this.getDbc().bindValue((IObservableValue)SWTObservables.observeText((Control)text, (int)24), BeansObservables.observeValue((Object)this.adventure, (String)"price"), new UpdateValueStrategy().setAfterGetValidator(validator).setConverter((IConverter)targetToModelConverter), new UpdateValueStrategy().setConverter((IConverter)modelToTargetConverter));
        String expected = numberFormat.format(this.adventure.getPrice());
        Assert.assertEquals((Object)expected, (Object)text.getText());
        Assert.assertTrue((boolean)AggregateValidationStatus.getStatusMaxSeverity((Collection)this.getDbc().getBindings()).isOK());
        String toEnter = numberFormat.format(0.65);
        this.enterText(text, toEnter);
        Assert.assertTrue((boolean)AggregateValidationStatus.getStatusMaxSeverity((Collection)this.getDbc().getBindings()).isOK());
        Assert.assertEquals((double)0.65, (double)this.adventure.getPrice(), (double)1.0E-4);
        this.adventure.setPrice(42.24);
        expected = numberFormat.format(this.adventure.getPrice());
        Assert.assertEquals((Object)expected, (Object)text.getText());
        Assert.assertTrue((boolean)AggregateValidationStatus.getStatusMaxSeverity((Collection)this.getDbc().getBindings()).isOK());
        this.enterText(text, "jygt");
        Assert.assertEquals((Object)"Price must be a currency.", (Object)AggregateValidationStatus.getStatusMaxSeverity((Collection)this.getDbc().getBindings()).getMessage());
        toEnter = numberFormat.format(-23.9);
        this.enterText(text, toEnter);
        Assert.assertEquals((Object)"Price cannot be negative.", (Object)AggregateValidationStatus.getStatusMaxSeverity((Collection)this.getDbc().getBindings()).getMessage());
        Assert.assertEquals((double)42.24, (double)this.adventure.getPrice(), (double)1.0E-4);
        this.adventure.setPrice(0.0);
        Assert.assertTrue((boolean)AggregateValidationStatus.getStatusMaxSeverity((Collection)this.getDbc().getBindings()).isOK());
    }

    @Test
    public void testScenario08() {
        Text text = new Text(this.getComposite(), 2048);
        this.adventure.setPrice(5.0);
        final NumberFormat currencyFormat = NumberFormat.getCurrencyInstance((Locale)Locale.CANADA);
        Converter toCurrency = new Converter(Double.TYPE, String.class){

            public Object convert(Object toObject) {
                return currencyFormat.format(((Double)toObject).doubleValue());
            }
        };
        Converter toDouble = new Converter(String.class, Double.TYPE){

            public Object convert(Object fromObject) {
                try {
                    return new Double(currencyFormat.parse((String)fromObject).doubleValue());
                }
                catch (ParseException parseException) {
                    return new Double(0.0);
                }
            }
        };
        IValidator validator = value -> {
            String stringValue = (String)value;
            try {
                double doubleValue = currencyFormat.parse(stringValue).doubleValue();
                if (doubleValue < 0.0) {
                    return ValidationStatus.error((String)"Price cannot be negative.");
                }
                return Status.OK_STATUS;
            }
            catch (ParseException parseException) {
                return ValidationStatus.error((String)"Price must be a currency.");
            }
        };
        this.getDbc().bindValue((IObservableValue)SWTObservables.observeText((Control)text, (int)24), BeansObservables.observeValue((Object)this.adventure, (String)"price"), new UpdateValueStrategy().setConverter((IConverter)toDouble).setAfterGetValidator(validator), new UpdateValueStrategy().setConverter((IConverter)toCurrency));
        String expected = currencyFormat.format(5L);
        Assert.assertEquals((Object)expected, (Object)text.getText());
        Assert.assertTrue((boolean)AggregateValidationStatus.getStatusMaxSeverity((Collection)this.getDbc().getBindings()).isOK());
        String toEnter = currencyFormat.format(0.65);
        this.enterText(text, toEnter);
        Assert.assertTrue((boolean)AggregateValidationStatus.getStatusMaxSeverity((Collection)this.getDbc().getBindings()).isOK());
        Assert.assertEquals((double)0.65, (double)this.adventure.getPrice(), (double)1.0E-4);
        this.adventure.setPrice(42.24);
        expected = currencyFormat.format(this.adventure.getPrice());
        Assert.assertEquals((Object)expected, (Object)text.getText());
        Assert.assertTrue((boolean)AggregateValidationStatus.getStatusMaxSeverity((Collection)this.getDbc().getBindings()).isOK());
        this.enterText(text, "jygt");
        Assert.assertEquals((Object)"Price must be a currency.", (Object)AggregateValidationStatus.getStatusMaxSeverity((Collection)this.getDbc().getBindings()).getMessage());
        toEnter = currencyFormat.format(-23.9);
        this.enterText(text, toEnter);
        Assert.assertEquals((Object)"Price cannot be negative.", (Object)AggregateValidationStatus.getStatusMaxSeverity((Collection)this.getDbc().getBindings()).getMessage());
        Assert.assertEquals((double)42.24, (double)this.adventure.getPrice(), (double)1.0E-4);
        this.adventure.setPrice(0.0);
        Assert.assertTrue((boolean)AggregateValidationStatus.getStatusMaxSeverity((Collection)this.getDbc().getBindings()).isOK());
    }

    @Test
    public void testScenario09() {
        Button checkbox = new Button(this.getComposite(), 32);
        this.adventure.setPetsAllowed(true);
        this.getDbc().bindValue((IObservableValue)SWTObservables.observeSelection((Control)checkbox), BeansObservables.observeValue((Object)this.adventure, (String)"petsAllowed"));
        Assert.assertEquals((Object)true, (Object)checkbox.getSelection());
        this.setButtonSelectionWithEvents(checkbox, false);
        Assert.assertEquals((Object)false, (Object)this.adventure.isPetsAllowed());
        this.adventure.setPetsAllowed(true);
        Assert.assertEquals((Object)true, (Object)checkbox.getSelection());
    }

    @Test
    public void testScenario10() {
    }

    @Test
    public void testScenario11() {
        Spinner spinner1 = new Spinner(this.getComposite(), 0);
        spinner1.setSelection(10);
        spinner1.setMinimum(1);
        spinner1.setMaximum(100);
        Spinner spinner2 = new Spinner(this.getComposite(), 0);
        spinner2.setMaximum(1);
        this.getDbc().bindValue((IObservableValue)SWTObservables.observeSelection((Control)spinner1), (IObservableValue)SWTObservables.observeMax((Control)spinner2));
        Assert.assertEquals((long)1L, (long)spinner1.getSelection());
        spinner1.setSelection(10);
        spinner1.notifyListeners(24, new Event());
        Assert.assertEquals((long)10L, (long)spinner2.getMaximum());
    }

    @Test
    public void testScenario12() {
        Button checkbox1 = new Button(this.getComposite(), 32);
        checkbox1.setSelection(false);
        Button checkbox2 = new Button(this.getComposite(), 32);
        checkbox2.setSelection(false);
        Text text1 = new Text(this.getComposite(), 0);
        Text text2 = new Text(this.getComposite(), 0);
        ISWTObservableValue checkbox1Selected = SWTObservables.observeSelection((Control)checkbox1);
        ISWTObservableValue checkbox2Selected = SWTObservables.observeSelection((Control)checkbox2);
        Converter negatingConverter = new Converter(Boolean.TYPE, Boolean.TYPE){

            private Boolean negated(Boolean booleanObject) {
                return booleanObject == false;
            }

            public Object convert(Object targetObject) {
                return this.negated((Boolean)targetObject);
            }
        };
        this.getDbc().bindValue((IObservableValue)checkbox1Selected, (IObservableValue)checkbox2Selected, new UpdateValueStrategy().setConverter((IConverter)negatingConverter), new UpdateValueStrategy().setConverter((IConverter)negatingConverter));
        this.getDbc().bindValue((IObservableValue)SWTObservables.observeEnabled((Control)text1), (IObservableValue)checkbox1Selected);
        this.getDbc().bindValue((IObservableValue)SWTObservables.observeEnabled((Control)text2), (IObservableValue)checkbox2Selected);
        Assert.assertEquals((Object)true, (Object)text1.getEnabled());
        Assert.assertEquals((Object)false, (Object)text2.getEnabled());
        Assert.assertEquals((Object)true, (Object)checkbox1.getSelection());
        this.setButtonSelectionWithEvents(checkbox1, false);
        Assert.assertEquals((Object)false, (Object)text1.getEnabled());
        Assert.assertEquals((Object)true, (Object)text2.getEnabled());
        Assert.assertEquals((Object)true, (Object)checkbox2.getSelection());
        this.setButtonSelectionWithEvents(checkbox2, false);
        Assert.assertEquals((Object)true, (Object)text1.getEnabled());
        Assert.assertEquals((Object)false, (Object)text2.getEnabled());
        Assert.assertEquals((Object)true, (Object)checkbox1.getSelection());
    }

    @Test
    public void testScenario13() {
        Text text = new Text(this.getComposite(), 2048);
        this.getDbc().bindValue((IObservableValue)SWTObservables.observeText((Control)text, (int)16), BeansObservables.observeValue((Object)this.adventure, (String)"name"));
        String adventureName = this.adventure.getName();
        Assert.assertEquals((Object)adventureName, (Object)text.getText());
        this.enterText(text, "foobar");
        Assert.assertEquals((Object)"foobar", (Object)this.adventure.getName());
        this.adventure.setName("barfoo");
        Assert.assertEquals((Object)"barfoo", (Object)text.getText());
    }

    @Test
    public void testScenario14() {
        Text t1 = new Text(this.getComposite(), 2048);
        Text t2 = new Text(this.getComposite(), 2048);
        this.getDbc().bindValue((IObservableValue)SWTObservables.observeText((Control)t1, (int)24), BeansObservables.observeValue((Object)this.adventure, (String)"name"));
        this.getDbc().bindValue((IObservableValue)SWTObservables.observeText((Control)t2, (int)24), BeansObservables.observeValue((Object)this.adventure, (String)"name"));
        int[] counter = new int[1];
        IObservableValue uv = BeansObservables.observeValue((Object)this.adventure, (String)"name");
        uv.addChangeListener(event -> {
            int n = counter[0];
            int n2 = n;
            nArray[0] = n + 1;
        });
        String name = String.valueOf(this.adventure.getName()) + "Foo";
        this.enterText(t1, name);
        Assert.assertEquals((Object)name, (Object)this.adventure.getName());
        Assert.assertEquals((Object)name, (Object)t2.getText());
        Assert.assertTrue((counter[0] == 1 ? 1 : 0) != 0);
        name = String.valueOf(name) + "Bar";
        uv.setValue((Object)name);
        Assert.assertEquals((Object)t1.getText(), (Object)this.adventure.getName());
        Assert.assertEquals((long)2L, (long)counter[0]);
    }

    @Test
    public void testScenario15() {
        Text text = new Text(this.getComposite(), 0);
        Account account = new Account();
        account.setExpiryDate(new Date());
        Binding b = this.getDbc().bindValue((IObservableValue)SWTObservables.observeText((Control)text, (int)24), BeansObservables.observeValue((Object)account, (String)"expiryDate"));
        Text errorText = new Text(this.getComposite(), 0);
        this.getDbc().bindValue((IObservableValue)SWTObservables.observeText((Control)errorText, (int)24), b.getValidationStatus(), new UpdateValueStrategy(false, UpdateValueStrategy.POLICY_NEVER), null);
        Assert.assertTrue((boolean)((IStatus)b.getValidationStatus().getValue()).isOK());
        this.enterText(text, "foo");
        Assert.assertFalse((boolean)((IStatus)b.getValidationStatus().getValue()).isOK());
    }
}

