/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.databinding.scenarios;

import com.ibm.icu.text.NumberFormat;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.examples.databinding.model.Account;
import org.eclipse.jface.examples.databinding.model.Adventure;
import org.eclipse.jface.examples.databinding.model.SampleData;
import org.eclipse.jface.examples.databinding.model.Transportation;
import org.eclipse.jface.tests.databinding.scenarios.CustomBeanUpdateValueStrategy;
import org.eclipse.jface.tests.databinding.scenarios.ScenariosTestCase;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class TextControlScenario
extends ScenariosTestCase {
    private Text text;
    private Adventure adventure;
    private Transportation transportation;
    Account account;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.adventure = SampleData.WINTER_HOLIDAY;
        this.transportation = SampleData.EXECUTIVE_JET;
        this.account = SampleData.PRESIDENT;
        this.text = new Text(this.getComposite(), 2048);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.text.dispose();
        this.text = null;
        super.tearDown();
    }

    @Test
    public void testScenario01() {
        this.getDbc().bindValue((IObservableValue)SWTObservables.observeText((Control)this.text, (int)24), BeansObservables.observeValue((Object)this.adventure, (String)"name"));
        Assert.assertEquals((Object)this.adventure.getName(), (Object)this.text.getText());
        this.text.setText("England");
        this.text.notifyListeners(16, null);
        Assert.assertEquals((Object)"England", (Object)this.adventure.getName());
        this.adventure.setName("France");
        Assert.assertEquals((Object)"France", (Object)this.text.getText());
        this.adventure.setName("Germany");
        this.spinEventLoop(0);
        Assert.assertEquals((Object)"Germany", (Object)this.text.getText());
    }

    @Test
    public void testScenario02() {
        this.getDbc().bindValue((IObservableValue)SWTObservables.observeText((Control)this.text, (int)24), BeansObservables.observeValue((Object)this.transportation, (String)"price"));
        NumberFormat numberFormat = NumberFormat.getInstance();
        Assert.assertEquals((Object)numberFormat.format(this.transportation.getPrice()), (Object)this.text.getText());
        this.text.setText("9876.54");
        this.text.notifyListeners(16, null);
        Assert.assertEquals((double)9876.54, (double)this.transportation.getPrice(), (double)0.0);
        this.transportation.setPrice(1234.56);
        Assert.assertEquals((Object)numberFormat.format(this.transportation.getPrice()), (Object)this.text.getText());
    }

    @Test
    public void testScenario06() {
    }

    @Test
    public void testScenario07() {
    }

    @Test
    @Ignore
    public void testScenario08() {
        DataBindingContext dbc = this.getDbc();
        dbc.bindValue((IObservableValue)SWTObservables.observeText((Control)this.text, (int)24), BeansObservables.observeValue((Object)this.adventure, (String)"maxNumberOfPeople"), (UpdateValueStrategy)new CustomBeanUpdateValueStrategy(), null);
        this.text.setText("4");
        Assert.assertEquals((long)4L, (long)this.adventure.getMaxNumberOfPeople());
        this.text.setText("999");
        Assert.assertEquals((long)4L, (long)this.adventure.getMaxNumberOfPeople());
        dbc.dispose();
    }

    @Test
    public void testScenario09() {
        Label label = new Label(this.getComposite(), 0);
        this.getDbc().bindValue((IObservableValue)SWTObservables.observeText((Control)this.text, (int)16), (IObservableValue)SWTObservables.observeText((Control)label));
        this.text.setText("Frog");
        Assert.assertTrue((label.getText().length() == 0 ? 1 : 0) != 0);
        this.text.notifyListeners(16, null);
        Assert.assertEquals((Object)label.getText(), (Object)"Frog");
    }

    @Test
    public void testScenario10() {
        Label label = new Label(this.getComposite(), 0);
        this.getDbc().bindValue((IObservableValue)SWTObservables.observeText((Control)this.text, (int)24), (IObservableValue)SWTObservables.observeText((Control)label));
        String newTextValue = "Frog";
        int i = 0;
        while (i < newTextValue.length()) {
            this.text.setText(newTextValue.substring(0, i + 1));
            Assert.assertEquals((Object)this.text.getText(), (Object)label.getText());
            ++i;
        }
        this.text.notifyListeners(16, null);
        Assert.assertEquals((Object)this.text.getText(), (Object)label.getText());
    }
}

