/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.databinding.swt;

import org.eclipse.core.databinding.observable.IDecoratingObservable;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.property.IPropertyObservable;
import org.eclipse.jface.databinding.conformance.util.ChangeEventTracker;
import org.eclipse.jface.databinding.conformance.util.RealmTester;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.jface.databinding.swt.ISWTObservable;
import org.eclipse.jface.databinding.swt.ISWTObservableList;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.internal.databinding.swt.ButtonImageProperty;
import org.eclipse.jface.internal.databinding.swt.ButtonSelectionProperty;
import org.eclipse.jface.internal.databinding.swt.ButtonTextProperty;
import org.eclipse.jface.internal.databinding.swt.CComboEditableProperty;
import org.eclipse.jface.internal.databinding.swt.CComboItemsProperty;
import org.eclipse.jface.internal.databinding.swt.CComboSelectionProperty;
import org.eclipse.jface.internal.databinding.swt.CComboTextProperty;
import org.eclipse.jface.internal.databinding.swt.CLabelImageProperty;
import org.eclipse.jface.internal.databinding.swt.CLabelTextProperty;
import org.eclipse.jface.internal.databinding.swt.CTabItemTooltipTextProperty;
import org.eclipse.jface.internal.databinding.swt.ComboItemsProperty;
import org.eclipse.jface.internal.databinding.swt.ComboSelectionProperty;
import org.eclipse.jface.internal.databinding.swt.ComboTextProperty;
import org.eclipse.jface.internal.databinding.swt.ControlBackgroundProperty;
import org.eclipse.jface.internal.databinding.swt.ControlForegroundProperty;
import org.eclipse.jface.internal.databinding.swt.ControlTooltipTextProperty;
import org.eclipse.jface.internal.databinding.swt.DateTimeSelectionProperty;
import org.eclipse.jface.internal.databinding.swt.ItemImageProperty;
import org.eclipse.jface.internal.databinding.swt.ItemTextProperty;
import org.eclipse.jface.internal.databinding.swt.LabelImageProperty;
import org.eclipse.jface.internal.databinding.swt.LabelTextProperty;
import org.eclipse.jface.internal.databinding.swt.ListItemsProperty;
import org.eclipse.jface.internal.databinding.swt.ListSelectionProperty;
import org.eclipse.jface.internal.databinding.swt.MenuEnabledProperty;
import org.eclipse.jface.internal.databinding.swt.MenuItemEnabledProperty;
import org.eclipse.jface.internal.databinding.swt.MenuItemSelectionProperty;
import org.eclipse.jface.internal.databinding.swt.ScaleMaximumProperty;
import org.eclipse.jface.internal.databinding.swt.ScaleMinimumProperty;
import org.eclipse.jface.internal.databinding.swt.ScaleSelectionProperty;
import org.eclipse.jface.internal.databinding.swt.ScrollBarEnabledProperty;
import org.eclipse.jface.internal.databinding.swt.SpinnerMaximumProperty;
import org.eclipse.jface.internal.databinding.swt.SpinnerMinimumProperty;
import org.eclipse.jface.internal.databinding.swt.SpinnerSelectionProperty;
import org.eclipse.jface.internal.databinding.swt.StyledTextEditableProperty;
import org.eclipse.jface.internal.databinding.swt.StyledTextTextProperty;
import org.eclipse.jface.internal.databinding.swt.TableSingleSelectionIndexProperty;
import org.eclipse.jface.internal.databinding.swt.TextEditableProperty;
import org.eclipse.jface.internal.databinding.swt.TextTextProperty;
import org.eclipse.jface.internal.databinding.swt.ToolItemEnabledProperty;
import org.eclipse.jface.tests.databinding.AbstractSWTTestCase;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SWTObservablesTest
extends AbstractSWTTestCase {
    private Shell shell;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.shell = this.getShell();
        RealmTester.setDefault((Realm)DisplayRealm.getRealm((Display)this.shell.getDisplay()));
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        RealmTester.setDefault(null);
    }

    @Override
    protected Shell createShell() {
        return new Shell(512);
    }

    @Test
    public void testObserveForeground() throws Exception {
        ISWTObservableValue value = SWTObservables.observeForeground((Control)this.shell);
        this.assertWidgetObservable((ISWTObservable)value, (Widget)this.shell, ControlForegroundProperty.class);
        Assert.assertEquals(Color.class, (Object)value.getValueType());
    }

    @Test
    public void testObserveBackground() throws Exception {
        ISWTObservableValue value = SWTObservables.observeBackground((Control)this.shell);
        this.assertWidgetObservable((ISWTObservable)value, (Widget)this.shell, ControlBackgroundProperty.class);
        Assert.assertEquals(Color.class, (Object)value.getValueType());
    }

    @Test
    public void testObserveFont() throws Exception {
        ISWTObservableValue value = SWTObservables.observeFont((Control)this.shell);
        Assert.assertNotNull((Object)value);
        Assert.assertEquals(Font.class, (Object)value.getValueType());
    }

    @Test
    public void testObserveSelectionOfSpinner() throws Exception {
        Spinner spinner = new Spinner((Composite)this.shell, 0);
        ISWTObservableValue value = SWTObservables.observeSelection((Control)spinner);
        this.assertWidgetObservable((ISWTObservable)value, (Widget)spinner, SpinnerSelectionProperty.class);
    }

    @Test
    public void testObserveSelectionOfButton() throws Exception {
        Button button = new Button((Composite)this.shell, 8);
        ISWTObservableValue value = SWTObservables.observeSelection((Control)button);
        this.assertWidgetObservable((ISWTObservable)value, (Widget)button, ButtonSelectionProperty.class);
    }

    @Test
    public void testObserveSelectionOfCombo() throws Exception {
        Combo combo = new Combo((Composite)this.shell, 0);
        ISWTObservableValue value = SWTObservables.observeSelection((Control)combo);
        this.assertWidgetObservable((ISWTObservable)value, (Widget)combo, ComboSelectionProperty.class);
    }

    @Test
    public void testObserveSelectionOfCCombo() throws Exception {
        CCombo combo = new CCombo((Composite)this.shell, 0);
        ISWTObservableValue value = SWTObservables.observeSelection((Control)combo);
        this.assertWidgetObservable((ISWTObservable)value, (Widget)combo, CComboSelectionProperty.class);
    }

    @Test
    public void testObserveSelectionOfDateTime_Date() throws Exception {
        DateTime dateTime = new DateTime((Composite)this.shell, 32);
        ISWTObservableValue value = SWTObservables.observeSelection((Control)dateTime);
        this.assertWidgetObservable((ISWTObservable)value, (Widget)dateTime, DateTimeSelectionProperty.class);
    }

    @Test
    public void testObserveSelectionOfDateTime_Calendar() throws Exception {
        DateTime dateTime = new DateTime((Composite)this.shell, 1024);
        ISWTObservableValue value = SWTObservables.observeSelection((Control)dateTime);
        this.assertWidgetObservable((ISWTObservable)value, (Widget)dateTime, DateTimeSelectionProperty.class);
    }

    @Test
    public void testObserveSelectionOfDateTime_Time() throws Exception {
        DateTime dateTime = new DateTime((Composite)this.shell, 128);
        ISWTObservableValue value = SWTObservables.observeSelection((Control)dateTime);
        this.assertWidgetObservable((ISWTObservable)value, (Widget)dateTime, DateTimeSelectionProperty.class);
    }

    @Test
    public void testObserveSelectionOfList() throws Exception {
        List list = new List((Composite)this.shell, 0);
        ISWTObservableValue value = SWTObservables.observeSelection((Control)list);
        this.assertWidgetObservable((ISWTObservable)value, (Widget)list, ListSelectionProperty.class);
    }

    @Test
    public void testObserveSelectionOfScale() throws Exception {
        Scale scale = new Scale((Composite)this.shell, 0);
        ISWTObservableValue value = SWTObservables.observeSelection((Control)scale);
        this.assertWidgetObservable((ISWTObservable)value, (Widget)scale, ScaleSelectionProperty.class);
    }

    @Test
    public void testObserveSelectionOfUnsupportedControl() throws Exception {
        try {
            Text text = new Text((Composite)this.shell, 0);
            SWTObservables.observeSelection((Control)text);
            Assert.fail((String)"Exception should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void testObserveTextWithEventOfText() throws Exception {
        Text text = new Text((Composite)this.shell, 0);
        Assert.assertFalse((boolean)text.isListening(16));
        ISWTObservableValue value = SWTObservables.observeText((Control)text, (int)16);
        this.assertWidgetObservable((ISWTObservable)value, (Widget)text, TextTextProperty.class);
        Assert.assertFalse((boolean)text.isListening(16));
        ChangeEventTracker.observe((IObservable)value);
        Assert.assertTrue((boolean)text.isListening(16));
    }

    @Test
    public void testObserveTextOfStyledText() throws Exception {
        StyledText text = new StyledText((Composite)this.shell, 0);
        Assert.assertFalse((boolean)text.isListening(16));
        ISWTObservableValue value = SWTObservables.observeText((Control)text, (int)16);
        this.assertWidgetObservable((ISWTObservable)value, (Widget)text, StyledTextTextProperty.class);
        Assert.assertFalse((boolean)text.isListening(16));
        ChangeEventTracker.observe((IObservable)value);
        Assert.assertTrue((boolean)text.isListening(16));
    }

    @Test
    public void testObserveTextWithEventOfUnsupportedControl() throws Exception {
        Label label = new Label((Composite)this.shell, 0);
        try {
            SWTObservables.observeText((Control)label, (int)16);
            Assert.fail((String)"Exception should have been thrown");
        }
        catch (Exception exception) {}
    }

    @Test
    public void testObserveTextOfButton() throws Exception {
        Button button = new Button((Composite)this.shell, 8);
        ISWTObservableValue value = SWTObservables.observeText((Control)button);
        this.assertWidgetObservable((ISWTObservable)value, (Widget)button, ButtonTextProperty.class);
    }

    @Test
    public void testObserveTextOfLabel() throws Exception {
        Label label = new Label((Composite)this.shell, 0);
        ISWTObservableValue value = SWTObservables.observeText((Control)label);
        this.assertWidgetObservable((ISWTObservable)value, (Widget)label, LabelTextProperty.class);
    }

    @Test
    public void testObserveTextOfCLabel() throws Exception {
        CLabel label = new CLabel((Composite)this.shell, 0);
        ISWTObservableValue value = SWTObservables.observeText((Control)label);
        this.assertWidgetObservable((ISWTObservable)value, (Widget)label, CLabelTextProperty.class);
    }

    @Test
    public void testObserveTextOfCombo() throws Exception {
        Combo combo = new Combo((Composite)this.shell, 0);
        ISWTObservableValue value = SWTObservables.observeText((Control)combo);
        this.assertWidgetObservable((ISWTObservable)value, (Widget)combo, ComboTextProperty.class);
    }

    private IPropertyObservable getPropertyObservable(ISWTObservable observable) {
        IDecoratingObservable decoratingObservable = (IDecoratingObservable)observable;
        IPropertyObservable propertyObservable = (IPropertyObservable)decoratingObservable.getDecorated();
        return propertyObservable;
    }

    @Test
    public void testObserveTextOfCCombo() throws Exception {
        CCombo combo = new CCombo((Composite)this.shell, 0);
        ISWTObservableValue value = SWTObservables.observeText((Control)combo);
        this.assertWidgetObservable((ISWTObservable)value, (Widget)combo, CComboTextProperty.class);
    }

    @Test
    public void testObserveTextOfText() throws Exception {
        Text text = new Text((Composite)this.shell, 0);
        ISWTObservableValue value = SWTObservables.observeText((Control)text);
        this.assertWidgetObservable((ISWTObservable)value, (Widget)text, TextTextProperty.class);
        Assert.assertFalse((boolean)text.isListening(24));
        Assert.assertFalse((boolean)text.isListening(16));
    }

    @Test
    public void testObserveTextOfItem() throws Exception {
        CTabFolder ctf = new CTabFolder((Composite)this.shell, 0);
        CTabItem item = new CTabItem(ctf, 0);
        ISWTObservableValue value = SWTObservables.observeText((Widget)item);
        this.assertWidgetObservable((ISWTObservable)value, (Widget)item, ItemTextProperty.class);
    }

    @Test
    public void testObserveTextOfUnsupportedControl() throws Exception {
        Table table = new Table((Composite)this.shell, 0);
        try {
            SWTObservables.observeText((Control)table);
            Assert.fail((String)"Exception should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void testObserveImageOfButton() throws Exception {
        Button button = new Button((Composite)this.shell, 8);
        ISWTObservableValue value = SWTObservables.observeImage((Widget)button);
        this.assertWidgetObservable((ISWTObservable)value, (Widget)button, ButtonImageProperty.class);
    }

    @Test
    public void testObserveImageOfCLabel() throws Exception {
        CLabel cLabel = new CLabel((Composite)this.shell, 0);
        ISWTObservableValue value = SWTObservables.observeImage((Widget)cLabel);
        this.assertWidgetObservable((ISWTObservable)value, (Widget)cLabel, CLabelImageProperty.class);
    }

    @Test
    public void testObserveImageOfItem() throws Exception {
        CTabFolder ctf = new CTabFolder((Composite)this.shell, 0);
        CTabItem item = new CTabItem(ctf, 0);
        ISWTObservableValue value = SWTObservables.observeImage((Widget)item);
        this.assertWidgetObservable((ISWTObservable)value, (Widget)item, ItemImageProperty.class);
    }

    @Test
    public void testObserveImageOfLabel() throws Exception {
        Label label = new Label((Composite)this.shell, 0);
        ISWTObservableValue value = SWTObservables.observeImage((Widget)label);
        this.assertWidgetObservable((ISWTObservable)value, (Widget)label, LabelImageProperty.class);
    }

    @Test
    public void testObserveTooltipOfItem() throws Exception {
        CTabFolder ctf = new CTabFolder((Composite)this.shell, 0);
        CTabItem item = new CTabItem(ctf, 0);
        ISWTObservableValue value = SWTObservables.observeTooltipText((Widget)item);
        this.assertWidgetObservable((ISWTObservable)value, (Widget)item, CTabItemTooltipTextProperty.class);
    }

    @Test
    public void testObserveTooltipOfUnsupportedControl() throws Exception {
        ToolTip ttip = new ToolTip(this.shell, 0);
        try {
            SWTObservables.observeTooltipText((Widget)ttip);
            Assert.fail((String)"Exception should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void testObserveTooltipOfControl() throws Exception {
        Label label = new Label((Composite)this.shell, 0);
        ISWTObservableValue value = SWTObservables.observeTooltipText((Control)label);
        this.assertWidgetObservable((ISWTObservable)value, (Widget)label, ControlTooltipTextProperty.class);
    }

    @Test
    public void testObserveItemsOfCombo() throws Exception {
        Combo combo = new Combo((Composite)this.shell, 0);
        ISWTObservableList list = (ISWTObservableList)SWTObservables.observeItems((Control)combo);
        this.assertWidgetObservable((ISWTObservable)list, (Widget)combo, ComboItemsProperty.class);
    }

    @Test
    public void testObserveItemsOfCCombo() throws Exception {
        CCombo ccombo = new CCombo((Composite)this.shell, 0);
        ISWTObservableList list = (ISWTObservableList)SWTObservables.observeItems((Control)ccombo);
        this.assertWidgetObservable((ISWTObservable)list, (Widget)ccombo, CComboItemsProperty.class);
    }

    @Test
    public void testObserveItemsOfList() throws Exception {
        List list = new List((Composite)this.shell, 0);
        ISWTObservableList observableList = (ISWTObservableList)SWTObservables.observeItems((Control)list);
        this.assertWidgetObservable((ISWTObservable)observableList, (Widget)list, ListItemsProperty.class);
    }

    @Test
    public void testObserveItemsOfUnsupportedControl() throws Exception {
        Table table = new Table((Composite)this.shell, 0);
        try {
            SWTObservables.observeItems((Control)table);
            Assert.fail((String)"Exception should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void testObserveSingleSelectionIndexOfTable() throws Exception {
        Table table = new Table((Composite)this.shell, 0);
        ISWTObservableValue value = SWTObservables.observeSingleSelectionIndex((Control)table);
        this.assertWidgetObservable((ISWTObservable)value, (Widget)table, TableSingleSelectionIndexProperty.class);
    }

    @Test
    public void testObserveSingleSelectionIndexOfCCombo_DeselectAll() throws Exception {
        CCombo cCombo = new CCombo((Composite)this.shell, 0);
        cCombo.add("item");
        cCombo.select(0);
        ISWTObservableValue value = WidgetProperties.singleSelectionIndex().observe((Widget)cCombo);
        Assert.assertEquals((long)0L, (long)cCombo.getSelectionIndex());
        value.setValue((Object)-1);
        Assert.assertEquals((long)-1L, (long)cCombo.getSelectionIndex());
    }

    @Test
    public void testObserveSingleSelectionIndexOfCCombo_SetValueNull() throws Exception {
        CCombo cCombo = new CCombo((Composite)this.shell, 0);
        cCombo.add("item");
        cCombo.select(0);
        ISWTObservableValue value = WidgetProperties.singleSelectionIndex().observe((Widget)cCombo);
        Assert.assertEquals((long)0L, (long)cCombo.getSelectionIndex());
        value.setValue(null);
        Assert.assertEquals((long)-1L, (long)cCombo.getSelectionIndex());
    }

    @Test
    public void testObserveSingleSelectionIndexOfCombo_DeselectAll() throws Exception {
        Combo combo = new Combo((Composite)this.shell, 0);
        combo.add("item");
        combo.select(0);
        ISWTObservableValue value = WidgetProperties.singleSelectionIndex().observe((Widget)combo);
        Assert.assertEquals((long)0L, (long)combo.getSelectionIndex());
        value.setValue((Object)-1);
        Assert.assertEquals((long)-1L, (long)combo.getSelectionIndex());
    }

    @Test
    public void testObserveSingleSelectionIndexOfCombo_SetValueNull() throws Exception {
        Combo combo = new Combo((Composite)this.shell, 0);
        combo.add("item");
        combo.select(0);
        ISWTObservableValue value = WidgetProperties.singleSelectionIndex().observe((Widget)combo);
        Assert.assertEquals((long)0L, (long)combo.getSelectionIndex());
        value.setValue(null);
        Assert.assertEquals((long)-1L, (long)combo.getSelectionIndex());
    }

    @Test
    public void testObserveSingleSelectionIndexOfList_DeselectAll() throws Exception {
        List list = new List((Composite)this.shell, 0);
        list.add("item");
        list.select(0);
        ISWTObservableValue value = WidgetProperties.singleSelectionIndex().observe((Widget)list);
        Assert.assertEquals((long)0L, (long)list.getSelectionIndex());
        value.setValue((Object)-1);
        Assert.assertEquals((long)-1L, (long)list.getSelectionIndex());
    }

    @Test
    public void testObserveSingleSelectionIndexOfList_SetValueNull() throws Exception {
        List list = new List((Composite)this.shell, 0);
        list.add("item");
        list.select(0);
        ISWTObservableValue value = WidgetProperties.singleSelectionIndex().observe((Widget)list);
        Assert.assertEquals((long)0L, (long)list.getSelectionIndex());
        value.setValue(null);
        Assert.assertEquals((long)-1L, (long)list.getSelectionIndex());
    }

    @Test
    public void testObserveSingleSelectionIndexOfTable_DeselectAll() throws Exception {
        Table table = new Table((Composite)this.shell, 0);
        new TableItem(table, 0);
        table.select(0);
        ISWTObservableValue value = WidgetProperties.singleSelectionIndex().observe((Widget)table);
        Assert.assertEquals((long)0L, (long)table.getSelectionIndex());
        value.setValue((Object)-1);
        Assert.assertEquals((long)-1L, (long)table.getSelectionIndex());
    }

    @Test
    public void testObserveSingleSelectionIndexOfTable_SetValueNull() throws Exception {
        Table table = new Table((Composite)this.shell, 0);
        new TableItem(table, 0);
        table.select(0);
        ISWTObservableValue value = WidgetProperties.singleSelectionIndex().observe((Widget)table);
        Assert.assertEquals((long)0L, (long)table.getSelectionIndex());
        value.setValue(null);
        Assert.assertEquals((long)-1L, (long)table.getSelectionIndex());
    }

    @Test
    public void testObserveSingleSelectionIndexOfUnsupportedControl() throws Exception {
        Tree tree = new Tree((Composite)this.shell, 0);
        try {
            SWTObservables.observeSingleSelectionIndex((Control)tree);
            Assert.fail((String)"Exception should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void testObserveMinOfSpinner() throws Exception {
        Spinner spinner = new Spinner((Composite)this.shell, 0);
        ISWTObservableValue value = SWTObservables.observeMin((Control)spinner);
        this.assertWidgetObservable((ISWTObservable)value, (Widget)spinner, SpinnerMinimumProperty.class);
    }

    @Test
    public void testObserveMinOfScale() throws Exception {
        Scale scale = new Scale((Composite)this.shell, 0);
        ISWTObservableValue value = SWTObservables.observeMin((Control)scale);
        this.assertWidgetObservable((ISWTObservable)value, (Widget)scale, ScaleMinimumProperty.class);
    }

    @Test
    public void testObserveMinOfUnsupportedControl() throws Exception {
        Text text = new Text((Composite)this.shell, 0);
        try {
            SWTObservables.observeMin((Control)text);
            Assert.fail((String)"Exception should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void testObserveMaxOfSpinner() throws Exception {
        Spinner spinner = new Spinner((Composite)this.shell, 0);
        ISWTObservableValue value = SWTObservables.observeMax((Control)spinner);
        this.assertWidgetObservable((ISWTObservable)value, (Widget)spinner, SpinnerMaximumProperty.class);
    }

    @Test
    public void testObserveMaxOfScale() throws Exception {
        Scale scale = new Scale((Composite)this.shell, 0);
        ISWTObservableValue value = SWTObservables.observeMax((Control)scale);
        this.assertWidgetObservable((ISWTObservable)value, (Widget)scale, ScaleMaximumProperty.class);
    }

    @Test
    public void testObserveMaxOfUnsupportedControl() throws Exception {
        Text text = new Text((Composite)this.shell, 0);
        try {
            SWTObservables.observeMax((Control)text);
            Assert.fail((String)"Exception should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void testObserveEditableOfText() throws Exception {
        Text text = new Text((Composite)this.shell, 0);
        ISWTObservableValue value = SWTObservables.observeEditable((Control)text);
        this.assertWidgetObservable((ISWTObservable)value, (Widget)text, TextEditableProperty.class);
    }

    @Test
    public void testObserveEditableOfCCombo() throws Exception {
        CCombo combo = new CCombo((Composite)this.shell, 0);
        ISWTObservableValue value = SWTObservables.observeEditable((Control)combo);
        this.assertWidgetObservable((ISWTObservable)value, (Widget)combo, CComboEditableProperty.class);
    }

    @Test
    public void testObserveEditableOfStyledText() throws Exception {
        StyledText styledText = new StyledText((Composite)this.shell, 0);
        ISWTObservableValue value = SWTObservables.observeEditable((Control)styledText);
        this.assertWidgetObservable((ISWTObservable)value, (Widget)styledText, StyledTextEditableProperty.class);
    }

    @Test
    public void testObserveEnabledOfMenu() throws Exception {
        Menu menu = new Menu((Decorations)this.shell, 2);
        ISWTObservableValue value = SWTObservables.observeEnabled((Widget)menu);
        this.assertWidgetObservable((ISWTObservable)value, (Widget)menu, MenuEnabledProperty.class);
    }

    @Test
    public void testObserveEnabledOfMenuItem() throws Exception {
        Menu menu = new Menu((Decorations)this.shell, 4);
        MenuItem item = new MenuItem(menu, 8);
        ISWTObservableValue value = SWTObservables.observeEnabled((Widget)item);
        this.assertWidgetObservable((ISWTObservable)value, (Widget)item, MenuItemEnabledProperty.class);
    }

    @Test
    public void testObserveSelectionOfMenuItem() throws Exception {
        Menu menu = new Menu((Decorations)this.shell, 4);
        MenuItem item = new MenuItem(menu, 8);
        ISWTObservableValue value = SWTObservables.observeSelection((Widget)item);
        this.assertWidgetObservable((ISWTObservable)value, (Widget)item, MenuItemSelectionProperty.class);
    }

    @Test
    public void testObserveEnabledOfScrollBar() throws Exception {
        ScrollBar scrollBar = this.shell.getVerticalBar();
        ISWTObservableValue value = SWTObservables.observeEnabled((Widget)scrollBar);
        this.assertWidgetObservable((ISWTObservable)value, (Widget)scrollBar, ScrollBarEnabledProperty.class);
    }

    @Test
    public void testObserveEnabledOfToolItem() throws Exception {
        ToolBar bar = new ToolBar((Composite)this.shell, 256);
        ToolItem item = new ToolItem(bar, 8);
        ISWTObservableValue value = SWTObservables.observeEnabled((Widget)item);
        this.assertWidgetObservable((ISWTObservable)value, (Widget)item, ToolItemEnabledProperty.class);
    }

    private void assertWidgetObservable(ISWTObservable observable, Widget widget, Class propertyClass) {
        Assert.assertNotNull((Object)observable);
        Assert.assertTrue((observable.getWidget() == widget ? 1 : 0) != 0);
        IPropertyObservable propertyObservable = this.getPropertyObservable(observable);
        Assert.assertTrue((boolean)propertyClass.isInstance(propertyObservable.getProperty()));
    }

    @Test
    public void testObserveEditableOfUnsupportedControl() throws Exception {
        Label label = new Label((Composite)this.shell, 0);
        try {
            SWTObservables.observeEditable((Control)label);
            Assert.fail((String)"Exception should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }
}

