/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.databinding.swt;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.tests.databinding.observable.ThreadRealm;
import org.eclipse.core.tests.internal.databinding.beans.Bean;
import org.eclipse.jface.databinding.conformance.util.RealmTester;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.tests.databinding.AbstractSWTTestCase;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WidgetObservableThreadTest
extends AbstractSWTTestCase {
    protected ThreadRealm threadRealm;
    private DataBindingContext ctx;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.threadRealm = new ThreadRealm();
        new Thread(){

            @Override
            public void run() {
                RealmTester.setDefault((Realm)WidgetObservableThreadTest.this.threadRealm);
                WidgetObservableThreadTest.this.threadRealm.init(Thread.currentThread());
                WidgetObservableThreadTest.this.threadRealm.block();
            }
        }.start();
        this.threadRealm.waitUntilBlocking();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        if (this.ctx != null) {
            this.threadRealm.exec(() -> {
                this.ctx.dispose();
                this.ctx = null;
            });
            this.threadRealm.processQueue();
        }
        this.threadRealm.unblock();
        this.threadRealm = null;
        super.tearDown();
    }

    @Test
    public void testBindWidgetObservableFromNonDisplayThread() {
        Text text = new Text((Composite)this.getShell(), 2048);
        Bean bean = new Bean("oldValue");
        Assert.assertEquals((Object)"oldValue", (Object)bean.getValue());
        Assert.assertEquals((Object)"", (Object)text.getText());
        this.threadRealm.exec(() -> {
            this.ctx = new DataBindingContext();
            this.ctx.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)text), BeanProperties.value((String)"value").observe((Realm)this.threadRealm, (Object)bean));
        });
        this.threadRealm.processQueue();
        Assert.assertEquals((Object)"oldValue", (Object)bean.getValue());
        Assert.assertEquals((Object)"", (Object)text.getText());
        this.processDisplayQueue();
        this.threadRealm.processQueue();
        Assert.assertEquals((Object)"oldValue", (Object)bean.getValue());
        Assert.assertEquals((Object)"oldValue", (Object)text.getText());
        text.setText("newValue");
        this.threadRealm.processQueue();
        Assert.assertEquals((Object)"newValue", (Object)bean.getValue());
        Assert.assertEquals((Object)"newValue", (Object)text.getText());
        this.threadRealm.exec(() -> bean.setValue("newerValue"));
        this.threadRealm.processQueue();
        Assert.assertEquals((Object)"newerValue", (Object)bean.getValue());
        Assert.assertEquals((Object)"newValue", (Object)text.getText());
        this.processDisplayQueue();
        Assert.assertEquals((Object)"newerValue", (Object)bean.getValue());
        Assert.assertEquals((Object)"newerValue", (Object)text.getText());
    }

    private void processDisplayQueue() {
        while (Display.getCurrent().readAndDispatch()) {
        }
    }
}

