/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.databinding.swt;

import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.jface.databinding.conformance.util.RealmTester;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.tests.databinding.AbstractSWTTestCase;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WidgetPropertiesTest
extends AbstractSWTTestCase {
    private Shell shell;
    private String string1;
    private String string2;
    private Image image1;
    private Image image2;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.shell = this.getShell();
        this.string1 = "1";
        this.string2 = "2";
        this.image1 = this.shell.getDisplay().getSystemImage(8);
        this.image2 = this.shell.getDisplay().getSystemImage(1);
        RealmTester.setDefault((Realm)DisplayRealm.getRealm((Display)this.shell.getDisplay()));
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        RealmTester.setDefault(null);
    }

    @Override
    protected Shell createShell() {
        return new Shell(512);
    }

    @Test
    public void testImage_ObserveButton() {
        Button button = new Button((Composite)this.shell, 8);
        button.setImage(this.image1);
        ISWTObservableValue observable = WidgetProperties.image().observe((Widget)button);
        Assert.assertSame((Object)this.image1, (Object)observable.getValue());
        observable.setValue((Object)this.image2);
        Assert.assertSame((Object)this.image2, (Object)button.getImage());
    }

    @Test
    public void testImage_ObserveCLabel() {
        CLabel label = new CLabel((Composite)this.shell, 0);
        label.setImage(this.image1);
        ISWTObservableValue observable = WidgetProperties.image().observe((Widget)label);
        Assert.assertSame((Object)this.image1, (Object)observable.getValue());
        observable.setValue((Object)this.image2);
        Assert.assertSame((Object)this.image2, (Object)label.getImage());
    }

    @Test
    public void testImage_ObserveLabel() {
        Label label = new Label((Composite)this.shell, 0);
        label.setImage(this.image1);
        ISWTObservableValue observable = WidgetProperties.image().observe((Widget)label);
        Assert.assertSame((Object)this.image1, (Object)observable.getValue());
        observable.setValue((Object)this.image2);
        Assert.assertSame((Object)this.image2, (Object)label.getImage());
    }

    @Test
    public void testText_ObserveButton() {
        Button button = new Button((Composite)this.shell, 8);
        button.setText(this.string1);
        ISWTObservableValue observable = WidgetProperties.text().observe((Widget)button);
        Assert.assertEquals((Object)this.string1, (Object)observable.getValue());
        observable.setValue((Object)this.string2);
        Assert.assertEquals((Object)this.string2, (Object)button.getText());
    }

    @Test
    public void testTooltipText_ObserveCTabItem() {
        CTabFolder tf = new CTabFolder((Composite)this.shell, 0);
        CTabItem item = new CTabItem(tf, 0);
        item.setToolTipText(this.string1);
        ISWTObservableValue observable = WidgetProperties.tooltipText().observe((Widget)item);
        Assert.assertEquals((Object)this.string1, (Object)observable.getValue());
        observable.setValue((Object)this.string2);
        Assert.assertEquals((Object)this.string2, (Object)item.getToolTipText());
    }

    @Test
    public void testTooltipText_ObserveControl() {
        Label control = new Label((Composite)this.shell, 0);
        control.setToolTipText(this.string1);
        ISWTObservableValue observable = WidgetProperties.tooltipText().observe((Widget)control);
        Assert.assertEquals((Object)this.string1, (Object)observable.getValue());
        observable.setValue((Object)this.string2);
        Assert.assertEquals((Object)this.string2, (Object)control.getToolTipText());
    }

    @Test
    public void testTooltipText_ObserveTabItem() {
        TabFolder tf = new TabFolder((Composite)this.shell, 0);
        TabItem item = new TabItem(tf, 0);
        item.setToolTipText(this.string1);
        ISWTObservableValue observable = WidgetProperties.tooltipText().observe((Widget)item);
        Assert.assertEquals((Object)this.string1, (Object)observable.getValue());
        observable.setValue((Object)this.string2);
        Assert.assertEquals((Object)this.string2, (Object)item.getToolTipText());
    }

    @Test
    public void testTooltipText_ObserveTableColumn() {
        Table table = new Table((Composite)this.shell, 0);
        TableColumn column = new TableColumn(table, 0);
        column.setToolTipText(this.string1);
        ISWTObservableValue observable = WidgetProperties.tooltipText().observe((Widget)column);
        Assert.assertEquals((Object)this.string1, (Object)observable.getValue());
        observable.setValue((Object)this.string2);
        Assert.assertEquals((Object)this.string2, (Object)column.getToolTipText());
    }

    @Test
    public void testTooltipText_ObserveToolItem() {
        ToolBar bar = new ToolBar((Composite)this.shell, 0);
        ToolItem item = new ToolItem(bar, 0);
        item.setToolTipText(this.string1);
        ISWTObservableValue observable = WidgetProperties.tooltipText().observe((Widget)item);
        Assert.assertEquals((Object)this.string1, (Object)observable.getValue());
        observable.setValue((Object)this.string2);
        Assert.assertEquals((Object)this.string2, (Object)item.getToolTipText());
    }

    @Test
    public void testTooltipText_ObserveTrayItem() {
        Tray tray = this.shell.getDisplay().getSystemTray();
        TrayItem item = new TrayItem(tray, 0);
        try {
            item.setToolTipText(this.string1);
            ISWTObservableValue observable = WidgetProperties.tooltipText().observe((Widget)item);
            Assert.assertEquals((Object)this.string1, (Object)observable.getValue());
            observable.setValue((Object)this.string2);
            Assert.assertEquals((Object)this.string2, (Object)item.getToolTipText());
        }
        finally {
            item.dispose();
        }
    }

    @Test
    public void testTooltipText_ObserveTreeColumn() {
        Tree tree = new Tree((Composite)this.shell, 0);
        TreeColumn column = new TreeColumn(tree, 0);
        column.setToolTipText(this.string1);
        ISWTObservableValue observable = WidgetProperties.tooltipText().observe((Widget)column);
        Assert.assertEquals((Object)this.string1, (Object)observable.getValue());
        observable.setValue((Object)this.string2);
        Assert.assertEquals((Object)this.string2, (Object)column.getToolTipText());
    }

    @Test
    public void testEnabled_ObserveMenu() {
        Menu menu = new Menu((Decorations)this.shell, 2);
        ISWTObservableValue observable = WidgetProperties.enabled().observe((Widget)menu);
        Assert.assertEquals(Boolean.TYPE, (Object)observable.getValueType());
        menu.setEnabled(true);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)observable.getValue());
        observable.setValue((Object)Boolean.FALSE);
        Assert.assertEquals((Object)false, (Object)menu.getEnabled());
    }

    @Test
    public void testEnabled_ObserveMenuItem() {
        Menu menu = new Menu((Decorations)this.shell, 2);
        MenuItem item = new MenuItem(menu, 8);
        ISWTObservableValue observable = WidgetProperties.enabled().observe((Widget)item);
        Assert.assertEquals(Boolean.TYPE, (Object)observable.getValueType());
        item.setEnabled(true);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)observable.getValue());
        observable.setValue((Object)Boolean.FALSE);
        Assert.assertEquals((Object)false, (Object)item.getEnabled());
    }

    @Test
    public void testSelection_ObserveMenuItem() {
        Menu menu = new Menu((Decorations)this.shell, 2);
        MenuItem item = new MenuItem(menu, 32);
        ISWTObservableValue observable = WidgetProperties.selection().observe((Widget)item);
        Assert.assertEquals(Boolean.TYPE, (Object)observable.getValueType());
        item.setSelection(true);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)observable.getValue());
        observable.setValue((Object)Boolean.FALSE);
        Assert.assertEquals((Object)false, (Object)item.getSelection());
    }

    @Test
    public void testEnabled_ObserveScrollBar() {
        ScrollBar bar = this.shell.getVerticalBar();
        ISWTObservableValue observable = WidgetProperties.enabled().observe((Widget)bar);
        Assert.assertEquals(Boolean.TYPE, (Object)observable.getValueType());
        bar.setEnabled(true);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)observable.getValue());
        observable.setValue((Object)Boolean.FALSE);
        Assert.assertEquals((Object)false, (Object)bar.getEnabled());
    }

    @Test
    public void testEnabled_ObserveToolItem() {
        ToolBar bar = new ToolBar((Composite)this.shell, 256);
        ToolItem item = new ToolItem(bar, 8);
        ISWTObservableValue observable = WidgetProperties.enabled().observe((Widget)item);
        Assert.assertEquals(Boolean.TYPE, (Object)observable.getValueType());
        item.setEnabled(true);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)observable.getValue());
        observable.setValue((Object)Boolean.FALSE);
        Assert.assertEquals((Object)false, (Object)item.getEnabled());
    }

    @Test
    public void testEditable_ObserveText() {
        Text text = new Text((Composite)this.shell, 0);
        ISWTObservableValue observable = WidgetProperties.editable().observe((Widget)text);
        Assert.assertEquals(Boolean.TYPE, (Object)observable.getValueType());
        text.setEditable(false);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)observable.getValue());
        observable.setValue((Object)Boolean.TRUE);
        Assert.assertEquals((Object)true, (Object)text.getEditable());
    }

    @Test
    public void testEditable_ObserveCCombo() {
        CCombo combo = new CCombo((Composite)this.shell, 0);
        ISWTObservableValue observable = WidgetProperties.editable().observe((Widget)combo);
        Assert.assertEquals(Boolean.TYPE, (Object)observable.getValueType());
        combo.setEditable(false);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)observable.getValue());
        observable.setValue((Object)Boolean.TRUE);
        Assert.assertEquals((Object)true, (Object)combo.getEditable());
    }

    @Test
    public void testEditable_ObserveStyledText() {
        StyledText styledText = new StyledText((Composite)this.shell, 0);
        ISWTObservableValue observable = WidgetProperties.editable().observe((Widget)styledText);
        Assert.assertEquals(Boolean.TYPE, (Object)observable.getValueType());
        styledText.setEditable(false);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)observable.getValue());
        observable.setValue((Object)Boolean.TRUE);
        Assert.assertEquals((Object)true, (Object)styledText.getEditable());
    }
}

