/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.examples.databinding.mask.internal;

import org.eclipse.jface.examples.databinding.mask.internal.EditMaskLexerAndToken;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EditMaskLexerAndTokenTest {
    private EditMaskLexerAndToken token;

    @Before
    public void setUp() throws Exception {
        this.token = new EditMaskLexerAndToken();
    }

    @Test
    public void testInitWithNumeric() throws Exception {
        this.token.initializeEditMask("#", 0);
        Assert.assertTrue((String)"Should accept a digit", (boolean)this.token.accept("0"));
        this.token.clear();
        Assert.assertTrue((String)"Should accept a digit", (boolean)this.token.accept("1"));
        this.token.clear();
        Assert.assertTrue((String)"Should accept a digit", (boolean)this.token.accept("2"));
        this.token.clear();
        Assert.assertTrue((String)"Should accept a digit", (boolean)this.token.accept("3"));
        this.token.clear();
        Assert.assertTrue((String)"Should accept a digit", (boolean)this.token.accept("4"));
        this.token.clear();
        Assert.assertTrue((String)"Should accept a digit", (boolean)this.token.accept("5"));
        this.token.clear();
        Assert.assertTrue((String)"Should accept a digit", (boolean)this.token.accept("6"));
        this.token.clear();
        Assert.assertTrue((String)"Should accept a digit", (boolean)this.token.accept("7"));
        this.token.clear();
        Assert.assertTrue((String)"Should accept a digit", (boolean)this.token.accept("8"));
        this.token.clear();
        Assert.assertTrue((String)"Should accept a digit", (boolean)this.token.accept("9"));
        this.token.clear();
        Assert.assertFalse((String)"Should not accept an alpha", (boolean)this.token.accept("A"));
        this.token.clear();
        Assert.assertFalse((String)"Should not accept an alpha", (boolean)this.token.accept("z"));
        Assert.assertFalse((String)"Placeholders are not read-only", (boolean)this.token.isReadOnly());
    }

    @Test
    public void testInitWithLiteral() throws Exception {
        this.token.initializeEditMask("(", 0);
        Assert.assertEquals((String)"Literals automatically set their input", (Object)"(", (Object)this.token.getInput());
        Assert.assertFalse((String)"Literals don't accept anything", (boolean)this.token.accept("("));
        Assert.assertTrue((String)"literals are read-only", (boolean)this.token.isReadOnly());
        Assert.assertTrue((String)"Literals are complete", (boolean)this.token.isComplete());
        Assert.assertFalse((String)"Literals cannot accept characters", (boolean)this.token.canAcceptMoreCharacters());
    }

    @Test
    public void testInitWithBackslashLiteral() throws Exception {
        this.token.initializeEditMask("\\#", 0);
        Assert.assertEquals((String)"Should get backslash literal", (Object)"#", (Object)this.token.getInput());
    }

    @Test
    public void testAcceptWithValidInputAndEmpty() throws Exception {
        this.token.initializeEditMask("#", 0);
        Assert.assertTrue((String)"Should accept a 0", (boolean)this.token.accept("0"));
    }

    @Test
    public void testAcceptWhenParserCannotAcceptMoreCharacters() throws Exception {
        this.token.initializeEditMask("#", 0);
        Assert.assertTrue((String)"Should accept a 0", (boolean)this.token.accept("0"));
        Assert.assertFalse((String)"Should not accept a 0 -- input full", (boolean)this.token.accept("0"));
    }

    @Test
    public void testGetInput() throws Exception {
        this.token.initializeEditMask("#", 0);
        Assert.assertTrue((String)"Should accept a #", (boolean)this.token.accept("0"));
        Assert.assertEquals((Object)this.token.getInput(), (Object)"0");
    }

    @Test
    public void testClear_withNonLiteral() throws Exception {
        this.token.initializeEditMask("#", 0);
        Assert.assertTrue((String)"Should accept a 0", (boolean)this.token.accept("0"));
        Assert.assertNotNull((String)"Input should not be null", (Object)this.token.getInput());
        this.token.clear();
        Assert.assertNull((String)"Input should be null after clear", (Object)this.token.getInput());
    }

    @Test
    public void testClear_withLiteral() throws Exception {
        this.token.initializeEditMask("(", 0);
        Assert.assertNotNull((String)"Input should not be null", (Object)this.token.getInput());
        this.token.clear();
        Assert.assertNotNull((String)"Input should still not be null after clear of read-only literal", (Object)this.token.getInput());
    }

    @Test
    public void testIsComplete_withNonLiteral() throws Exception {
        this.token.initializeEditMask("#", 0);
        Assert.assertFalse((String)"should not be complete", (boolean)this.token.isComplete());
        this.token.accept("1");
        Assert.assertTrue((String)"should be complete", (boolean)this.token.isComplete());
        this.token.clear();
        Assert.assertFalse((String)"should not be complete", (boolean)this.token.isComplete());
    }
}

