/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.internal.databinding.swt;

import junit.framework.TestSuite;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.delegate.IObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.swt.SWTMutableObservableValueContractTest;
import org.eclipse.jface.databinding.conformance.util.ValueChangeEventTracker;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.jface.databinding.swt.ISWTObservable;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CComboObservableValueSelectionTest {
    private Delegate delegate;
    private CCombo combo;

    @Before
    public void setUp() throws Exception {
        this.delegate = new Delegate();
        this.delegate.setUp();
        this.combo = this.delegate.combo;
    }

    @After
    public void tearDown() throws Exception {
        this.delegate.tearDown();
    }

    @Test
    public void testSelection_NotifiesObservable() throws Exception {
        IObservableValue observable = (IObservableValue)this.delegate.createObservable(DisplayRealm.getRealm((Display)Display.getDefault()));
        ValueChangeEventTracker listener = ValueChangeEventTracker.observe((IObservableValue)observable);
        this.combo.select(0);
        Assert.assertEquals((String)"Observable was not notified.", (long)1L, (long)listener.count);
    }

    public static void addConformanceTest(TestSuite suite) {
        suite.addTest(SWTMutableObservableValueContractTest.suite((IObservableValueContractDelegate)new Delegate()));
    }

    static class Delegate
    extends AbstractObservableValueContractDelegate {
        private Shell shell;
        CCombo combo;

        Delegate() {
        }

        public void setUp() {
            this.shell = new Shell();
            this.combo = new CCombo((Composite)this.shell, 0);
            this.combo.add("a");
            this.combo.add("b");
        }

        public void tearDown() {
            this.shell.dispose();
        }

        public IObservableValue createObservableValue(Realm realm) {
            return WidgetProperties.selection().observe(realm, (Object)this.combo);
        }

        public void change(IObservable observable) {
            IObservableValue ov = (IObservableValue)observable;
            ov.setValue(this.createValue(ov));
        }

        public Object getValueType(IObservableValue observable) {
            return String.class;
        }

        public Object createValue(IObservableValue observable) {
            CCombo combo = (CCombo)((ISWTObservable)observable).getWidget();
            switch (combo.getSelectionIndex()) {
                case -1: 
                case 1: {
                    return combo.getItem(0);
                }
                case 0: {
                    return combo.getItem(1);
                }
            }
            throw new RuntimeException("Unexpected selection.");
        }
    }
}

