/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.internal.databinding.swt;

import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.jface.databinding.conformance.util.ValueChangeEventTracker;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.tests.databinding.AbstractSWTTestCase;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.junit.Assert;
import org.junit.Test;

public class CComboObservableValueTest
extends AbstractSWTTestCase {
    @Test
    public void testDispose() throws Exception {
        CCombo combo = new CCombo((Composite)this.getShell(), 0);
        ISWTObservableValue observableValue = SWTObservables.observeText((Control)combo);
        ValueChangeEventTracker testCounterValueChangeListener = new ValueChangeEventTracker();
        observableValue.addValueChangeListener((IValueChangeListener)testCounterValueChangeListener);
        Assert.assertEquals((Object)"", (Object)combo.getText());
        Assert.assertEquals((Object)"", (Object)observableValue.getValue());
        String expected1 = "Test123";
        combo.setText(expected1);
        Assert.assertEquals((long)1L, (long)testCounterValueChangeListener.count);
        Assert.assertEquals((Object)expected1, (Object)combo.getText());
        Assert.assertEquals((Object)expected1, (Object)observableValue.getValue());
        observableValue.dispose();
        String expected2 = "NewValue123";
        combo.setText(expected2);
        Assert.assertEquals((long)1L, (long)testCounterValueChangeListener.count);
        Assert.assertEquals((Object)expected2, (Object)combo.getText());
    }

    @Test
    public void testSetValueWithNull() {
        this.testSetValueWithNull((IValueProperty)WidgetProperties.text());
        this.testSetValueWithNull((IValueProperty)WidgetProperties.selection());
    }

    protected void testSetValueWithNull(IValueProperty property) {
        CCombo combo = new CCombo((Composite)this.getShell(), 0);
        combo.setItems(new String[]{"one", "two", "three"});
        IObservableValue observable = property.observe(Realm.getDefault(), (Object)combo);
        observable.setValue((Object)"two");
        Assert.assertEquals((Object)"two", (Object)combo.getText());
        Assert.assertEquals((long)1L, (long)combo.getSelectionIndex());
        observable.setValue(null);
        Assert.assertEquals((Object)"", (Object)combo.getText());
        Assert.assertEquals((long)-1L, (long)combo.getSelectionIndex());
    }
}

